/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.Database;
import io.ebean.DatabaseFactory;
import io.ebean.DbPrimary;
import io.ebean.EbeanVersion;
import io.ebean.config.BeanNotEnhancedException;
import io.ebean.datasource.DataSourceConfigurationException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DbContext {
    private static final Logger logger = LoggerFactory.getLogger(DbContext.class);
    private static final DbContext INSTANCE;
    private final ConcurrentHashMap<String, Database> concMap = new ConcurrentHashMap();
    private final HashMap<String, Database> syncMap = new HashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private Database defaultDatabase;

    private DbContext() {
        try {
            if (!DbPrimary.isSkip()) {
                String defaultName = DbPrimary.getDefaultServerName();
                logger.debug("defaultName:{}", (Object)defaultName);
                if (defaultName != null && !defaultName.trim().isEmpty()) {
                    this.defaultDatabase = this.getWithCreate(defaultName.trim());
                }
            }
        }
        catch (BeanNotEnhancedException e) {
            throw e;
        }
        catch (DataSourceConfigurationException e) {
            String msg = "Configuration error creating DataSource for the default Database. This typically means a missing application-test.yaml or missing ebean-test dependency. See https://ebean.io/docs/trouble-shooting#datasource";
            throw new DataSourceConfigurationException(msg, (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("Error trying to create the default Database", e);
            throw new RuntimeException(e);
        }
    }

    static DbContext getInstance() {
        return INSTANCE;
    }

    Database getDefault() {
        if (this.defaultDatabase == null) {
            String msg = "The default Database has not been defined?";
            msg = msg + " This is normally set via the ebean.datasource.default property.";
            msg = msg + " Otherwise it should be registered programmatically via registerServer()";
            throw new PersistenceException(msg);
        }
        return this.defaultDatabase;
    }

    Database get(String name) {
        if (name == null || name.isEmpty()) {
            return this.defaultDatabase;
        }
        Database server = this.concMap.get(name);
        if (server != null) {
            return server;
        }
        return this.getWithCreate(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Database getWithCreate(String name) {
        this.lock.lock();
        try {
            Database server = this.syncMap.get(name);
            if (server == null) {
                server = DatabaseFactory.create(name);
                this.register(server, false);
            }
            Database database = server;
            return database;
        }
        finally {
            this.lock.unlock();
        }
    }

    void register(Database server, boolean isDefault) {
        this.registerWithName(server.name(), server, isDefault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWithName(String name, Database server, boolean isDefault) {
        this.lock.lock();
        try {
            this.concMap.put(name, server);
            this.syncMap.put(name, server);
            if (isDefault) {
                this.defaultDatabase = server;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    Database mock(String name, Database server, boolean defaultServer) {
        Database originalPrimaryServer = this.defaultDatabase;
        this.registerWithName(name, server, defaultServer);
        return originalPrimaryServer;
    }

    static {
        EbeanVersion.getVersion();
        INSTANCE = new DbContext();
    }
}

