/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import com.fasterxml.jackson.core.JsonFactory;
import io.avaje.config.Config;
import io.ebean.EbeanVersion;
import io.ebean.PersistenceContextScope;
import io.ebean.annotation.MutationDetection;
import io.ebean.annotation.PersistBatch;
import io.ebean.annotation.Platform;
import io.ebean.cache.ServerCachePlugin;
import io.ebean.config.AutoConfigure;
import io.ebean.config.AutoTuneConfig;
import io.ebean.config.ClassLoadConfig;
import io.ebean.config.ContainerConfig;
import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.CurrentUserProvider;
import io.ebean.config.DbConstraintNaming;
import io.ebean.config.DocStoreConfig;
import io.ebean.config.EncryptDeployManager;
import io.ebean.config.EncryptKeyManager;
import io.ebean.config.Encryptor;
import io.ebean.config.ExternalTransactionManager;
import io.ebean.config.IdGenerator;
import io.ebean.config.JsonConfig;
import io.ebean.config.MatchingNamingConvention;
import io.ebean.config.NamingConvention;
import io.ebean.config.PlatformConfig;
import io.ebean.config.ProfilingConfig;
import io.ebean.config.PropertiesWrapper;
import io.ebean.config.QueryPlanListener;
import io.ebean.config.SlowQueryListener;
import io.ebean.config.TenantCatalogProvider;
import io.ebean.config.TenantDataSourceProvider;
import io.ebean.config.TenantMode;
import io.ebean.config.TenantSchemaProvider;
import io.ebean.config.UnderscoreNamingConvention;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbEncrypt;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.IdType;
import io.ebean.datasource.DataSourceConfig;
import io.ebean.event.BeanFindController;
import io.ebean.event.BeanPersistController;
import io.ebean.event.BeanPersistListener;
import io.ebean.event.BeanPostConstructListener;
import io.ebean.event.BeanPostLoad;
import io.ebean.event.BeanQueryAdapter;
import io.ebean.event.BulkTableEventListener;
import io.ebean.event.ServerConfigStartup;
import io.ebean.event.changelog.ChangeLogListener;
import io.ebean.event.changelog.ChangeLogPrepare;
import io.ebean.event.changelog.ChangeLogRegister;
import io.ebean.event.readaudit.ReadAuditLogger;
import io.ebean.event.readaudit.ReadAuditPrepare;
import io.ebean.util.StringHelper;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.persistence.EnumType;
import javax.sql.DataSource;

public class DatabaseConfig {
    private String name = "db";
    private final Map<String, Object> serviceObject = new HashMap<String, Object>();
    private ContainerConfig containerConfig;
    private Properties properties;
    private String resourceDirectory;
    private boolean register = true;
    private boolean defaultServer = true;
    private boolean disableClasspathSearch;
    private TenantMode tenantMode = TenantMode.NONE;
    private String tenantPartitionColumn = "tenant_id";
    private CurrentTenantProvider currentTenantProvider;
    private TenantDataSourceProvider tenantDataSourceProvider;
    private TenantSchemaProvider tenantSchemaProvider;
    private TenantCatalogProvider tenantCatalogProvider;
    private boolean loadModuleInfo = true;
    private List<Class<?>> classes = new ArrayList();
    private List<String> packages = new ArrayList<String>();
    private DocStoreConfig docStoreConfig = new DocStoreConfig();
    private boolean docStoreOnly;
    private CurrentUserProvider currentUserProvider;
    private AutoTuneConfig autoTuneConfig = new AutoTuneConfig();
    private JsonConfig.DateTime jsonDateTime = JsonConfig.DateTime.ISO8601;
    private JsonConfig.Date jsonDate = JsonConfig.Date.ISO8601;
    private JsonConfig.Include jsonInclude = JsonConfig.Include.ALL;
    private MutationDetection jsonMutationDetection = MutationDetection.HASH;
    private String databasePlatformName;
    private DatabasePlatform databasePlatform;
    private int jdbcFetchSizeFindList;
    private int jdbcFetchSizeFindEach = 100;
    private String asOfViewSuffix = "_with_history";
    private String asOfSysPeriod = "sys_period";
    private String historyTableSuffix = "_history";
    private boolean autoPersistUpdates;
    private PersistBatch persistBatch = PersistBatch.NONE;
    private PersistBatch persistBatchOnCascade = PersistBatch.INHERIT;
    private int persistBatchSize = 20;
    private EnumType defaultEnumType = EnumType.ORDINAL;
    private boolean disableLazyLoading;
    private int lazyLoadBatchSize = 10;
    private int queryBatchSize = 100;
    private boolean eagerFetchLobs;
    private String dataTimeZone;
    private boolean ddlGenerate;
    private boolean ddlRun;
    private boolean ddlExtra = true;
    private boolean ddlCreateOnly;
    private String ddlInitSql;
    private String ddlSeedSql;
    private String ddlHeader;
    private boolean ddlStrictMode = true;
    private String ddlPlaceholders;
    private Map<String, String> ddlPlaceholderMap;
    private boolean runMigration;
    private boolean skipCacheAfterWrite = true;
    private boolean useJtaTransactionManager;
    private ExternalTransactionManager externalTransactionManager;
    private boolean skipDataSourceCheck;
    private DataSource dataSource;
    private DataSource readOnlyDataSource;
    private DataSourceConfig dataSourceConfig = new DataSourceConfig();
    private boolean autoReadOnlyDataSource;
    private DataSourceConfig readOnlyDataSourceConfig = new DataSourceConfig();
    private String dbSchema;
    private ClassLoadConfig classLoadConfig = new ClassLoadConfig();
    private String dataSourceJndiName;
    private NamingConvention namingConvention = new UnderscoreNamingConvention();
    private boolean updateAllPropertiesInBatch;
    private PlatformConfig platformConfig = new PlatformConfig();
    private UuidVersion uuidVersion = UuidVersion.VERSION4;
    private String uuidStateFile;
    private Clock clock = Clock.systemUTC();
    private List<IdGenerator> idGenerators = new ArrayList<IdGenerator>();
    private List<BeanFindController> findControllers = new ArrayList<BeanFindController>();
    private List<BeanPersistController> persistControllers = new ArrayList<BeanPersistController>();
    private List<BeanPostLoad> postLoaders = new ArrayList<BeanPostLoad>();
    private List<BeanPostConstructListener> postConstructListeners = new ArrayList<BeanPostConstructListener>();
    private List<BeanPersistListener> persistListeners = new ArrayList<BeanPersistListener>();
    private List<BeanQueryAdapter> queryAdapters = new ArrayList<BeanQueryAdapter>();
    private final List<BulkTableEventListener> bulkTableEventListeners = new ArrayList<BulkTableEventListener>();
    private final List<ServerConfigStartup> configStartupListeners = new ArrayList<ServerConfigStartup>();
    private boolean changeLogIncludeInserts = true;
    private ChangeLogPrepare changeLogPrepare;
    private ChangeLogListener changeLogListener;
    private ChangeLogRegister changeLogRegister;
    private boolean changeLogAsync = true;
    private ReadAuditLogger readAuditLogger;
    private ReadAuditPrepare readAuditPrepare;
    private EncryptKeyManager encryptKeyManager;
    private EncryptDeployManager encryptDeployManager;
    private Encryptor encryptor;
    private DbEncrypt dbEncrypt;
    private boolean dbOffline;
    private ServerCachePlugin serverCachePlugin;
    private PersistenceContextScope persistenceContextScope = PersistenceContextScope.TRANSACTION;
    private JsonFactory jsonFactory;
    private boolean localTimeWithNanos;
    private boolean durationWithNanos;
    private int maxCallStack = 5;
    private boolean transactionRollbackOnChecked = true;
    private int backgroundExecutorSchedulePoolSize = 1;
    private int backgroundExecutorShutdownSecs = 30;
    private int cacheMaxSize = 10000;
    private int cacheMaxIdleTime = 600;
    private int cacheMaxTimeToLive = 21600;
    private int queryCacheMaxSize = 1000;
    private int queryCacheMaxIdleTime = 600;
    private int queryCacheMaxTimeToLive = 21600;
    private Object objectMapper;
    private boolean expressionEqualsWithNullAsNoop;
    private boolean expressionNativeIlike;
    private String jodaLocalTimeMode;
    private int queryPlanTTLSeconds = 300;
    private boolean disableL2Cache;
    private String enabledL2Regions;
    private boolean localOnlyL2Cache;
    private boolean useValidationNotNull = true;
    private boolean notifyL2CacheInForeground;
    private boolean queryPlanEnable;
    private long queryPlanThresholdMicros = Long.MAX_VALUE;
    private boolean queryPlanCapture;
    private long queryPlanCapturePeriodSecs = 600L;
    private long queryPlanCaptureMaxTimeMillis = 10000L;
    private int queryPlanCaptureMaxCount = 10;
    private QueryPlanListener queryPlanListener;
    private long slowQueryMillis;
    private SlowQueryListener slowQueryListener;
    private ProfilingConfig profilingConfig = new ProfilingConfig();
    private boolean defaultOrderById;
    private List<String> mappingLocations = new ArrayList<String>();
    private boolean idGeneratorAutomatic = true;
    private boolean dumpMetricsOnShutdown;
    private String dumpMetricsOptions;

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public long getSlowQueryMillis() {
        return this.slowQueryMillis;
    }

    public void setSlowQueryMillis(long slowQueryMillis) {
        this.slowQueryMillis = slowQueryMillis;
    }

    public SlowQueryListener getSlowQueryListener() {
        return this.slowQueryListener;
    }

    public void setSlowQueryListener(SlowQueryListener slowQueryListener) {
        this.slowQueryListener = slowQueryListener;
    }

    @Deprecated
    public void setDefaultOrderById(boolean defaultOrderById) {
        this.defaultOrderById = defaultOrderById;
    }

    public boolean isDefaultOrderById() {
        return this.defaultOrderById;
    }

    public void putServiceObject(String key, Object configObject) {
        this.serviceObject.put(key, configObject);
    }

    public Object getServiceObject(String key) {
        return this.serviceObject.get(key);
    }

    public void putServiceObject(Object configObject) {
        String key = this.serviceObjectKey(configObject);
        this.serviceObject.put(key, configObject);
    }

    private String serviceObjectKey(Object configObject) {
        return this.serviceObjectKey(configObject.getClass());
    }

    private String serviceObjectKey(Class<?> cls) {
        String simpleName = cls.getSimpleName();
        return Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
    }

    public <P> P getServiceObject(Class<P> cls) {
        return (P)this.serviceObject.get(this.serviceObjectKey(cls));
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public void setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public JsonConfig.DateTime getJsonDateTime() {
        return this.jsonDateTime;
    }

    public void setJsonDateTime(JsonConfig.DateTime jsonDateTime) {
        this.jsonDateTime = jsonDateTime;
    }

    public JsonConfig.Date getJsonDate() {
        return this.jsonDate;
    }

    public void setJsonDate(JsonConfig.Date jsonDate) {
        this.jsonDate = jsonDate;
    }

    public JsonConfig.Include getJsonInclude() {
        return this.jsonInclude;
    }

    public void setJsonInclude(JsonConfig.Include jsonInclude) {
        this.jsonInclude = jsonInclude;
    }

    public MutationDetection getJsonMutationDetection() {
        return this.jsonMutationDetection;
    }

    public void setJsonMutationDetection(MutationDetection jsonMutationDetection) {
        this.jsonMutationDetection = jsonMutationDetection;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerConfig getContainerConfig() {
        return this.containerConfig;
    }

    public void setContainerConfig(ContainerConfig containerConfig) {
        this.containerConfig = containerConfig;
    }

    public boolean isRegister() {
        return this.register;
    }

    public void setRegister(boolean register) {
        this.register = register;
    }

    public boolean isDefaultServer() {
        return this.defaultServer;
    }

    public void setDefaultServer(boolean defaultServer) {
        this.defaultServer = defaultServer;
    }

    public CurrentUserProvider getCurrentUserProvider() {
        return this.currentUserProvider;
    }

    public void setCurrentUserProvider(CurrentUserProvider currentUserProvider) {
        this.currentUserProvider = currentUserProvider;
    }

    public TenantMode getTenantMode() {
        return this.tenantMode;
    }

    public void setTenantMode(TenantMode tenantMode) {
        this.tenantMode = tenantMode;
    }

    public String getTenantPartitionColumn() {
        return this.tenantPartitionColumn;
    }

    public void setTenantPartitionColumn(String tenantPartitionColumn) {
        this.tenantPartitionColumn = tenantPartitionColumn;
    }

    public CurrentTenantProvider getCurrentTenantProvider() {
        return this.currentTenantProvider;
    }

    public void setCurrentTenantProvider(CurrentTenantProvider currentTenantProvider) {
        this.currentTenantProvider = currentTenantProvider;
    }

    public TenantDataSourceProvider getTenantDataSourceProvider() {
        return this.tenantDataSourceProvider;
    }

    public void setTenantDataSourceProvider(TenantDataSourceProvider tenantDataSourceProvider) {
        this.tenantDataSourceProvider = tenantDataSourceProvider;
    }

    public TenantSchemaProvider getTenantSchemaProvider() {
        return this.tenantSchemaProvider;
    }

    public void setTenantSchemaProvider(TenantSchemaProvider tenantSchemaProvider) {
        this.tenantSchemaProvider = tenantSchemaProvider;
    }

    public TenantCatalogProvider getTenantCatalogProvider() {
        return this.tenantCatalogProvider;
    }

    public void setTenantCatalogProvider(TenantCatalogProvider tenantCatalogProvider) {
        this.tenantCatalogProvider = tenantCatalogProvider;
    }

    public boolean isAutoPersistUpdates() {
        return this.autoPersistUpdates;
    }

    public void setAutoPersistUpdates(boolean autoPersistUpdates) {
        this.autoPersistUpdates = autoPersistUpdates;
    }

    public PersistBatch getPersistBatch() {
        return this.persistBatch;
    }

    public void setPersistBatch(PersistBatch persistBatch) {
        this.persistBatch = persistBatch;
    }

    public PersistBatch getPersistBatchOnCascade() {
        return this.persistBatchOnCascade;
    }

    public void setPersistBatchOnCascade(PersistBatch persistBatchOnCascade) {
        this.persistBatchOnCascade = persistBatchOnCascade;
    }

    public void setPersistBatching(boolean persistBatching) {
        this.persistBatch = persistBatching ? PersistBatch.ALL : PersistBatch.NONE;
    }

    public int getPersistBatchSize() {
        return this.persistBatchSize;
    }

    public void setPersistBatchSize(int persistBatchSize) {
        this.persistBatchSize = persistBatchSize;
    }

    public int getQueryBatchSize() {
        return this.queryBatchSize;
    }

    public void setQueryBatchSize(int queryBatchSize) {
        this.queryBatchSize = queryBatchSize;
    }

    public EnumType getDefaultEnumType() {
        return this.defaultEnumType;
    }

    public void setDefaultEnumType(EnumType defaultEnumType) {
        this.defaultEnumType = defaultEnumType;
    }

    public boolean isDisableLazyLoading() {
        return this.disableLazyLoading;
    }

    public void setDisableLazyLoading(boolean disableLazyLoading) {
        this.disableLazyLoading = disableLazyLoading;
    }

    public int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    public void setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.lazyLoadBatchSize = lazyLoadBatchSize;
    }

    public void setDatabaseSequenceBatchSize(int databaseSequenceBatchSize) {
        this.platformConfig.setDatabaseSequenceBatchSize(databaseSequenceBatchSize);
    }

    public int getJdbcFetchSizeFindList() {
        return this.jdbcFetchSizeFindList;
    }

    public void setJdbcFetchSizeFindList(int jdbcFetchSizeFindList) {
        this.jdbcFetchSizeFindList = jdbcFetchSizeFindList;
    }

    public int getJdbcFetchSizeFindEach() {
        return this.jdbcFetchSizeFindEach;
    }

    public void setJdbcFetchSizeFindEach(int jdbcFetchSizeFindEach) {
        this.jdbcFetchSizeFindEach = jdbcFetchSizeFindEach;
    }

    public ChangeLogPrepare getChangeLogPrepare() {
        return this.changeLogPrepare;
    }

    public void setChangeLogPrepare(ChangeLogPrepare changeLogPrepare) {
        this.changeLogPrepare = changeLogPrepare;
    }

    public ChangeLogListener getChangeLogListener() {
        return this.changeLogListener;
    }

    public void setChangeLogListener(ChangeLogListener changeLogListener) {
        this.changeLogListener = changeLogListener;
    }

    public ChangeLogRegister getChangeLogRegister() {
        return this.changeLogRegister;
    }

    public void setChangeLogRegister(ChangeLogRegister changeLogRegister) {
        this.changeLogRegister = changeLogRegister;
    }

    public boolean isChangeLogIncludeInserts() {
        return this.changeLogIncludeInserts;
    }

    public void setChangeLogIncludeInserts(boolean changeLogIncludeInserts) {
        this.changeLogIncludeInserts = changeLogIncludeInserts;
    }

    public boolean isChangeLogAsync() {
        return this.changeLogAsync;
    }

    public void setChangeLogAsync(boolean changeLogAsync) {
        this.changeLogAsync = changeLogAsync;
    }

    public ReadAuditLogger getReadAuditLogger() {
        return this.readAuditLogger;
    }

    public void setReadAuditLogger(ReadAuditLogger readAuditLogger) {
        this.readAuditLogger = readAuditLogger;
    }

    public ReadAuditPrepare getReadAuditPrepare() {
        return this.readAuditPrepare;
    }

    public void setReadAuditPrepare(ReadAuditPrepare readAuditPrepare) {
        this.readAuditPrepare = readAuditPrepare;
    }

    public ProfilingConfig getProfilingConfig() {
        return this.profilingConfig;
    }

    public void setProfilingConfig(ProfilingConfig profilingConfig) {
        this.profilingConfig = profilingConfig;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public int getGeometrySRID() {
        return this.platformConfig.getGeometrySRID();
    }

    public void setGeometrySRID(int geometrySRID) {
        this.platformConfig.setGeometrySRID(geometrySRID);
    }

    public String getDataTimeZone() {
        return System.getProperty("ebean.dataTimeZone", this.dataTimeZone);
    }

    public void setDataTimeZone(String dataTimeZone) {
        this.dataTimeZone = dataTimeZone;
    }

    public String getAsOfViewSuffix() {
        return this.asOfViewSuffix;
    }

    public void setAsOfViewSuffix(String asOfViewSuffix) {
        this.asOfViewSuffix = asOfViewSuffix;
    }

    public String getAsOfSysPeriod() {
        return this.asOfSysPeriod;
    }

    public void setAsOfSysPeriod(String asOfSysPeriod) {
        this.asOfSysPeriod = asOfSysPeriod;
    }

    public String getHistoryTableSuffix() {
        return this.historyTableSuffix;
    }

    public void setHistoryTableSuffix(String historyTableSuffix) {
        this.historyTableSuffix = historyTableSuffix;
    }

    public boolean isUseJtaTransactionManager() {
        return this.useJtaTransactionManager;
    }

    public void setUseJtaTransactionManager(boolean useJtaTransactionManager) {
        this.useJtaTransactionManager = useJtaTransactionManager;
    }

    public ExternalTransactionManager getExternalTransactionManager() {
        return this.externalTransactionManager;
    }

    public void setExternalTransactionManager(ExternalTransactionManager externalTransactionManager) {
        this.externalTransactionManager = externalTransactionManager;
    }

    public ServerCachePlugin getServerCachePlugin() {
        return this.serverCachePlugin;
    }

    public void setServerCachePlugin(ServerCachePlugin serverCachePlugin) {
        this.serverCachePlugin = serverCachePlugin;
    }

    public boolean isEagerFetchLobs() {
        return this.eagerFetchLobs;
    }

    public void setEagerFetchLobs(boolean eagerFetchLobs) {
        this.eagerFetchLobs = eagerFetchLobs;
    }

    public int getMaxCallStack() {
        return this.maxCallStack;
    }

    public void setMaxCallStack(int maxCallStack) {
        this.maxCallStack = maxCallStack;
    }

    public boolean isTransactionRollbackOnChecked() {
        return this.transactionRollbackOnChecked;
    }

    public void setTransactionRollbackOnChecked(boolean transactionRollbackOnChecked) {
        this.transactionRollbackOnChecked = transactionRollbackOnChecked;
    }

    public int getBackgroundExecutorSchedulePoolSize() {
        return this.backgroundExecutorSchedulePoolSize;
    }

    public void setBackgroundExecutorSchedulePoolSize(int backgroundExecutorSchedulePoolSize) {
        this.backgroundExecutorSchedulePoolSize = backgroundExecutorSchedulePoolSize;
    }

    public int getBackgroundExecutorShutdownSecs() {
        return this.backgroundExecutorShutdownSecs;
    }

    public void setBackgroundExecutorShutdownSecs(int backgroundExecutorShutdownSecs) {
        this.backgroundExecutorShutdownSecs = backgroundExecutorShutdownSecs;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public int getCacheMaxIdleTime() {
        return this.cacheMaxIdleTime;
    }

    public void setCacheMaxIdleTime(int cacheMaxIdleTime) {
        this.cacheMaxIdleTime = cacheMaxIdleTime;
    }

    public int getCacheMaxTimeToLive() {
        return this.cacheMaxTimeToLive;
    }

    public void setCacheMaxTimeToLive(int cacheMaxTimeToLive) {
        this.cacheMaxTimeToLive = cacheMaxTimeToLive;
    }

    public int getQueryCacheMaxSize() {
        return this.queryCacheMaxSize;
    }

    public void setQueryCacheMaxSize(int queryCacheMaxSize) {
        this.queryCacheMaxSize = queryCacheMaxSize;
    }

    public int getQueryCacheMaxIdleTime() {
        return this.queryCacheMaxIdleTime;
    }

    public void setQueryCacheMaxIdleTime(int queryCacheMaxIdleTime) {
        this.queryCacheMaxIdleTime = queryCacheMaxIdleTime;
    }

    public int getQueryCacheMaxTimeToLive() {
        return this.queryCacheMaxTimeToLive;
    }

    public void setQueryCacheMaxTimeToLive(int queryCacheMaxTimeToLive) {
        this.queryCacheMaxTimeToLive = queryCacheMaxTimeToLive;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public boolean isAllQuotedIdentifiers() {
        return this.platformConfig.isAllQuotedIdentifiers();
    }

    public void setAllQuotedIdentifiers(boolean allQuotedIdentifiers) {
        this.platformConfig.setAllQuotedIdentifiers(allQuotedIdentifiers);
        if (allQuotedIdentifiers) {
            this.adjustNamingConventionForAllQuoted();
        }
    }

    private void adjustNamingConventionForAllQuoted() {
        if (this.namingConvention instanceof UnderscoreNamingConvention) {
            this.namingConvention = new MatchingNamingConvention();
        }
    }

    public boolean isDocStoreOnly() {
        return this.docStoreOnly;
    }

    public void setDocStoreOnly(boolean docStoreOnly) {
        this.docStoreOnly = docStoreOnly;
    }

    public DocStoreConfig getDocStoreConfig() {
        return this.docStoreConfig;
    }

    public void setDocStoreConfig(DocStoreConfig docStoreConfig) {
        this.docStoreConfig = docStoreConfig;
    }

    public DbConstraintNaming getConstraintNaming() {
        return this.platformConfig.getConstraintNaming();
    }

    public void setConstraintNaming(DbConstraintNaming constraintNaming) {
        this.platformConfig.setConstraintNaming(constraintNaming);
    }

    public AutoTuneConfig getAutoTuneConfig() {
        return this.autoTuneConfig;
    }

    public void setAutoTuneConfig(AutoTuneConfig autoTuneConfig) {
        this.autoTuneConfig = autoTuneConfig;
    }

    public boolean skipDataSourceCheck() {
        return this.skipDataSourceCheck;
    }

    public void setSkipDataSourceCheck(boolean skipDataSourceCheck) {
        this.skipDataSourceCheck = skipDataSourceCheck;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getReadOnlyDataSource() {
        return this.readOnlyDataSource;
    }

    public void setReadOnlyDataSource(DataSource readOnlyDataSource) {
        this.readOnlyDataSource = readOnlyDataSource;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    public void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public boolean isAutoReadOnlyDataSource() {
        return this.autoReadOnlyDataSource;
    }

    public void setAutoReadOnlyDataSource(boolean autoReadOnlyDataSource) {
        this.autoReadOnlyDataSource = autoReadOnlyDataSource;
    }

    public DataSourceConfig getReadOnlyDataSourceConfig() {
        return this.readOnlyDataSourceConfig;
    }

    public void setReadOnlyDataSourceConfig(DataSourceConfig readOnlyDataSourceConfig) {
        this.readOnlyDataSourceConfig = readOnlyDataSourceConfig;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public String getDatabaseBooleanTrue() {
        return this.platformConfig.getDatabaseBooleanTrue();
    }

    public void setDatabaseBooleanTrue(String databaseTrue) {
        this.platformConfig.setDatabaseBooleanTrue(databaseTrue);
    }

    public String getDatabaseBooleanFalse() {
        return this.platformConfig.getDatabaseBooleanFalse();
    }

    public void setDatabaseBooleanFalse(String databaseFalse) {
        this.platformConfig.setDatabaseBooleanFalse(databaseFalse);
    }

    public int getDatabaseSequenceBatchSize() {
        return this.platformConfig.getDatabaseSequenceBatchSize();
    }

    public void setDatabaseSequenceBatch(int databaseSequenceBatchSize) {
        this.platformConfig.setDatabaseSequenceBatchSize(databaseSequenceBatchSize);
    }

    public String getDatabasePlatformName() {
        return this.databasePlatformName;
    }

    public void setDatabasePlatformName(String databasePlatformName) {
        this.databasePlatformName = databasePlatformName;
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public IdType getIdType() {
        return this.platformConfig.getIdType();
    }

    public void setIdType(IdType idType) {
        this.platformConfig.setIdType(idType);
    }

    public EncryptKeyManager getEncryptKeyManager() {
        return this.encryptKeyManager;
    }

    public void setEncryptKeyManager(EncryptKeyManager encryptKeyManager) {
        this.encryptKeyManager = encryptKeyManager;
    }

    public EncryptDeployManager getEncryptDeployManager() {
        return this.encryptDeployManager;
    }

    public void setEncryptDeployManager(EncryptDeployManager encryptDeployManager) {
        this.encryptDeployManager = encryptDeployManager;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public boolean isDbOffline() {
        return this.dbOffline;
    }

    public void setDbOffline(boolean dbOffline) {
        this.dbOffline = dbOffline;
    }

    public DbEncrypt getDbEncrypt() {
        return this.dbEncrypt;
    }

    public void setDbEncrypt(DbEncrypt dbEncrypt) {
        this.dbEncrypt = dbEncrypt;
    }

    public PlatformConfig getPlatformConfig() {
        return this.platformConfig;
    }

    public void setPlatformConfig(PlatformConfig platformConfig) {
        this.platformConfig = platformConfig;
    }

    public void setDbUuid(PlatformConfig.DbUuid dbUuid) {
        this.platformConfig.setDbUuid(dbUuid);
    }

    public UuidVersion getUuidVersion() {
        return this.uuidVersion;
    }

    public void setUuidVersion(UuidVersion uuidVersion) {
        this.uuidVersion = uuidVersion;
    }

    public String getUuidStateFile() {
        if (this.uuidStateFile == null || this.uuidStateFile.isEmpty()) {
            this.uuidStateFile = this.name + "-uuid.state";
            String homeDir = System.getProperty("user.home");
            if (homeDir != null && homeDir.isEmpty()) {
                this.uuidStateFile = homeDir + "/.ebean/" + this.uuidStateFile;
            }
        }
        return this.uuidStateFile;
    }

    public void setUuidStateFile(String uuidStateFile) {
        this.uuidStateFile = uuidStateFile;
    }

    public boolean isLocalTimeWithNanos() {
        return this.localTimeWithNanos;
    }

    public void setLocalTimeWithNanos(boolean localTimeWithNanos) {
        this.localTimeWithNanos = localTimeWithNanos;
    }

    public boolean isDurationWithNanos() {
        return this.durationWithNanos;
    }

    public void setDurationWithNanos(boolean durationWithNanos) {
        this.durationWithNanos = durationWithNanos;
    }

    public void setRunMigration(boolean runMigration) {
        this.runMigration = runMigration;
    }

    public boolean isRunMigration() {
        String run = System.getProperty("ebean.migration.run");
        return run != null ? Boolean.parseBoolean(run) : this.runMigration;
    }

    public void setDdlGenerate(boolean ddlGenerate) {
        this.ddlGenerate = ddlGenerate;
    }

    public void setDdlRun(boolean ddlRun) {
        this.ddlRun = ddlRun;
    }

    public void setDdlExtra(boolean ddlExtra) {
        this.ddlExtra = ddlExtra;
    }

    public boolean isDdlCreateOnly() {
        return this.ddlCreateOnly;
    }

    public void setDdlCreateOnly(boolean ddlCreateOnly) {
        this.ddlCreateOnly = ddlCreateOnly;
    }

    public String getDdlSeedSql() {
        return this.ddlSeedSql;
    }

    public void setDdlSeedSql(String ddlSeedSql) {
        this.ddlSeedSql = ddlSeedSql;
    }

    public String getDdlInitSql() {
        return this.ddlInitSql;
    }

    public void setDdlInitSql(String ddlInitSql) {
        this.ddlInitSql = ddlInitSql;
    }

    public boolean isDdlGenerate() {
        return this.ddlGenerate;
    }

    public boolean isDdlRun() {
        return this.ddlRun;
    }

    public boolean isDdlExtra() {
        return this.ddlExtra;
    }

    public void setDdlHeader(String ddlHeader) {
        this.ddlHeader = ddlHeader;
    }

    public String getDdlHeader() {
        if (this.ddlHeader != null && !this.ddlHeader.isEmpty()) {
            String header = this.ddlHeader.replace("${version}", EbeanVersion.getVersion());
            header = header.replace("${timestamp}", ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT));
            return header;
        }
        return this.ddlHeader;
    }

    public boolean isDdlStrictMode() {
        return this.ddlStrictMode;
    }

    public void setDdlStrictMode(boolean ddlStrictMode) {
        this.ddlStrictMode = ddlStrictMode;
    }

    public String getDdlPlaceholders() {
        return this.ddlPlaceholders;
    }

    public void setDdlPlaceholders(String ddlPlaceholders) {
        this.ddlPlaceholders = ddlPlaceholders;
    }

    public Map<String, String> getDdlPlaceholderMap() {
        return this.ddlPlaceholderMap;
    }

    public void setDdlPlaceholderMap(Map<String, String> ddlPlaceholderMap) {
        this.ddlPlaceholderMap = ddlPlaceholderMap;
    }

    public boolean isDisableClasspathSearch() {
        return this.disableClasspathSearch;
    }

    public void setDisableClasspathSearch(boolean disableClasspathSearch) {
        this.disableClasspathSearch = disableClasspathSearch;
    }

    public String getJodaLocalTimeMode() {
        return this.jodaLocalTimeMode;
    }

    public void setJodaLocalTimeMode(String jodaLocalTimeMode) {
        this.jodaLocalTimeMode = jodaLocalTimeMode;
    }

    public void addClass(Class<?> cls) {
        this.classes.add(cls);
    }

    public void addAll(List<Class<?>> classList) {
        if (classList != null && !classList.isEmpty()) {
            this.classes.addAll(classList);
        }
    }

    public void addPackage(String packageName) {
        this.packages.add(packageName);
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public void setClasses(List<Class<?>> classes) {
        this.classes = classes;
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }

    public boolean isSkipCacheAfterWrite() {
        return this.skipCacheAfterWrite;
    }

    public void setSkipCacheAfterWrite(boolean skipCacheAfterWrite) {
        this.skipCacheAfterWrite = skipCacheAfterWrite;
    }

    public boolean isUpdateAllPropertiesInBatch() {
        return this.updateAllPropertiesInBatch;
    }

    public void setUpdateAllPropertiesInBatch(boolean updateAllPropertiesInBatch) {
        this.updateAllPropertiesInBatch = updateAllPropertiesInBatch;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    public void setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public void addCustomMapping(DbType type, String columnDefinition, Platform platform) {
        this.platformConfig.addCustomMapping(type, columnDefinition, platform);
    }

    public void addCustomMapping(DbType type, String columnDefinition) {
        this.platformConfig.addCustomMapping(type, columnDefinition);
    }

    public void add(BeanQueryAdapter beanQueryAdapter) {
        this.queryAdapters.add(beanQueryAdapter);
    }

    public List<BeanQueryAdapter> getQueryAdapters() {
        return this.queryAdapters;
    }

    public void setQueryAdapters(List<BeanQueryAdapter> queryAdapters) {
        this.queryAdapters = queryAdapters;
    }

    public List<IdGenerator> getIdGenerators() {
        return this.idGenerators;
    }

    public void setIdGenerators(List<IdGenerator> idGenerators) {
        this.idGenerators = idGenerators;
    }

    public void add(IdGenerator idGenerator) {
        this.idGenerators.add(idGenerator);
    }

    public void add(BeanPersistController beanPersistController) {
        this.persistControllers.add(beanPersistController);
    }

    public void add(BeanPostLoad postLoad) {
        this.postLoaders.add(postLoad);
    }

    public void add(BeanPostConstructListener listener) {
        this.postConstructListeners.add(listener);
    }

    public List<BeanFindController> getFindControllers() {
        return this.findControllers;
    }

    public void setFindControllers(List<BeanFindController> findControllers) {
        this.findControllers = findControllers;
    }

    public List<BeanPostLoad> getPostLoaders() {
        return this.postLoaders;
    }

    public void setPostLoaders(List<BeanPostLoad> postLoaders) {
        this.postLoaders = postLoaders;
    }

    public List<BeanPostConstructListener> getPostConstructListeners() {
        return this.postConstructListeners;
    }

    public void setPostConstructListeners(List<BeanPostConstructListener> listeners) {
        this.postConstructListeners = listeners;
    }

    public List<BeanPersistController> getPersistControllers() {
        return this.persistControllers;
    }

    public void setPersistControllers(List<BeanPersistController> persistControllers) {
        this.persistControllers = persistControllers;
    }

    public void add(BeanPersistListener beanPersistListener) {
        this.persistListeners.add(beanPersistListener);
    }

    public List<BeanPersistListener> getPersistListeners() {
        return this.persistListeners;
    }

    public void add(BulkTableEventListener bulkTableEventListener) {
        this.bulkTableEventListeners.add(bulkTableEventListener);
    }

    public List<BulkTableEventListener> getBulkTableEventListeners() {
        return this.bulkTableEventListeners;
    }

    public void addServerConfigStartup(ServerConfigStartup configStartupListener) {
        this.configStartupListeners.add(configStartupListener);
    }

    public List<ServerConfigStartup> getServerConfigStartupListeners() {
        return this.configStartupListeners;
    }

    public void setPersistListeners(List<BeanPersistListener> persistListeners) {
        this.persistListeners = persistListeners;
    }

    public PersistenceContextScope getPersistenceContextScope() {
        return this.persistenceContextScope == null ? PersistenceContextScope.TRANSACTION : this.persistenceContextScope;
    }

    public void setPersistenceContextScope(PersistenceContextScope persistenceContextScope) {
        this.persistenceContextScope = persistenceContextScope;
    }

    public ClassLoadConfig getClassLoadConfig() {
        return this.classLoadConfig;
    }

    public void setClassLoadConfig(ClassLoadConfig classLoadConfig) {
        this.classLoadConfig = classLoadConfig;
    }

    public void loadFromProperties() {
        this.properties = Config.asProperties();
        this.configureFromProperties();
    }

    public void loadFromProperties(Properties properties) {
        this.properties = Config.asConfiguration().eval(properties);
        this.configureFromProperties();
    }

    private void configureFromProperties() {
        List<AutoConfigure> autoConfigures = this.autoConfiguration();
        this.loadSettings(new PropertiesWrapper("ebean", this.name, this.properties, this.classLoadConfig));
        for (AutoConfigure autoConfigure : autoConfigures) {
            autoConfigure.postConfigure(this);
        }
    }

    private List<AutoConfigure> autoConfiguration() {
        ArrayList<AutoConfigure> list = new ArrayList<AutoConfigure>();
        for (AutoConfigure autoConfigure : ServiceLoader.load(AutoConfigure.class)) {
            autoConfigure.preConfigure(this);
            list.add(autoConfigure);
        }
        return list;
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected void loadDataSourceSettings(PropertiesWrapper p) {
        this.dataSourceConfig.loadSettings(p.properties, this.name);
        this.readOnlyDataSourceConfig.loadSettings(p.properties, this.name + "-ro");
    }

    protected void loadDocStoreSettings(PropertiesWrapper p) {
        this.docStoreConfig.loadSettings(p);
    }

    protected void loadAutoTuneSettings(PropertiesWrapper p) {
        this.autoTuneConfig.loadSettings(p);
    }

    protected void loadSettings(PropertiesWrapper p) {
        this.dbSchema = p.get("dbSchema", this.dbSchema);
        this.profilingConfig.loadSettings(p, this.name);
        this.platformConfig.loadSettings(p);
        if (this.platformConfig.isAllQuotedIdentifiers()) {
            this.adjustNamingConventionForAllQuoted();
        }
        this.namingConvention = this.createNamingConvention(p, this.namingConvention);
        if (this.namingConvention != null) {
            this.namingConvention.loadFromProperties(p);
        }
        if (this.autoTuneConfig == null) {
            this.autoTuneConfig = new AutoTuneConfig();
        }
        this.loadAutoTuneSettings(p);
        if (this.dataSourceConfig == null) {
            this.dataSourceConfig = new DataSourceConfig();
        }
        this.loadDataSourceSettings(p);
        if (this.docStoreConfig == null) {
            this.docStoreConfig = new DocStoreConfig();
        }
        this.loadDocStoreSettings(p);
        this.defaultServer = p.getBoolean("defaultServer", this.defaultServer);
        this.autoPersistUpdates = p.getBoolean("autoPersistUpdates", this.autoPersistUpdates);
        this.loadModuleInfo = p.getBoolean("loadModuleInfo", this.loadModuleInfo);
        this.maxCallStack = p.getInt("maxCallStack", this.maxCallStack);
        this.dumpMetricsOnShutdown = p.getBoolean("dumpMetricsOnShutdown", this.dumpMetricsOnShutdown);
        this.dumpMetricsOptions = p.get("dumpMetricsOptions", this.dumpMetricsOptions);
        this.queryPlanTTLSeconds = p.getInt("queryPlanTTLSeconds", this.queryPlanTTLSeconds);
        this.slowQueryMillis = p.getLong("slowQueryMillis", this.slowQueryMillis);
        this.queryPlanEnable = p.getBoolean("queryPlan.enable", this.queryPlanEnable);
        this.queryPlanThresholdMicros = p.getLong("queryPlan.thresholdMicros", this.queryPlanThresholdMicros);
        this.queryPlanCapture = p.getBoolean("queryPlan.capture", this.queryPlanCapture);
        this.queryPlanCapturePeriodSecs = p.getLong("queryPlan.capturePeriodSecs", this.queryPlanCapturePeriodSecs);
        this.queryPlanCaptureMaxTimeMillis = p.getLong("queryPlan.captureMaxTimeMillis", this.queryPlanCaptureMaxTimeMillis);
        this.queryPlanCaptureMaxCount = p.getInt("queryPlan.captureMaxCount", this.queryPlanCaptureMaxCount);
        this.docStoreOnly = p.getBoolean("docStoreOnly", this.docStoreOnly);
        this.disableL2Cache = p.getBoolean("disableL2Cache", this.disableL2Cache);
        this.localOnlyL2Cache = p.getBoolean("localOnlyL2Cache", this.localOnlyL2Cache);
        this.enabledL2Regions = p.get("enabledL2Regions", this.enabledL2Regions);
        this.notifyL2CacheInForeground = p.getBoolean("notifyL2CacheInForeground", this.notifyL2CacheInForeground);
        this.useJtaTransactionManager = p.getBoolean("useJtaTransactionManager", this.useJtaTransactionManager);
        this.useValidationNotNull = p.getBoolean("useValidationNotNull", this.useValidationNotNull);
        this.autoReadOnlyDataSource = p.getBoolean("autoReadOnlyDataSource", this.autoReadOnlyDataSource);
        this.idGeneratorAutomatic = p.getBoolean("idGeneratorAutomatic", this.idGeneratorAutomatic);
        this.backgroundExecutorSchedulePoolSize = p.getInt("backgroundExecutorSchedulePoolSize", this.backgroundExecutorSchedulePoolSize);
        this.backgroundExecutorShutdownSecs = p.getInt("backgroundExecutorShutdownSecs", this.backgroundExecutorShutdownSecs);
        this.disableClasspathSearch = p.getBoolean("disableClasspathSearch", this.disableClasspathSearch);
        this.currentUserProvider = p.createInstance(CurrentUserProvider.class, "currentUserProvider", this.currentUserProvider);
        this.databasePlatform = p.createInstance(DatabasePlatform.class, "databasePlatform", this.databasePlatform);
        this.encryptKeyManager = p.createInstance(EncryptKeyManager.class, "encryptKeyManager", this.encryptKeyManager);
        this.encryptDeployManager = p.createInstance(EncryptDeployManager.class, "encryptDeployManager", this.encryptDeployManager);
        this.encryptor = p.createInstance(Encryptor.class, "encryptor", this.encryptor);
        this.dbEncrypt = p.createInstance(DbEncrypt.class, "dbEncrypt", this.dbEncrypt);
        this.dbOffline = p.getBoolean("dbOffline", this.dbOffline);
        this.serverCachePlugin = p.createInstance(ServerCachePlugin.class, "serverCachePlugin", this.serverCachePlugin);
        String packagesProp = p.get("search.packages", p.get("packages", null));
        this.packages = this.getSearchList(packagesProp, this.packages);
        this.skipCacheAfterWrite = p.getBoolean("skipCacheAfterWrite", this.skipCacheAfterWrite);
        this.updateAllPropertiesInBatch = p.getBoolean("updateAllPropertiesInBatch", this.updateAllPropertiesInBatch);
        if (p.get("batch.mode") != null || p.get("persistBatching") != null) {
            throw new IllegalArgumentException("Property 'batch.mode' or 'persistBatching' is being set but no longer used. Please change to use 'persistBatchMode'");
        }
        this.persistBatch = p.getEnum(PersistBatch.class, "persistBatch", this.persistBatch);
        this.persistBatchOnCascade = p.getEnum(PersistBatch.class, "persistBatchOnCascade", this.persistBatchOnCascade);
        int batchSize = p.getInt("batch.size", this.persistBatchSize);
        this.persistBatchSize = p.getInt("persistBatchSize", batchSize);
        this.persistenceContextScope = PersistenceContextScope.valueOf(p.get("persistenceContextScope", "TRANSACTION"));
        this.changeLogAsync = p.getBoolean("changeLogAsync", this.changeLogAsync);
        this.changeLogIncludeInserts = p.getBoolean("changeLogIncludeInserts", this.changeLogIncludeInserts);
        this.expressionEqualsWithNullAsNoop = p.getBoolean("expressionEqualsWithNullAsNoop", this.expressionEqualsWithNullAsNoop);
        this.expressionNativeIlike = p.getBoolean("expressionNativeIlike", this.expressionNativeIlike);
        this.dataTimeZone = p.get("dataTimeZone", this.dataTimeZone);
        this.asOfViewSuffix = p.get("asOfViewSuffix", this.asOfViewSuffix);
        this.asOfSysPeriod = p.get("asOfSysPeriod", this.asOfSysPeriod);
        this.historyTableSuffix = p.get("historyTableSuffix", this.historyTableSuffix);
        this.dataSourceJndiName = p.get("dataSourceJndiName", this.dataSourceJndiName);
        this.jdbcFetchSizeFindEach = p.getInt("jdbcFetchSizeFindEach", this.jdbcFetchSizeFindEach);
        this.jdbcFetchSizeFindList = p.getInt("jdbcFetchSizeFindList", this.jdbcFetchSizeFindList);
        this.databasePlatformName = p.get("databasePlatformName", this.databasePlatformName);
        this.defaultOrderById = p.getBoolean("defaultOrderById", this.defaultOrderById);
        this.uuidVersion = p.getEnum(UuidVersion.class, "uuidVersion", this.uuidVersion);
        this.uuidStateFile = p.get("uuidStateFile", this.uuidStateFile);
        this.localTimeWithNanos = p.getBoolean("localTimeWithNanos", this.localTimeWithNanos);
        this.jodaLocalTimeMode = p.get("jodaLocalTimeMode", this.jodaLocalTimeMode);
        this.defaultEnumType = p.getEnum(EnumType.class, "defaultEnumType", this.defaultEnumType);
        this.disableLazyLoading = p.getBoolean("disableLazyLoading", this.disableLazyLoading);
        this.lazyLoadBatchSize = p.getInt("lazyLoadBatchSize", this.lazyLoadBatchSize);
        this.queryBatchSize = p.getInt("queryBatchSize", this.queryBatchSize);
        this.jsonInclude = p.getEnum(JsonConfig.Include.class, "jsonInclude", this.jsonInclude);
        this.jsonDateTime = p.getEnum(JsonConfig.DateTime.class, "jsonDateTime", this.jsonDateTime);
        this.jsonDate = p.getEnum(JsonConfig.Date.class, "jsonDate", this.jsonDate);
        this.jsonMutationDetection = p.getEnum(MutationDetection.class, "jsonMutationDetection", this.jsonMutationDetection);
        this.skipDataSourceCheck = p.getBoolean("skipDataSourceCheck", this.skipDataSourceCheck);
        this.runMigration = p.getBoolean("migration.run", this.runMigration);
        this.ddlGenerate = p.getBoolean("ddl.generate", this.ddlGenerate);
        this.ddlRun = p.getBoolean("ddl.run", this.ddlRun);
        this.ddlExtra = p.getBoolean("ddl.extra", this.ddlExtra);
        this.ddlCreateOnly = p.getBoolean("ddl.createOnly", this.ddlCreateOnly);
        this.ddlInitSql = p.get("ddl.initSql", this.ddlInitSql);
        this.ddlSeedSql = p.get("ddl.seedSql", this.ddlSeedSql);
        this.ddlStrictMode = p.getBoolean("ddl.strictMode", this.ddlStrictMode);
        this.ddlPlaceholders = p.get("ddl.placeholders", this.ddlPlaceholders);
        this.ddlHeader = p.get("ddl.header", this.ddlHeader);
        String mode = p.get("tenant.mode");
        if (mode != null) {
            for (TenantMode value : TenantMode.values()) {
                if (!value.name().equalsIgnoreCase(mode)) continue;
                this.tenantMode = value;
                break;
            }
        }
        this.currentTenantProvider = p.createInstance(CurrentTenantProvider.class, "tenant.currentTenantProvider", this.currentTenantProvider);
        this.tenantCatalogProvider = p.createInstance(TenantCatalogProvider.class, "tenant.catalogProvider", this.tenantCatalogProvider);
        this.tenantSchemaProvider = p.createInstance(TenantSchemaProvider.class, "tenant.schemaProvider", this.tenantSchemaProvider);
        this.tenantPartitionColumn = p.get("tenant.partitionColumn", this.tenantPartitionColumn);
        this.classes = this.getClasses(p);
        String mappingsProp = p.get("mappingLocations", null);
        this.mappingLocations = this.getSearchList(mappingsProp, this.mappingLocations);
    }

    private NamingConvention createNamingConvention(PropertiesWrapper properties, NamingConvention namingConvention) {
        NamingConvention nc = properties.createInstance(NamingConvention.class, "namingConvention", null);
        return nc != null ? nc : namingConvention;
    }

    private List<Class<?>> getClasses(PropertiesWrapper properties) {
        String[] split;
        String classNames = properties.get("classes", null);
        if (classNames == null) {
            return this.classes;
        }
        ArrayList classList = new ArrayList();
        for (String cn : split = StringHelper.splitNames(classNames)) {
            if ("class".equalsIgnoreCase(cn)) continue;
            try {
                classList.add(Class.forName(cn));
            }
            catch (ClassNotFoundException e) {
                String msg = "Error registering class [" + cn + "] from [" + classNames + "]";
                throw new RuntimeException(msg, e);
            }
        }
        return classList;
    }

    private List<String> getSearchList(String searchNames, List<String> defaultValue) {
        if (searchNames != null) {
            String[] entries = StringHelper.splitNames(searchNames);
            ArrayList<String> hitList = new ArrayList<String>(entries.length);
            Collections.addAll(hitList, entries);
            return hitList;
        }
        return defaultValue;
    }

    public PersistBatch appliedPersistBatchOnCascade() {
        if (this.persistBatchOnCascade == PersistBatch.INHERIT) {
            return this.databasePlatform.getPersistBatchOnCascade();
        }
        return this.persistBatchOnCascade;
    }

    public Object getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(Object objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isExpressionEqualsWithNullAsNoop() {
        return this.expressionEqualsWithNullAsNoop;
    }

    public void setExpressionEqualsWithNullAsNoop(boolean expressionEqualsWithNullAsNoop) {
        this.expressionEqualsWithNullAsNoop = expressionEqualsWithNullAsNoop;
    }

    public boolean isExpressionNativeIlike() {
        return this.expressionNativeIlike;
    }

    public void setExpressionNativeIlike(boolean expressionNativeIlike) {
        this.expressionNativeIlike = expressionNativeIlike;
    }

    public String getEnabledL2Regions() {
        return this.enabledL2Regions;
    }

    public void setEnabledL2Regions(String enabledL2Regions) {
        this.enabledL2Regions = enabledL2Regions;
    }

    public boolean isDisableL2Cache() {
        return this.disableL2Cache;
    }

    public void setDisableL2Cache(boolean disableL2Cache) {
        this.disableL2Cache = disableL2Cache;
    }

    public boolean isLocalOnlyL2Cache() {
        return this.localOnlyL2Cache;
    }

    public void setLocalOnlyL2Cache(boolean localOnlyL2Cache) {
        this.localOnlyL2Cache = localOnlyL2Cache;
    }

    public boolean isUseValidationNotNull() {
        return this.useValidationNotNull;
    }

    public void setUseValidationNotNull(boolean useValidationNotNull) {
        this.useValidationNotNull = useValidationNotNull;
    }

    public boolean isNotifyL2CacheInForeground() {
        return this.notifyL2CacheInForeground;
    }

    public void setNotifyL2CacheInForeground(boolean notifyL2CacheInForeground) {
        this.notifyL2CacheInForeground = notifyL2CacheInForeground;
    }

    public int getQueryPlanTTLSeconds() {
        return this.queryPlanTTLSeconds;
    }

    public void setQueryPlanTTLSeconds(int queryPlanTTLSeconds) {
        this.queryPlanTTLSeconds = queryPlanTTLSeconds;
    }

    public PlatformConfig newPlatformConfig(String propertiesPath, String platformPrefix) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        PropertiesWrapper p = new PropertiesWrapper(propertiesPath, platformPrefix, this.properties, this.classLoadConfig);
        PlatformConfig config = new PlatformConfig(this.platformConfig);
        config.loadSettings(p);
        return config;
    }

    public void addMappingLocation(String mappingLocation) {
        if (this.mappingLocations == null) {
            this.mappingLocations = new ArrayList<String>();
        }
        this.mappingLocations.add(mappingLocation);
    }

    public List<String> getMappingLocations() {
        return this.mappingLocations;
    }

    public void setMappingLocations(List<String> mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public boolean isIdGeneratorAutomatic() {
        return this.idGeneratorAutomatic;
    }

    public void setIdGeneratorAutomatic(boolean idGeneratorAutomatic) {
        this.idGeneratorAutomatic = idGeneratorAutomatic;
    }

    public boolean isQueryPlanEnable() {
        return this.queryPlanEnable;
    }

    public void setQueryPlanEnable(boolean queryPlanEnable) {
        this.queryPlanEnable = queryPlanEnable;
    }

    public long getQueryPlanThresholdMicros() {
        return this.queryPlanThresholdMicros;
    }

    public void setQueryPlanThresholdMicros(long queryPlanThresholdMicros) {
        this.queryPlanThresholdMicros = queryPlanThresholdMicros;
    }

    public boolean isQueryPlanCapture() {
        return this.queryPlanCapture;
    }

    public void setQueryPlanCapture(boolean queryPlanCapture) {
        this.queryPlanCapture = queryPlanCapture;
    }

    public long getQueryPlanCapturePeriodSecs() {
        return this.queryPlanCapturePeriodSecs;
    }

    public void setQueryPlanCapturePeriodSecs(long queryPlanCapturePeriodSecs) {
        this.queryPlanCapturePeriodSecs = queryPlanCapturePeriodSecs;
    }

    public long getQueryPlanCaptureMaxTimeMillis() {
        return this.queryPlanCaptureMaxTimeMillis;
    }

    public void setQueryPlanCaptureMaxTimeMillis(long queryPlanCaptureMaxTimeMillis) {
        this.queryPlanCaptureMaxTimeMillis = queryPlanCaptureMaxTimeMillis;
    }

    public int getQueryPlanCaptureMaxCount() {
        return this.queryPlanCaptureMaxCount;
    }

    public void setQueryPlanCaptureMaxCount(int queryPlanCaptureMaxCount) {
        this.queryPlanCaptureMaxCount = queryPlanCaptureMaxCount;
    }

    public QueryPlanListener getQueryPlanListener() {
        return this.queryPlanListener;
    }

    public void setQueryPlanListener(QueryPlanListener queryPlanListener) {
        this.queryPlanListener = queryPlanListener;
    }

    public boolean isDumpMetricsOnShutdown() {
        return this.dumpMetricsOnShutdown;
    }

    public void setDumpMetricsOnShutdown(boolean dumpMetricsOnShutdown) {
        this.dumpMetricsOnShutdown = dumpMetricsOnShutdown;
    }

    public String getDumpMetricsOptions() {
        return this.dumpMetricsOptions;
    }

    public void setDumpMetricsOptions(String dumpMetricsOptions) {
        this.dumpMetricsOptions = dumpMetricsOptions;
    }

    public boolean isAutoLoadModuleInfo() {
        return this.loadModuleInfo && this.classes.isEmpty();
    }

    public void setLoadModuleInfo(boolean loadModuleInfo) {
        this.loadModuleInfo = loadModuleInfo;
    }

    public static enum UuidVersion {
        VERSION4,
        VERSION1,
        VERSION1RND;

    }
}

