/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.event;

class ClassUtil {
    ClassUtil() {
    }

    static Object newInstance(String className) {
        try {
            Class<?> cls = ClassUtil.forName(className);
            return cls.newInstance();
        }
        catch (Exception e) {
            String msg = "Error constructing " + className;
            throw new IllegalArgumentException(msg, e);
        }
    }

    static Class<?> forName(String name) throws ClassNotFoundException {
        return new ClassLoadContext().forName(name);
    }

    private static class ClassLoadContext {
        private final ClassLoader contextLoader;
        private final ClassLoader callerLoader = ClassUtil.class.getClassLoader();

        ClassLoadContext() {
            this.contextLoader = this.contextLoader();
        }

        ClassLoader contextLoader() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader != null ? loader : this.callerLoader;
        }

        public Class<?> forName(String name) throws ClassNotFoundException {
            try {
                return Class.forName(name, true, this.contextLoader);
            }
            catch (ClassNotFoundException e) {
                if (this.callerLoader == this.contextLoader) {
                    throw e;
                }
                return Class.forName(name, true, this.callerLoader);
            }
        }
    }
}

