/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.common;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionLoader;
import io.ebean.bean.EntityBean;
import io.ebean.common.AbstractBeanCollection;
import io.ebean.common.ModifyCollection;
import io.ebean.common.ModifyEntrySet;
import io.ebean.common.ModifyKeySet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class BeanMap<K, E>
extends AbstractBeanCollection<E>
implements Map<K, E> {
    private static final long serialVersionUID = 1L;
    private Map<K, E> map;

    public BeanMap(Map<K, E> map) {
        this.map = map;
    }

    public BeanMap() {
        this(new LinkedHashMap());
    }

    public BeanMap(BeanCollectionLoader ebeanServer, EntityBean ownerBean, String propertyName) {
        super(ebeanServer, ownerBean, propertyName);
    }

    @Override
    public void reset(EntityBean ownerBean, String propertyName) {
        this.ownerBean = ownerBean;
        this.propertyName = propertyName;
        this.map = null;
    }

    @Override
    public boolean isSkipSave() {
        return this.map == null || this.map.isEmpty() && !this.holdsModifications();
    }

    @Override
    public void loadFrom(BeanCollection<?> other) {
        BeanMap otherMap = (BeanMap)other;
        this.internalPutNull();
        this.map.putAll(otherMap.getActualMap());
    }

    public void internalPutNull() {
        if (this.map == null) {
            this.map = new LinkedHashMap<K, E>();
        }
    }

    public void internalPut(Object key, Object bean) {
        if (this.map == null) {
            this.map = new LinkedHashMap<K, E>();
        }
        if (key != null) {
            this.map.put(key, bean);
        }
    }

    public void internalPutWithCheck(Object key, Object bean) {
        if (this.map == null || key == null || !this.map.containsKey(key)) {
            this.internalPut(key, bean);
        }
    }

    @Override
    public void internalAddWithCheck(Object bean) {
        throw new RuntimeException("Not allowed for map");
    }

    @Override
    public void internalAdd(Object bean) {
        throw new RuntimeException("Not allowed for map");
    }

    @Override
    public boolean isPopulated() {
        return this.map != null;
    }

    @Override
    public boolean isReference() {
        return this.map == null;
    }

    @Override
    public boolean checkEmptyLazyLoad() {
        if (this.map == null) {
            this.map = new LinkedHashMap<K, E>();
            return true;
        }
        return false;
    }

    private void initClear() {
        this.lock.lock();
        try {
            if (this.map == null) {
                if (!this.disableLazyLoad && this.modifyListening) {
                    this.lazyLoadCollection(true);
                } else {
                    this.map = new LinkedHashMap<K, E>();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void init() {
        this.lock.lock();
        try {
            if (this.map == null) {
                if (this.disableLazyLoad) {
                    this.map = new LinkedHashMap<K, E>();
                } else {
                    this.lazyLoadCollection(false);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setActualMap(Map<?, ?> map) {
        this.map = map;
    }

    public Map<K, E> getActualMap() {
        return this.map;
    }

    @Override
    public Collection<E> getActualDetails() {
        return this.map.values();
    }

    @Override
    public Collection<?> getActualEntries() {
        return this.map.entrySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("BeanMap ");
        if (this.isReadOnly()) {
            sb.append("readOnly ");
        }
        if (this.map == null) {
            sb.append("deferred ");
        } else {
            sb.append("size[").append(this.map.size()).append("]");
            sb.append(" map").append(this.map);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        this.init();
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        this.init();
        return this.map.hashCode();
    }

    @Override
    public void clear() {
        this.checkReadOnly();
        this.initClear();
        if (this.modifyListening) {
            for (E bean : this.map.values()) {
                this.modifyRemoval(bean);
            }
        }
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.init();
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.init();
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, E>> entrySet() {
        this.init();
        if (this.isReadOnly()) {
            return Collections.unmodifiableSet(this.map.entrySet());
        }
        return this.modifyListening ? new ModifyEntrySet<K, E>(this, this.map.entrySet()) : this.map.entrySet();
    }

    @Override
    public E get(Object key) {
        this.init();
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        this.init();
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.init();
        if (this.isReadOnly()) {
            return Collections.unmodifiableSet(this.map.keySet());
        }
        return this.modifyListening ? new ModifyKeySet<K>(this, this.map.keySet()) : this.map.keySet();
    }

    @Override
    public E put(K key, E value) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            E oldBean = this.map.put(key, value);
            if (value != oldBean) {
                this.modifyAddition((Object)value);
                this.modifyRemoval(oldBean);
            }
            return oldBean;
        }
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends E> puts) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            for (Map.Entry<K, E> entry : puts.entrySet()) {
                E oldBean = this.map.put(entry.getKey(), entry.getValue());
                if (entry.getValue() == oldBean) continue;
                this.modifyAddition((Object)entry.getValue());
                this.modifyRemoval(oldBean);
            }
        } else {
            this.map.putAll(puts);
        }
    }

    @Override
    public void addBean(E bean) {
        throw new IllegalStateException("Method not allowed on Map. Please use List instead.");
    }

    @Override
    public void removeBean(E bean) {
        throw new IllegalStateException("Method not allowed on Map. Please use List instead.");
    }

    @Override
    public E remove(Object key) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            E o = this.map.remove(key);
            this.modifyRemoval(o);
            return o;
        }
        return this.map.remove(key);
    }

    @Override
    public int size() {
        this.init();
        return this.map.size();
    }

    @Override
    public Collection<E> values() {
        this.init();
        if (this.isReadOnly()) {
            return Collections.unmodifiableCollection(this.map.values());
        }
        return this.modifyListening ? new ModifyCollection<E>(this, this.map.values()) : this.map.values();
    }

    @Override
    public BeanCollection<E> getShallowCopy() {
        BeanMap<K, E> copy = new BeanMap<K, E>(new LinkedHashMap<K, E>(this.map));
        copy.setFromOriginal(this);
        return copy;
    }
}

