/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform;

import io.ebean.config.dbplatform.DbPlatformTypeParser;
import io.ebean.config.dbplatform.ExtraDbTypes;

public class DbPlatformType
implements ExtraDbTypes {
    private final String name;
    private final int defaultLength;
    private final int defaultScale;
    private final boolean canHaveLength;

    public static DbPlatformType parse(String columnDefinition) {
        return DbPlatformTypeParser.parse(columnDefinition);
    }

    public DbPlatformType(String name) {
        this(name, 0, 0);
    }

    public DbPlatformType(String name, int defaultLength) {
        this(name, defaultLength, 0);
    }

    public DbPlatformType(String name, int defaultPrecision, int defaultScale) {
        this.name = name;
        this.defaultLength = defaultPrecision;
        this.defaultScale = defaultScale;
        this.canHaveLength = true;
    }

    public DbPlatformType(String name, boolean canHaveLength) {
        this.name = name;
        this.defaultLength = 0;
        this.defaultScale = 0;
        this.canHaveLength = canHaveLength;
    }

    public String getName() {
        return this.name;
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    public int getDefaultScale() {
        return this.defaultScale;
    }

    public String renderType(int deployLength, int deployScale) {
        return this.renderType(deployLength, deployScale, true);
    }

    public String renderType(int deployLength, int deployScale, boolean strict) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.canHaveLength || !strict) {
            this.renderLengthScale(deployLength, deployScale, sb);
        }
        return sb.toString();
    }

    protected void renderLengthScale(int deployLength, int deployScale, StringBuilder sb) {
        int len;
        int n = len = deployLength != 0 ? deployLength : this.defaultLength;
        if (len == Integer.MAX_VALUE) {
            sb.append("(max)");
        } else if (len > 0) {
            int scale;
            sb.append("(");
            sb.append(len);
            int n2 = scale = deployScale != 0 ? deployScale : this.defaultScale;
            if (scale > 0) {
                sb.append(",");
                sb.append(scale);
            }
            sb.append(")");
        }
    }

    public DbPlatformType withLength(int defaultLength) {
        return new DbPlatformType(this.name, defaultLength);
    }
}

