/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class AnnotationUtil {
    public static boolean notJavaLang(Annotation annotation) {
        return !annotation.annotationType().getName().startsWith("java.lang.annotation");
    }

    public static <A extends Annotation> A get(AnnotatedElement element, Class<A> annotation) {
        return element.getAnnotation(annotation);
    }

    public static <A extends Annotation> boolean has(AnnotatedElement element, Class<A> annotation) {
        return AnnotationUtil.get(element, annotation) != null;
    }

    public static <A extends Annotation> A typeGet(Class<?> clazz, Class<A> annotationType) {
        while (clazz != null && clazz != Object.class) {
            A val = clazz.getAnnotation(annotationType);
            if (val != null) {
                return val;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static <A extends Annotation> Set<A> typeGetAll(Class<?> clazz, Class<A> annotationType) {
        LinkedHashSet result = new LinkedHashSet();
        AnnotationUtil.typeGetAllCollect(clazz, annotationType, result);
        return result;
    }

    private static <A extends Annotation> void typeGetAllCollect(Class<?> clazz, Class<A> annotationType, Set<A> result) {
        while (clazz != null && clazz != Object.class) {
            A val = clazz.getAnnotation(annotationType);
            if (val != null) {
                result.add(val);
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static <A extends Annotation> boolean typeHas(Class<?> clazz, Class<A> annotation) {
        return AnnotationUtil.typeGet(clazz, annotation) != null;
    }

    public static Set<Annotation> metaFindAllFor(AnnotatedElement element, Set<Class<?>> filter) {
        HashSet<Annotation> visited = new HashSet<Annotation>();
        LinkedHashSet<Annotation> result = new LinkedHashSet<Annotation>();
        for (Annotation ann : element.getAnnotations()) {
            AnnotationUtil.metaAdd(ann, filter, visited, result);
        }
        return result;
    }

    private static void metaAdd(Annotation ann, Set<Class<?>> filter, Set<Annotation> visited, Set<Annotation> result) {
        if (AnnotationUtil.notJavaLang(ann) && visited.add(ann)) {
            if (filter.contains(ann.annotationType())) {
                result.add(ann);
            } else {
                for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
                    AnnotationUtil.metaAdd(metaAnn, filter, visited, result);
                }
            }
        }
    }
}

