/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.event;

import io.ebean.Database;
import io.ebean.event.ClassUtil;
import io.ebean.service.SpiContainer;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownManager {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownManager.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private static final List<Database> databases = new ArrayList<Database>();
    private static final ShutdownHook shutdownHook = new ShutdownHook();
    private static boolean stopping;
    private static SpiContainer container;

    private ShutdownManager() {
    }

    public static void registerContainer(SpiContainer ebeanContainer) {
        container = ebeanContainer;
    }

    public static void touch() {
    }

    public static boolean isStopping() {
        lock.lock();
        try {
            boolean bl = stopping;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public static void deregisterShutdownHook() {
        lock.lock();
        try {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        catch (IllegalStateException ex) {
            if (!ex.getMessage().equals("Shutdown in progress")) {
                throw ex;
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected static void registerShutdownHook() {
        lock.lock();
        try {
            String value = System.getProperty("ebean.registerShutdownHook");
            if (value == null || !value.trim().equalsIgnoreCase("false")) {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
        }
        catch (IllegalStateException ex) {
            if (!ex.getMessage().equals("Shutdown in progress")) {
                throw ex;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        lock.lock();
        try {
            if (stopping) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Shutting down");
            }
            stopping = true;
            ShutdownManager.deregisterShutdownHook();
            String shutdownRunner = System.getProperty("ebean.shutdown.runnable");
            if (shutdownRunner != null) {
                try {
                    Runnable r = (Runnable)ClassUtil.newInstance(shutdownRunner);
                    r.run();
                }
                catch (Exception e) {
                    logger.error("Error running custom shutdown runnable", (Throwable)e);
                }
            }
            if (container != null) {
                container.shutdown();
            }
            for (Database server : databases) {
                try {
                    server.shutdown();
                }
                catch (Exception ex) {
                    logger.error("Error executing shutdown runnable", (Throwable)ex);
                    ex.printStackTrace();
                }
            }
            if ("true".equalsIgnoreCase(System.getProperty("ebean.datasource.deregisterAllDrivers", "false"))) {
                ShutdownManager.deregisterAllJdbcDrivers();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void deregisterAllJdbcDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                logger.info("Deregistering jdbc driver: " + driver);
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                logger.error("Error deregistering driver " + driver, (Throwable)e);
            }
        }
    }

    public static void registerDatabase(Database server) {
        lock.lock();
        try {
            databases.add(server);
        }
        finally {
            lock.unlock();
        }
    }

    public static void unregisterDatabase(Database server) {
        lock.lock();
        try {
            databases.remove(server);
        }
        finally {
            lock.unlock();
        }
    }

    static {
        ShutdownManager.registerShutdownHook();
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            ShutdownManager.shutdown();
        }
    }
}

