/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform.sqlserver;

import io.ebean.BackgroundExecutor;
import io.ebean.Query;
import io.ebean.annotation.PersistBatch;
import io.ebean.annotation.Platform;
import io.ebean.config.PlatformConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.config.dbplatform.SqlErrorCodes;
import io.ebean.config.dbplatform.sqlserver.SqlServerBasicSqlLimiter;
import io.ebean.config.dbplatform.sqlserver.SqlServerHistorySupport;
import io.ebean.config.dbplatform.sqlserver.SqlServerSqlLimiter;
import io.ebean.config.dbplatform.sqlserver.SqlServerStepSequence;
import javax.sql.DataSource;

abstract class SqlServerBasePlatform
extends DatabasePlatform {
    SqlServerBasePlatform() {
        this.platform = Platform.SQLSERVER;
        this.persistBatchOnCascade = PersistBatch.NONE;
        this.idInExpandedForm = true;
        this.selectCountWithAlias = true;
        this.selectCountWithColumnAlias = true;
        this.sqlLimiter = new SqlServerSqlLimiter();
        this.basicSqlLimiter = new SqlServerBasicSqlLimiter();
        this.historySupport = new SqlServerHistorySupport();
        this.dbIdentity.setIdType(IdType.SEQUENCE);
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setSupportsIdentity(true);
        this.dbIdentity.setSupportsSequence(true);
        this.sequenceBatchMode = false;
        this.exceptionTranslator = new SqlErrorCodes().addAcquireLock("1222").addDuplicateKey("2601", "2627").addDataIntegrity("544", "547", "8114", "8115").build();
        this.openQuote = "[";
        this.closeQuote = "]";
        this.likeSpecialCharacters = new char[]{'%', '_', '['};
        this.likeClauseRaw = "like ?";
        this.likeClauseEscaped = "like ?";
        this.booleanDbType = 4;
        this.dbDefaultValue.setFalse("0");
        this.dbDefaultValue.setTrue("1");
        this.dbDefaultValue.setNow("SYSUTCDATETIME()");
        this.dbTypeMap.put(DbType.BOOLEAN, new DbPlatformType("bit"));
        this.dbTypeMap.put(DbType.INTEGER, new DbPlatformType("integer", false));
        this.dbTypeMap.put(DbType.BIGINT, new DbPlatformType("numeric", 19));
        this.dbTypeMap.put(DbType.REAL, new DbPlatformType("float(16)"));
        this.dbTypeMap.put(DbType.DOUBLE, new DbPlatformType("float(32)"));
        this.dbTypeMap.put(DbType.TINYINT, new DbPlatformType("smallint"));
        this.dbTypeMap.put(DbType.DECIMAL, new DbPlatformType("numeric", 16, 3));
        this.dbTypeMap.put(DbType.DATE, new DbPlatformType("date"));
        this.dbTypeMap.put(DbType.TIME, new DbPlatformType("time"));
        this.dbTypeMap.put(DbType.TIMESTAMP, new DbPlatformType("datetime2"));
        this.dbTypeMap.put(DbType.CHAR, new DbPlatformType("nchar", 1));
        this.dbTypeMap.put(DbType.VARCHAR, new DbPlatformType("nvarchar", 255));
        this.dbTypeMap.put(DbType.LONGVARCHAR, new DbPlatformType("nvarchar", Integer.MAX_VALUE));
        this.dbTypeMap.put(DbType.CLOB, new DbPlatformType("nvarchar", Integer.MAX_VALUE));
        this.dbTypeMap.put(DbType.JSON, new DbPlatformType("nvarchar", Integer.MAX_VALUE));
        this.dbTypeMap.put(DbType.JSONB, new DbPlatformType("nvarchar", Integer.MAX_VALUE));
        this.dbTypeMap.put(DbType.BLOB, new DbPlatformType("image"));
        this.dbTypeMap.put(DbType.LONGVARBINARY, new DbPlatformType("image"));
    }

    @Override
    public void configure(PlatformConfig config) {
        super.configure(config);
        if (this.dbIdentity.getIdType() == IdType.SEQUENCE) {
            this.persistBatchOnCascade = PersistBatch.ALL;
        }
    }

    @Override
    protected void escapeLikeCharacter(char ch, StringBuilder sb) {
        sb.append('[').append(ch).append(']');
    }

    @Override
    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, int stepSize, String seqName) {
        return new SqlServerStepSequence(be, ds, seqName, stepSize);
    }

    @Override
    public String fromForUpdate(Query.LockWait lockWait) {
        switch (lockWait) {
            case SKIPLOCKED: {
                return "with (updlock,readpast)";
            }
            case NOWAIT: {
                return "with (updlock,nowait)";
            }
        }
        return "with (updlock)";
    }

    @Override
    protected String withForUpdate(String sql, Query.LockWait lockWait, Query.LockType lockType) {
        return sql;
    }
}

