/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EbeanVersion {
    private static final Logger log = LoggerFactory.getLogger((String)"io.ebean");
    private static final int MIN_AGENT_MAJOR_VERSION = 12;
    private static final int MIN_AGENT_MINOR_VERSION = 12;
    private static String version = "unknown";

    private static void readVersion() {
        try {
            try (InputStream in = ClassLoader.getSystemResourceAsStream("META-INF/maven/io.ebean/ebean-api/pom.properties");){
                if (in != null) {
                    version = EbeanVersion.readVersion(in);
                }
            }
            log.info("ebean version: {}", (Object)version);
        }
        catch (IOException e) {
            log.warn("Could not determine ebean version: {}", (Object)e.getMessage());
        }
    }

    private static void checkAgentVersion() {
        try (InputStream in = ClassLoader.getSystemResourceAsStream("META-INF/maven/io.ebean/ebean-agent/pom.properties");){
            String agentVersion;
            if (in != null && (agentVersion = EbeanVersion.readVersion(in)) != null && EbeanVersion.checkMinAgentVersion(agentVersion)) {
                log.error("Expected minimum ebean-agent version {}.{}.0 but we have {}, please update the ebean-agent", new Object[]{12, 12, agentVersion});
            }
        }
        catch (IOException e) {
            log.warn("Could not check minimum ebean-agent version {}.{}.0 required due to - {}", new Object[]{12, 12, e.getMessage()});
        }
    }

    static boolean checkMinAgentVersion(String agentVersion) {
        String[] versionSegments = agentVersion.split("\\.");
        if (versionSegments.length != 3) {
            return true;
        }
        int major = Integer.parseInt(versionSegments[0]);
        int minor = Integer.parseInt(versionSegments[1]);
        if (major < 12) {
            return true;
        }
        return major == 12 && minor < 12;
    }

    private static String readVersion(InputStream in) throws IOException {
        Properties prop = new Properties();
        prop.load(in);
        in.close();
        return prop.getProperty("version");
    }

    private EbeanVersion() {
    }

    public static String getVersion() {
        return version;
    }

    static {
        EbeanVersion.readVersion();
        EbeanVersion.checkAgentVersion();
    }
}

