/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import io.ebean.config.BackgroundExecutorWrapper;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;

public final class MdcBackgroundExecutorWrapper
implements BackgroundExecutorWrapper {
    @Override
    public <T> Callable<T> wrap(Callable<T> task) {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            return task;
        }
        return () -> {
            MDC.setContextMap((Map)map);
            try {
                Object v = task.call();
                return v;
            }
            finally {
                MDC.clear();
            }
        };
    }

    @Override
    public Runnable wrap(Runnable task) {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            return task;
        }
        return () -> {
            MDC.setContextMap((Map)map);
            try {
                task.run();
            }
            finally {
                MDC.clear();
            }
        };
    }
}

