/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.bean;

import io.ebean.bean.CallOrigin;
import io.ebean.util.EncodeB64;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public final class CallStack
implements Serializable,
CallOrigin {
    private static final long serialVersionUID = -8590644046907438579L;
    private static final String NEWLINE = "\n";
    private final String zeroHash;
    private final String pathHash;
    private final Object[] callStack;
    private final int hc;

    public CallStack(Object[] callStack, int zeroHash, int pathHash) {
        this.callStack = callStack;
        this.hc = this.computeHashCode();
        this.zeroHash = EncodeB64.enc(zeroHash);
        this.pathHash = EncodeB64.enc(pathHash);
    }

    public CallStack(List<StackWalker.StackFrame> frames) {
        this.callStack = frames.toArray(new Object[0]);
        this.hc = this.computeHashCode();
        this.zeroHash = EncodeB64.enc(this.callStack[0].hashCode());
        this.pathHash = EncodeB64.enc(this.hc);
    }

    private int computeHashCode() {
        int hc = 0;
        for (Object element : this.callStack) {
            hc = 92821 * hc + element.hashCode();
        }
        return hc;
    }

    public String toString() {
        return this.zeroHash + ":" + this.pathHash + ":" + this.callStack[0];
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CallStack)) {
            return false;
        }
        CallStack e = (CallStack)obj;
        return Arrays.equals(this.callStack, e.callStack);
    }

    @Override
    public String getTopElement() {
        return this.callStack[0].toString();
    }

    @Override
    public String getFullDescription() {
        StringBuilder sb = new StringBuilder(400);
        for (int i = 0; i < this.callStack.length; ++i) {
            if (i > 0) {
                sb.append(NEWLINE);
            }
            sb.append(this.callStack[i].toString());
        }
        return sb.toString();
    }

    @Override
    public String getOriginKey(int queryHash) {
        return EncodeB64.enc(queryHash) + "." + this.zeroHash + "." + this.pathHash;
    }
}

