/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform;

import io.ebean.config.dbplatform.DbType;
import java.util.HashMap;
import java.util.Map;

class DbPlatformTypeLookup {
    private final Map<String, DbType> nameLookup = new HashMap<String, DbType>();
    private final Map<Integer, DbType> idLookup = new HashMap<Integer, DbType>();

    DbPlatformTypeLookup() {
        this.addAll();
    }

    DbType byName(String name) {
        return this.nameLookup.get(name.trim().toUpperCase());
    }

    DbType byId(int jdbcId) {
        return this.idLookup.get(jdbcId);
    }

    private void addAll() {
        this.add("FLOAT", DbType.REAL);
        this.add("VARCHAR2", DbType.VARCHAR);
        for (DbType type : DbType.values()) {
            this.add(type.name(), type);
        }
    }

    private void add(String name, DbType dbType) {
        this.nameLookup.put(name, dbType);
        this.idLookup.put(dbType.id(), dbType);
    }
}

