/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import io.ebean.config.NamingConvention;
import io.ebean.config.PropertiesWrapper;
import io.ebean.config.TableName;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.util.AnnotationUtil;
import io.ebean.util.StringHelper;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Inheritance;
import javax.persistence.Table;

public abstract class AbstractNamingConvention
implements NamingConvention {
    public static final String DEFAULT_SEQ_FORMAT = "{table}_seq";
    private String catalog;
    private String schema;
    private String sequenceFormat;
    protected DatabasePlatform databasePlatform;
    protected int rhsPrefixLength = 3;
    protected boolean useForeignKeyPrefix;

    public AbstractNamingConvention(String sequenceFormat, boolean useForeignKeyPrefix) {
        this.sequenceFormat = sequenceFormat;
        this.useForeignKeyPrefix = useForeignKeyPrefix;
    }

    public AbstractNamingConvention(String sequenceFormat) {
        this.sequenceFormat = sequenceFormat;
        this.useForeignKeyPrefix = true;
    }

    public AbstractNamingConvention() {
        this(DEFAULT_SEQ_FORMAT);
    }

    @Override
    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    @Override
    public String getSequenceName(String rawTableName, String pkColumn) {
        TableName tableName = new TableName(rawTableName);
        String seqName = this.seqName(pkColumn, tableName.getName());
        return tableName.withCatalogAndSchema(seqName);
    }

    private String seqName(String pkColumn, String tableName) {
        String tableNameUnquoted = this.unQuote(tableName);
        String seqName = this.sequenceFormat.replace("{table}", tableNameUnquoted);
        pkColumn = pkColumn == null ? "" : this.unQuote(pkColumn);
        return this.quoteIdentifiers(seqName.replace("{column}", pkColumn));
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSequenceFormat() {
        return this.sequenceFormat;
    }

    public void setSequenceFormat(String sequenceFormat) {
        this.sequenceFormat = sequenceFormat;
    }

    @Override
    public boolean isUseForeignKeyPrefix() {
        return this.useForeignKeyPrefix;
    }

    public void setUseForeignKeyPrefix(boolean useForeignKeyPrefix) {
        this.useForeignKeyPrefix = useForeignKeyPrefix;
    }

    protected abstract TableName getTableNameByConvention(Class<?> var1);

    @Override
    public TableName getTableName(Class<?> beanClass) {
        String schema;
        String catalog;
        TableName tableName;
        while ((tableName = this.getTableNameFromAnnotation(beanClass)) == null) {
            Class<?> supCls = beanClass.getSuperclass();
            if (this.hasInheritance(supCls)) {
                beanClass = supCls;
                continue;
            }
            tableName = this.getTableNameByConvention(beanClass);
            break;
        }
        if (this.isEmpty(catalog = tableName.getCatalog())) {
            catalog = this.getCatalog();
        }
        if (this.isEmpty(schema = tableName.getSchema())) {
            schema = this.getSchema();
        }
        return new TableName(catalog, schema, tableName.getName());
    }

    protected boolean hasInheritance(Class<?> supCls) {
        return AnnotationUtil.typeHas(supCls, Inheritance.class) || AnnotationUtil.has(supCls, DiscriminatorValue.class);
    }

    @Override
    public TableName getM2MJoinTableName(TableName lhsTable, TableName rhsTable) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.unQuote(lhsTable.getName()));
        buffer.append("_");
        String rhsTableName = this.unQuote(rhsTable.getName());
        if (rhsTableName.indexOf(95) < this.rhsPrefixLength) {
            rhsTableName = rhsTableName.substring(rhsTableName.indexOf(95) + 1);
        }
        buffer.append(rhsTableName);
        int maxTableNameLength = this.databasePlatform.maxTableNameLength();
        if (buffer.length() > maxTableNameLength) {
            buffer.setLength(maxTableNameLength);
        }
        String tableName = this.quoteIdentifiers(buffer.toString());
        return new TableName(lhsTable.getCatalog(), lhsTable.getSchema(), tableName);
    }

    @Override
    public String deriveM2MColumn(String tableName, String dbColumn) {
        return this.quoteIdentifiers(this.unQuote(tableName) + "_" + this.unQuote(dbColumn));
    }

    protected TableName getTableNameFromAnnotation(Class<?> beanClass) {
        Table table = AnnotationUtil.typeGet(beanClass, Table.class);
        if (table != null && !this.isEmpty(table.name())) {
            return new TableName(this.quoteIdentifiers(table.catalog()), this.quoteIdentifiers(table.schema()), this.quoteIdentifiers(table.name()));
        }
        return null;
    }

    @Override
    public String getTableName(String catalog, String schema, String name) {
        StringBuilder sb = new StringBuilder();
        if (!StringHelper.isNull(catalog)) {
            sb.append(this.quoteIdentifiers(catalog)).append(".");
        }
        if (!StringHelper.isNull(schema)) {
            sb.append(this.quoteIdentifiers(schema)).append(".");
        }
        return sb.append(this.quoteIdentifiers(name)).toString();
    }

    protected String quoteIdentifiers(String s) {
        return this.databasePlatform.convertQuotedIdentifiers(s);
    }

    private String unQuote(String val) {
        return this.databasePlatform.unQuote(val);
    }

    protected boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    @Override
    public void loadFromProperties(PropertiesWrapper properties) {
        this.useForeignKeyPrefix = properties.getBoolean("namingConvention.useForeignKeyPrefix", this.useForeignKeyPrefix);
        this.sequenceFormat = properties.get("namingConvention.sequenceFormat", this.sequenceFormat);
        this.schema = properties.get("namingConvention.schema", this.schema);
    }
}

