/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import io.ebean.config.DbConstraintNormalise;

public class DbConstraintNaming {
    protected String pkPrefix = "pk_";
    protected String pkSuffix = "";
    protected String fkPrefix = "fk_";
    protected String fkMiddle = "_";
    protected String fkSuffix = "";
    protected String fkIndexPrefix = "ix_";
    protected String fkIndexMiddle = "_";
    protected String fkIndexSuffix = "";
    protected String indexPrefix = "ix_";
    protected String indexMiddle = "_";
    protected String indexSuffix = "";
    protected String uqPrefix = "uq_";
    protected String uqSuffix = "";
    protected String ckPrefix = "ck_";
    protected String ckSuffix = "";
    protected MaxLength maxLength;
    protected DbConstraintNormalise normalise;

    public DbConstraintNaming() {
        this(true, true);
    }

    public DbConstraintNaming(boolean lowerCase) {
        this(lowerCase, lowerCase);
    }

    public DbConstraintNaming(boolean lowerCaseTableNames, boolean lowerCaseColumnNames) {
        this.normalise = new DbConstraintNormalise(lowerCaseTableNames, lowerCaseColumnNames);
    }

    public MaxLength getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(MaxLength maxLength) {
        this.maxLength = maxLength;
    }

    public String primaryKeyName(String tableName) {
        return this.pkPrefix + this.normaliseTable(tableName) + this.pkSuffix;
    }

    public String foreignKeyConstraintName(String tableName, String columnName) {
        return this.fkPrefix + this.normaliseTable(tableName) + this.fkMiddle + this.normaliseColumn(columnName) + this.fkSuffix;
    }

    public String foreignKeyIndexName(String tableName, String[] columns) {
        String colPart = this.joinColumnNames(columns);
        return this.fkIndexPrefix + this.normaliseTable(tableName) + this.fkIndexMiddle + colPart + this.fkIndexSuffix;
    }

    public String foreignKeyIndexName(String tableName, String column) {
        String colPart = this.normaliseTable(column);
        return this.fkIndexPrefix + this.normaliseTable(tableName) + this.fkIndexMiddle + colPart + this.fkIndexSuffix;
    }

    public String indexName(String tableName, String column) {
        String colPart = this.normaliseTable(column);
        return this.indexPrefix + this.normaliseTable(tableName) + this.indexMiddle + colPart + this.indexSuffix;
    }

    public String indexName(String tableName, String[] columns) {
        String colPart = this.joinColumnNames(columns);
        return this.indexPrefix + this.normaliseTable(tableName) + this.indexMiddle + colPart + this.indexSuffix;
    }

    protected String joinColumnNames(String[] columns) {
        if (columns.length == 1) {
            return this.normaliseColumn(columns[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append("_");
            }
            sb.append(this.normaliseColumn(columns[i]));
        }
        return sb.toString().replace(" ", "_");
    }

    public String uniqueConstraintName(String tableName, String columnName) {
        return this.uqPrefix + this.normaliseTable(tableName) + "_" + this.normaliseColumn(columnName) + this.uqSuffix;
    }

    public String uniqueConstraintName(String tableName, String[] columns) {
        String colPart = this.joinColumnNames(columns);
        return this.uqPrefix + this.normaliseTable(tableName) + "_" + colPart + this.uqSuffix;
    }

    public String checkConstraintName(String tableName, String columnName) {
        return this.ckPrefix + this.normaliseTable(tableName) + "_" + this.normaliseColumn(columnName) + this.ckSuffix;
    }

    public String normaliseTable(String tableName) {
        return this.normalise.normaliseTable(tableName);
    }

    public String normaliseColumn(String tableName) {
        return this.normalise.normaliseColumn(tableName);
    }

    public static interface MaxLength {
        public String maxLength(String var1, int var2);
    }
}

