/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class StringHelper {
    private static final Pattern SPLIT_NAMES = Pattern.compile("[\\s,;]+");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean isNull(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static Map<String, String> delimitedToMap(String source, String listDelimiter, String nameValueSeparator) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (source == null || source.isEmpty()) {
            return params;
        }
        source = StringHelper.trimFront(source, listDelimiter);
        return StringHelper.delimitedToMap(params, source, listDelimiter, nameValueSeparator);
    }

    private static String trimFront(String source, String trim) {
        while (source.indexOf(trim) == 0) {
            source = source.substring(trim.length());
        }
        return source;
    }

    private static Map<String, String> delimitedToMap(Map<String, String> map, String source, String listDelimiter, String nameValueSeparator) {
        int pos = 0;
        while (pos < source.length()) {
            String key;
            int equalsPos = source.indexOf(nameValueSeparator, pos);
            int delimPos = source.indexOf(listDelimiter, pos);
            if (delimPos == -1) {
                delimPos = source.length();
            }
            if (equalsPos == -1) {
                return map;
            }
            if (delimPos == equalsPos + 1) {
                pos = delimPos + 1;
                continue;
            }
            if (equalsPos > delimPos) {
                key = source.substring(pos, delimPos);
                if (!(key = key.trim()).isEmpty()) {
                    map.put(key, null);
                }
                pos = delimPos + 1;
                continue;
            }
            key = source.substring(pos, equalsPos);
            String value = source.substring(equalsPos + 1, delimPos);
            map.put(key.trim(), value);
            pos = delimPos + 1;
        }
        return map;
    }

    public static String replace(String source, String match, String replace) {
        if (source == null) {
            return null;
        }
        if (replace == null) {
            return source;
        }
        return source.replace(match, replace);
    }

    public static String removeNewLines(String source) {
        source = source.replace('\n', ' ');
        return source.replace('\r', ' ');
    }

    public static String[] splitNames(String names) {
        if (names == null || names.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = SPLIT_NAMES.split(names);
        if (result.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if ("".equals(result[0])) {
            if (result.length == 1) {
                return EMPTY_STRING_ARRAY;
            }
            String[] ret = new String[result.length - 1];
            System.arraycopy(result, 1, ret, 0, ret.length);
            return ret;
        }
        return result;
    }
}

