/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.text;

import io.ebean.FetchPath;
import io.ebean.Query;
import io.ebean.text.PathPropertiesParser;
import io.ebean.util.SplitName;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PathProperties
implements FetchPath {
    private final Map<String, Props> pathMap;
    private final Props rootProps = new Props(this, null, null);

    public static PathProperties parse(String source) {
        return PathPropertiesParser.parse(source);
    }

    public PathProperties() {
        this.pathMap = new LinkedHashMap<String, Props>();
        this.pathMap.put(null, this.rootProps);
    }

    public String toString() {
        return this.pathMap.toString();
    }

    @Override
    public boolean hasPath(String path) {
        Props props = this.pathMap.get(path);
        return props != null && !props.isEmpty();
    }

    @Override
    public Set<String> getProperties(String path) {
        Props props = this.pathMap.get(path);
        return props == null ? null : props.getProperties();
    }

    public void addToPath(String path, String property) {
        this.getProps(path).getProperties().add(property);
    }

    public void addNested(String prefix, PathProperties pathProps) {
        for (Map.Entry<String, Props> entry : pathProps.pathMap.entrySet()) {
            String path = this.pathAdd(prefix, entry.getKey());
            String[] split = SplitName.split(path);
            this.getProps(split[0]).addProperty(split[1]);
            this.getProps(path).addProps(entry.getValue());
        }
    }

    private String pathAdd(String prefix, String key) {
        return key == null ? prefix : prefix + "." + key;
    }

    Props getProps(String path) {
        return this.pathMap.computeIfAbsent(path, p -> new Props(this, null, (String)p));
    }

    public Collection<Props> getPathProps() {
        return this.pathMap.values();
    }

    @Override
    public <T> void apply(Query<T> query) {
        for (Map.Entry<String, Props> entry : this.pathMap.entrySet()) {
            String path = entry.getKey();
            String props = entry.getValue().getPropertiesAsString();
            if (path == null || path.isEmpty()) {
                query.select(props);
                continue;
            }
            query.fetch(path, props);
        }
    }

    protected Props getRootProperties() {
        return this.rootProps;
    }

    public boolean includesProperty(String name) {
        String[] split = SplitName.split(name);
        Props props = this.pathMap.get(split[0]);
        return props != null && props.includes(split[1]);
    }

    public boolean includesProperty(String prefix, String name) {
        return this.includesProperty(SplitName.add(prefix, name));
    }

    public boolean includesPath(String path) {
        return this.pathMap.containsKey(path);
    }

    public boolean includesPath(String prefix, String name) {
        return this.includesPath(SplitName.add(prefix, name));
    }

    public static class Props {
        private final PathProperties owner;
        private final String parentPath;
        private final String path;
        private final LinkedHashSet<String> propSet;

        private Props(PathProperties owner, String parentPath, String path, LinkedHashSet<String> propSet) {
            this.owner = owner;
            this.path = path;
            this.parentPath = parentPath;
            this.propSet = propSet;
        }

        private Props(PathProperties owner, String parentPath, String path) {
            this(owner, parentPath, path, new LinkedHashSet<String>());
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return this.propSet.toString();
        }

        public boolean isEmpty() {
            return this.propSet.isEmpty();
        }

        public LinkedHashSet<String> getProperties() {
            return this.propSet;
        }

        public String getPropertiesAsString() {
            StringBuilder sb = new StringBuilder();
            Iterator it = this.propSet.iterator();
            boolean hasNext = it.hasNext();
            while (hasNext) {
                sb.append((String)it.next());
                hasNext = it.hasNext();
                if (!hasNext) continue;
                sb.append(",");
            }
            return sb.toString();
        }

        protected Props getParent() {
            return this.owner.pathMap.get(this.parentPath);
        }

        protected Props addChild(String subPath) {
            subPath = subPath.trim();
            this.addProperty(subPath);
            String fullPath = this.path == null ? subPath : this.path + "." + subPath;
            Props nested = new Props(this.owner, this.path, fullPath);
            this.owner.pathMap.put(fullPath, nested);
            return nested;
        }

        protected void addProperty(String property) {
            this.propSet.add(property.trim());
        }

        private void addProps(Props value) {
            this.propSet.addAll(value.propSet);
        }

        private boolean includes(String prop) {
            return this.propSet.isEmpty() || this.propSet.contains(prop) || this.propSet.contains("*");
        }
    }
}

