/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.common;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionAdd;
import io.ebean.bean.BeanCollectionLoader;
import io.ebean.bean.EntityBean;
import io.ebean.bean.ToStringBuilder;
import io.ebean.common.AbstractBeanCollection;
import io.ebean.common.CopyOnFirstWriteList;
import io.ebean.common.ModifyIterator;
import io.ebean.common.ModifyList;
import io.ebean.common.ModifyListIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class BeanList<E>
extends AbstractBeanCollection<E>
implements List<E>,
BeanCollectionAdd {
    private static final long serialVersionUID = 1L;
    private List<E> list;

    public BeanList(List<E> list) {
        this.list = list;
    }

    public BeanList() {
        this(new ArrayList());
    }

    public BeanList(BeanCollectionLoader loader, EntityBean ownerBean, String propertyName) {
        super(loader, ownerBean, propertyName);
    }

    @Override
    public void toString(ToStringBuilder builder) {
        builder.addCollection(this.list);
    }

    @Override
    public void reset(EntityBean ownerBean, String propertyName) {
        this.ownerBean = ownerBean;
        this.propertyName = propertyName;
        this.list = null;
    }

    @Override
    public boolean isSkipSave() {
        return this.list == null || this.list.isEmpty() && !this.holdsModifications();
    }

    @Override
    public void addEntityBean(EntityBean bean) {
        this.list.add(bean);
    }

    @Override
    public void loadFrom(BeanCollection<?> other) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.addAll(other.getActualDetails());
    }

    @Override
    public void internalAdd(Object bean) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        if (bean != null) {
            this.list.add(bean);
        }
    }

    @Override
    public void internalAddWithCheck(Object bean) {
        if (this.list == null || bean == null || !this.containsInstance(bean)) {
            this.internalAdd(bean);
        }
    }

    private boolean containsInstance(Object bean) {
        for (E element : this.list) {
            if (element != bean) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkEmptyLazyLoad() {
        if (this.list == null) {
            this.list = new ArrayList();
            return true;
        }
        return false;
    }

    private void initClear() {
        this.lock.lock();
        try {
            if (this.list == null) {
                if (!this.disableLazyLoad && this.modifyListening) {
                    this.lazyLoadCollection(true);
                } else {
                    this.list = new ArrayList();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void init() {
        this.lock.lock();
        try {
            if (this.list == null) {
                if (this.disableLazyLoad) {
                    this.list = new ArrayList();
                } else {
                    this.lazyLoadCollection(false);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setActualList(List<?> list) {
        this.list = list;
    }

    public List<E> getActualList() {
        return this.list;
    }

    @Override
    public Collection<E> getActualDetails() {
        return this.list;
    }

    @Override
    public Collection<?> getActualEntries() {
        return this.list;
    }

    @Override
    public boolean isPopulated() {
        return this.list != null;
    }

    @Override
    public boolean isReference() {
        return this.list == null;
    }

    public String toString() {
        if (this.list == null) {
            return "BeanList<deferred>";
        }
        return this.list.toString();
    }

    @Override
    public boolean equals(Object other) {
        this.init();
        return this.list.equals(other);
    }

    @Override
    public int hashCode() {
        this.init();
        return this.list.hashCode();
    }

    @Override
    public void add(int index, E element) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            this.modifyAddition((Object)element);
        }
        this.list.add(index, element);
    }

    @Override
    public void addBean(E bean) {
        this.add(bean);
    }

    @Override
    public boolean add(E bean) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            if (this.list.add(bean)) {
                this.modifyAddition((Object)bean);
                return true;
            }
            return false;
        }
        return this.list.add(bean);
    }

    @Override
    public boolean addAll(Collection<? extends E> beans) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            this.getModifyHolder().modifyAdditionAll(beans);
        }
        return this.list.addAll(beans);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> beans) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            this.getModifyHolder().modifyAdditionAll(beans);
        }
        return this.list.addAll(index, beans);
    }

    @Override
    public void clear() {
        this.checkReadOnly();
        this.initClear();
        if (this.modifyListening) {
            for (E element : this.list) {
                this.getModifyHolder().modifyRemoval(element);
            }
        }
        this.list.clear();
    }

    @Override
    public boolean contains(Object bean) {
        this.init();
        return this.list.contains(bean);
    }

    @Override
    public boolean containsAll(Collection<?> beans) {
        this.init();
        return this.list.containsAll(beans);
    }

    @Override
    public E get(int index) {
        this.init();
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object bean) {
        this.init();
        return this.list.indexOf(bean);
    }

    @Override
    public boolean isEmpty() {
        this.init();
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        this.init();
        if (this.readOnly) {
            return new ReadOnlyListIterator<E>(this.list.listIterator());
        }
        if (this.modifyListening) {
            return new ModifyIterator<E>(this, this.list.iterator());
        }
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object bean) {
        this.init();
        return this.list.lastIndexOf(bean);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.init();
        if (this.readOnly) {
            return new ReadOnlyListIterator<E>(this.list.listIterator());
        }
        if (this.modifyListening) {
            return new ModifyListIterator<E>(this, this.list.listIterator());
        }
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.init();
        if (this.readOnly) {
            return new ReadOnlyListIterator<E>(this.list.listIterator(index));
        }
        if (this.modifyListening) {
            return new ModifyListIterator<E>(this, this.list.listIterator(index));
        }
        return this.list.listIterator(index);
    }

    @Override
    public void removeBean(E bean) {
        if (this.list.remove(bean)) {
            this.getModifyHolder().modifyRemoval(bean);
        }
    }

    @Override
    public E remove(int index) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            E o = this.list.remove(index);
            this.modifyRemoval(o);
            return o;
        }
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object bean) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            boolean isRemove = this.list.remove(bean);
            if (isRemove) {
                this.modifyRemoval(bean);
            }
            return isRemove;
        }
        return this.list.remove(bean);
    }

    @Override
    public boolean removeAll(Collection<?> beans) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            boolean changed = false;
            for (Object bean : beans) {
                if (!this.list.remove(bean)) continue;
                this.modifyRemoval(bean);
                changed = true;
            }
            return changed;
        }
        return this.list.removeAll(beans);
    }

    @Override
    public boolean retainAll(Collection<?> retainBeans) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            boolean changed = false;
            Iterator<E> it = this.list.iterator();
            while (it.hasNext()) {
                E bean = it.next();
                if (retainBeans.contains(bean)) continue;
                it.remove();
                this.modifyRemoval(bean);
                changed = true;
            }
            return changed;
        }
        return this.list.retainAll(retainBeans);
    }

    @Override
    public E set(int index, E element) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            E o = this.list.set(index, element);
            this.modifyAddition((Object)element);
            this.modifyRemoval(o);
            return o;
        }
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        this.init();
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.init();
        if (this.readOnly) {
            return Collections.unmodifiableList(this.list.subList(fromIndex, toIndex));
        }
        if (this.modifyListening) {
            return new ModifyList<E>(this, this.list.subList(fromIndex, toIndex));
        }
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        this.init();
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        this.init();
        return this.list.toArray(array);
    }

    @Override
    public BeanCollection<E> getShallowCopy() {
        BeanList<E> copy = new BeanList<E>(new CopyOnFirstWriteList<E>(this.list));
        copy.setFromOriginal(this);
        return copy;
    }

    private static final class ReadOnlyListIterator<E>
    implements ListIterator<E>,
    Serializable {
        private static final long serialVersionUID = 3097271091406323699L;
        private final ListIterator<E> i;

        ReadOnlyListIterator(ListIterator<E> i) {
            this.i = i;
        }

        @Override
        public void add(E o) {
            throw new IllegalStateException("This collection is in ReadOnly mode");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("This collection is in ReadOnly mode");
        }

        @Override
        public void set(E o) {
            throw new IllegalStateException("This collection is in ReadOnly mode");
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public E next() {
            return this.i.next();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public E previous() {
            return this.i.previous();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }
    }
}

