/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.bean;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.ToStringAware;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;

public final class ToStringBuilder {
    private static final int MAX = 100;
    private static final int TRIM_LENGTH = 500;
    private static final int MAX_TOTAL_CONTENT = 2000;
    private final IdentityHashMap<Object, Integer> id = new IdentityHashMap();
    private final StringBuilder sb = new StringBuilder(50);
    private boolean first = true;
    private int counter;

    public String toString() {
        return this.sb.toString();
    }

    public void start(Object bean) {
        if (this.counter == 0) {
            this.id.putIfAbsent(bean, 0);
        }
        if (this.counter <= 100) {
            this.sb.append(bean.getClass().getSimpleName()).append("@").append(this.counter).append("(");
        }
    }

    public void add(String name, Object value) {
        if (value != null && this.counter <= 100) {
            if (value instanceof BeanCollection && ((BeanCollection)value).isReference()) {
                return;
            }
            this.key(name);
            this.value(value);
        }
    }

    public void addRaw(String content) {
        this.sb.append(content);
    }

    public void end() {
        if (this.counter <= 100) {
            this.sb.append(")");
        }
    }

    private void key(String name) {
        if (this.counter > 100) {
            return;
        }
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(", ");
        }
        this.sb.append(name).append(":");
    }

    private void value(Object value) {
        if (this.counter > 100) {
            return;
        }
        if (value instanceof ToStringAware) {
            if (value instanceof BeanCollection) {
                ((ToStringAware)value).toString(this);
            } else if (this.push(value)) {
                ((ToStringAware)value).toString(this);
            }
        } else if (value instanceof Collection) {
            this.addCollection((Collection)value);
        } else if (value instanceof Map) {
            this.addMap((Map)value);
        } else {
            Object content = String.valueOf(value);
            if (((String)content).length() > 500) {
                content = ((String)content).substring(0, 500) + " <trimmed>";
            }
            this.sb.append((String)content);
            if (this.sb.length() >= 2000) {
                this.sb.append(" ...");
                this.counter += 100;
            }
        }
    }

    public void addMap(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            this.sb.append("{}");
        } else {
            boolean firstElement = true;
            this.sb.append("{");
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (firstElement) {
                    firstElement = false;
                } else {
                    this.sb.append(", ");
                }
                this.sb.append(entry.getKey()).append(":");
                this.value(entry.getValue());
                if (this.counter <= 100) continue;
                return;
            }
            this.sb.append("}");
        }
    }

    public void addCollection(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            this.sb.append("[]");
            return;
        }
        boolean firstElement = true;
        this.sb.append("[");
        for (Object o : c) {
            if (firstElement) {
                firstElement = false;
            } else {
                this.sb.append(", ");
            }
            this.value(o);
            if (this.counter <= 100) continue;
            return;
        }
        this.sb.append("]");
    }

    private boolean push(Object bean) {
        Integer idx;
        if (this.counter > 100) {
            return false;
        }
        if (this.counter == 100) {
            this.sb.append(" ...");
            ++this.counter;
            return false;
        }
        if ((idx = this.id.putIfAbsent(bean, this.counter++)) != null) {
            --this.counter;
            this.sb.append(bean.getClass().getSimpleName()).append("@").append(idx);
            return false;
        }
        this.first = true;
        return true;
    }
}

