/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform;

import io.ebean.config.dbplatform.SqlLimitRequest;
import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.config.dbplatform.SqlLimiter;

public class LimitOffsetSqlLimiter
implements SqlLimiter {
    private static final String LIMIT = "limit";
    private static final String OFFSET = "offset";

    @Override
    public SqlLimitResponse limit(SqlLimitRequest request) {
        String dbSql = request.getDbSql();
        StringBuilder sb = new StringBuilder(50 + dbSql.length());
        sb.append("select ");
        if (request.isDistinct()) {
            sb.append("distinct ");
        }
        sb.append(dbSql);
        int firstRow = request.getFirstRow();
        int maxRows = request.getMaxRows();
        if (maxRows > 0 || firstRow > 0) {
            sb.append(" ").append(LIMIT).append(" ").append(maxRows);
            if (firstRow > 0) {
                sb.append(" ").append(OFFSET).append(" ");
                sb.append(firstRow);
            }
        }
        String sql = request.getDbPlatform().completeSql(sb.toString(), request.getOrmQuery());
        return new SqlLimitResponse(sql);
    }
}

