/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.avaje.config.Config;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;

final class DbPrimary {
    private static final ReentrantLock lock = new ReentrantLock();
    private static String defaultServerName;
    private static boolean skip;

    DbPrimary() {
    }

    static void setSkip(boolean skip) {
        lock.lock();
        try {
            DbPrimary.skip = skip;
        }
        finally {
            lock.unlock();
        }
    }

    static boolean isSkip() {
        lock.lock();
        try {
            boolean bl = skip;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    static String getDefaultServerName() {
        lock.lock();
        try {
            DbPrimary.getProperties();
            String string = defaultServerName;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    static Properties getProperties() {
        lock.lock();
        try {
            if (defaultServerName == null) {
                defaultServerName = DbPrimary.determineDefaultServerName();
            }
            Properties properties = Config.asProperties();
            return properties;
        }
        finally {
            lock.unlock();
        }
    }

    private static String determineDefaultServerName() {
        String defaultServerName = System.getenv("EBEAN_DB");
        defaultServerName = System.getProperty("db", defaultServerName);
        if (DbPrimary.isEmpty(defaultServerName = System.getProperty("ebean_db", defaultServerName)) && DbPrimary.isEmpty(defaultServerName = Config.get((String)"datasource.default", null))) {
            defaultServerName = Config.get((String)"ebean.default.datasource", null);
        }
        if (defaultServerName == null) {
            defaultServerName = "db";
        }
        return defaultServerName;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }
}

