/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.bean;

import io.ebean.bean.NodeUsageListener;
import io.ebean.bean.ObjectGraphNode;
import java.lang.ref.Cleaner;
import java.util.LinkedHashSet;
import java.util.Set;

public final class NodeUsageCollector {
    private static final Cleaner cleaner = Cleaner.create();
    private final State state;

    public NodeUsageCollector(ObjectGraphNode node, NodeUsageListener listener) {
        this.state = new State(node, listener);
        cleaner.register(this, this.state);
    }

    public State state() {
        return this.state;
    }

    public void setModified() {
        this.state.modified = true;
    }

    public void addUsed(String property) {
        this.state.used.add(property);
    }

    public String toString() {
        return this.state.toString();
    }

    public static final class State
    implements Runnable {
        private final NodeUsageListener listener;
        private final Set<String> used = new LinkedHashSet<String>();
        private final ObjectGraphNode node;
        private boolean modified;

        private State(ObjectGraphNode node, NodeUsageListener listener) {
            this.node = node;
            this.listener = listener;
        }

        public String toString() {
            return this.node + " read:" + this.used + " modified:" + this.modified;
        }

        @Override
        public void run() {
            this.listener.collectNodeUsage(this);
        }

        public boolean isEmpty() {
            return this.used.isEmpty();
        }

        public ObjectGraphNode node() {
            return this.node;
        }

        public Set<String> used() {
            return this.used;
        }

        public boolean isModified() {
            return this.modified;
        }
    }
}

