/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.OrderBy;
import io.ebean.Paging;

final class DPaging
implements Paging {
    static final Paging NONE = new DPaging(0, 0, null);
    private final int pageNumber;
    private final int pageSize;
    private final OrderBy<?> orderBy;

    static Paging build(int pgIndex, int pgSize, OrderBy<?> orderBy) {
        return new DPaging(pgIndex, pgSize, orderBy);
    }

    static Paging build(int pgIndex, int pgSize) {
        return new DPaging(pgIndex, pgSize, null);
    }

    DPaging(int pageNumber, int pageSize, OrderBy<?> orderBy) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.orderBy = orderBy;
    }

    @Override
    public int pageIndex() {
        return this.pageNumber;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public OrderBy<?> orderBy() {
        return this.orderBy;
    }

    @Override
    public Paging withPage(int pageNumber) {
        return new DPaging(pageNumber, this.pageSize, this.orderBy);
    }

    @Override
    public Paging withOrderBy(String orderByClause) {
        return new DPaging(this.pageNumber, this.pageSize, OrderBy.of(orderByClause));
    }
}

