/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.cache;

import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheOptions;
import io.ebean.cache.ServerCacheType;
import io.ebean.cache.TenantAwareCache;
import io.ebean.cache.TenantAwareKey;
import io.ebean.config.CurrentTenantProvider;

public class ServerCacheConfig {
    private final ServerCacheType type;
    private final String cacheKey;
    private final String shortName;
    private final ServerCacheOptions cacheOptions;
    private final CurrentTenantProvider tenantProvider;
    private final QueryCacheEntryValidate queryCacheEntryValidate;
    private final TenantAwareKey tenantAwareKey;

    public ServerCacheConfig(ServerCacheType type, String cacheKey, String shortName, ServerCacheOptions cacheOptions, CurrentTenantProvider tenantProvider, QueryCacheEntryValidate queryCacheEntryValidate) {
        this.type = type;
        this.cacheKey = cacheKey;
        this.shortName = shortName;
        this.cacheOptions = cacheOptions;
        this.tenantProvider = tenantProvider;
        this.queryCacheEntryValidate = queryCacheEntryValidate;
        this.tenantAwareKey = tenantProvider == null ? null : new TenantAwareKey(tenantProvider);
    }

    public ServerCache tenantAware(ServerCache cache) {
        return this.tenantAwareKey == null ? cache : new TenantAwareCache(cache, this.tenantAwareKey);
    }

    public ServerCacheType getType() {
        return this.type;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public String getShortName() {
        return this.shortName;
    }

    public ServerCacheOptions getCacheOptions() {
        return this.cacheOptions;
    }

    public CurrentTenantProvider getTenantProvider() {
        return this.tenantProvider;
    }

    public QueryCacheEntryValidate getQueryCacheEntryValidate() {
        return this.queryCacheEntryValidate;
    }

    public boolean isQueryCache() {
        return this.type == ServerCacheType.QUERY;
    }
}

