/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.common;

import io.ebean.common.BeanMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

class ModifyKeySet<E>
implements Set<E> {
    private final Set<E> keySet;
    private final BeanMap<E, ?> owner;

    ModifyKeySet(BeanMap<E, ?> owner, Set<E> keySet) {
        this.owner = owner;
        this.keySet = keySet;
    }

    @Override
    public int size() {
        return this.keySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.keySet.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.keySet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.keySet.toArray(a);
    }

    @Override
    public boolean add(E key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return this.owner.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> keys) {
        return this.keySet.containsAll(keys);
    }

    @Override
    public void clear() {
        this.owner.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return new KeySetIterator<E>(new ArrayList<E>(this.keySet).iterator());
    }

    @Override
    public boolean retainAll(Collection<?> keys) {
        return this.keysMatch(keys, false);
    }

    @Override
    public boolean removeAll(Collection<?> keys) {
        return this.keysMatch(keys, true);
    }

    private boolean keysMatch(Collection<?> keys, boolean containsMatch) {
        boolean changed = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            E key = iterator.next();
            if (keys.contains(key) != containsMatch) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    class KeySetIterator<K>
    implements Iterator<K> {
        private final Iterator<K> iterator;
        private K key;

        KeySetIterator(Iterator<K> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.key = this.iterator.next();
            return this.key;
        }

        @Override
        public void remove() {
            ModifyKeySet.this.owner.remove(this.key);
            this.iterator.remove();
        }
    }
}

