/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import io.ebean.config.AbstractNamingConvention;
import io.ebean.config.TableName;
import io.ebean.util.CamelCaseHelper;

public class UnderscoreNamingConvention
extends AbstractNamingConvention {
    private boolean forceUpperCase = false;
    private boolean digitsCompressed = true;

    public UnderscoreNamingConvention(String sequenceFormat) {
        super(sequenceFormat);
    }

    public UnderscoreNamingConvention() {
    }

    @Override
    public TableName getTableNameByConvention(Class<?> beanClass) {
        return new TableName(this.getCatalog(), this.getSchema(), this.toUnderscoreFromCamel(beanClass.getSimpleName()));
    }

    @Override
    public String getColumnFromProperty(Class<?> beanClass, String propertyName) {
        return this.toUnderscoreFromCamel(propertyName);
    }

    public boolean isForceUpperCase() {
        return this.forceUpperCase;
    }

    public void setForceUpperCase(boolean forceUpperCase) {
        this.forceUpperCase = forceUpperCase;
    }

    public boolean isDigitsCompressed() {
        return this.digitsCompressed;
    }

    public void setDigitsCompressed(boolean digitsCompressed) {
        this.digitsCompressed = digitsCompressed;
    }

    @Override
    public String getForeignKey(String prefix, String fkProperty) {
        return prefix + "_" + this.toUnderscoreFromCamel(fkProperty);
    }

    protected String toUnderscoreFromCamel(String camelCase) {
        return CamelCaseHelper.toUnderscoreFromCamel(camelCase, this.digitsCompressed, this.forceUpperCase);
    }

    protected String toCamelFromUnderscore(String underscore) {
        return CamelCaseHelper.toCamelFromUnderscore(underscore);
    }
}

