/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.plugin;

import io.ebean.config.LookupProvider;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public final class Lookups {
    private static final Map<String, MethodHandles.Lookup> LOOKUP_MAP = ServiceLoader.load(LookupProvider.class).stream().collect(Collectors.toMap(p -> p.type().getModule().getName(), p -> ((LookupProvider)p.get()).provideLookup()));
    private static final MethodHandles.Lookup DEFAULT_LOOKUP = MethodHandles.publicLookup();
    private static final MethodType VOID = MethodType.methodType(Void.TYPE);

    public static MethodHandles.Lookup getLookup(Class<?> type) {
        return LOOKUP_MAP.getOrDefault(type.getModule().getName(), DEFAULT_LOOKUP);
    }

    public static <T> T newDefaultInstance(Class<?> type) throws Throwable {
        return (T)Lookups.getLookup(type).findConstructor(type, VOID).invoke();
    }
}

