/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.util;

public final class CamelCaseHelper {
    public static String toUnderscoreFromCamel(String camelCase) {
        return CamelCaseHelper.toUnderscoreFromCamel(camelCase, true, false);
    }

    public static String toUnderscoreFromCamel(String camelCase, boolean digitsCompressed, boolean forceUpperCase) {
        int lastUpper = -1;
        StringBuilder sb = new StringBuilder(camelCase.length() + 4);
        for (int i = 0; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if ('_' == c) {
                sb.append(c);
                lastUpper = i;
                continue;
            }
            if (Character.isDigit(c)) {
                if (i > lastUpper + 1 && !digitsCompressed) {
                    sb.append('_');
                    lastUpper = i;
                }
                sb.append(c);
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (i > lastUpper + 1) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
                lastUpper = i;
                continue;
            }
            sb.append(c);
        }
        String ret = sb.toString();
        if (forceUpperCase) {
            ret = ret.toUpperCase();
        }
        return ret;
    }

    public static String toCamelFromUnderscore(String underscore) {
        String[] vals = underscore.split("_");
        if (vals.length == 1) {
            return CamelCaseHelper.isUpperCase(underscore) ? underscore.toLowerCase() : underscore;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            String lower = vals[i].toLowerCase();
            if (i > 0) {
                char c = Character.toUpperCase(lower.charAt(0));
                result.append(c);
                result.append(lower.substring(1));
                continue;
            }
            result.append(lower);
        }
        return result.toString();
    }

    private static boolean isUpperCase(String underscore) {
        for (int i = 0; i < underscore.length(); ++i) {
            if (!Character.isLowerCase(underscore.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

