/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.avaje.lang.NonNullApi;
import io.ebean.CancelableQuery;
import io.ebean.Expression;
import io.ebean.ExpressionFactory;
import io.ebean.ExpressionList;
import io.ebean.OrderBy;
import io.ebean.ProfileLocation;
import io.ebean.QueryBuilder;
import io.ebean.QueryType;
import io.ebean.SimpleProperty;
import io.ebean.Transaction;

@NonNullApi
public interface Query<T>
extends CancelableQuery,
QueryBuilder<Query<T>, T> {
    public ExpressionFactory getExpressionFactory();

    public boolean isAutoTuned();

    public boolean isCountDistinct();

    @Deprecated(forRemoval=true, since="14.1.0")
    public int delete(Transaction var1);

    @Deprecated(forRemoval=true, since="14.1.0")
    public int update(Transaction var1);

    public int update();

    public Query<T> setParameter(String var1, Object var2);

    public Query<T> setParameter(int var1, Object var2);

    public Query<T> setParameter(Object var1);

    public Query<T> setParameters(Object ... var1);

    public Query<T> setId(Object var1);

    public Object getId();

    public Query<T> where(Expression var1);

    public ExpressionList<T> where();

    public ExpressionList<T> filterMany(String var1);

    public ExpressionList<T> having();

    public Query<T> having(Expression var1);

    @Deprecated(since="13.19", forRemoval=true)
    default public Query<T> order(String orderByClause) {
        return (Query)this.orderBy(orderByClause);
    }

    @Deprecated(since="13.19", forRemoval=true)
    default public OrderBy<T> order() {
        return this.orderBy();
    }

    @Deprecated(since="13.19", forRemoval=true)
    default public Query<T> setOrder(OrderBy<T> orderBy) {
        return (Query)this.setOrderBy(orderBy);
    }

    public OrderBy<T> orderBy();

    public int getFirstRow();

    public int getMaxRows();

    public boolean isForUpdate();

    public LockWait getForUpdateLockWait();

    public LockType getForUpdateLockType();

    public QueryType getQueryType();

    public Query<T> setProfileLocation(ProfileLocation var1);

    public static interface Property<T> {
        public static <T> Property<T> of(String expression) {
            return new SimpleProperty(expression);
        }

        public String toString();
    }

    public static enum LockWait {
        WAIT,
        NOWAIT,
        SKIPLOCKED;

    }

    public static enum LockType {
        DEFAULT,
        UPDATE,
        NO_KEY_UPDATE,
        SHARE,
        KEY_SHARE;

    }
}

