/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.Database;
import io.ebean.DatabaseBuilder;
import io.ebean.DbContext;
import io.ebean.DbPrimary;
import io.ebean.EbeanVersion;
import io.ebean.config.ContainerConfig;
import io.ebean.service.SpiContainer;
import io.ebean.service.SpiContainerFactory;
import jakarta.persistence.PersistenceException;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;

public final class DatabaseFactory {
    private static final ReentrantLock lock = new ReentrantLock();
    private static SpiContainer container;
    private static String defaultServerName;

    public static void initialiseContainer(ContainerConfig containerConfig) {
        lock.lock();
        try {
            DatabaseFactory.container(containerConfig);
        }
        finally {
            lock.unlock();
        }
    }

    public static Database create(String name) {
        lock.lock();
        try {
            Database database = DatabaseFactory.container(null).createServer(name);
            return database;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database create(DatabaseBuilder builder) {
        lock.lock();
        try {
            DatabaseBuilder.Settings config = builder.settings();
            if (config.getName() == null) {
                throw new PersistenceException("The name is null (it is required)");
            }
            Database server = DatabaseFactory.createInternal(config);
            if (config.isRegister()) {
                if (config.isDefaultServer()) {
                    if (defaultServerName != null && !defaultServerName.equals(config.getName())) {
                        throw new IllegalStateException("Registering [" + config.getName() + "] as the default server but [" + defaultServerName + "] is already registered as the default");
                    }
                    defaultServerName = config.getName();
                }
                DbPrimary.setSkip(true);
                DbContext.getInstance().register(server, config.isDefaultServer());
            }
            Database database = server;
            return database;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database createWithContextClassLoader(DatabaseBuilder config, ClassLoader classLoader) {
        lock.lock();
        try {
            ClassLoader currentContextLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                Database database = DatabaseFactory.create(config);
                Thread.currentThread().setContextClassLoader(currentContextLoader);
                return database;
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(currentContextLoader);
                throw throwable;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void shutdown() {
        lock.lock();
        try {
            container.shutdown();
        }
        finally {
            lock.unlock();
        }
    }

    private static Database createInternal(DatabaseBuilder.Settings config) {
        return DatabaseFactory.container(config.getContainerConfig()).createServer(config);
    }

    private static SpiContainer container(ContainerConfig containerConfig) {
        if (container != null) {
            return container;
        }
        if (containerConfig == null) {
            containerConfig = new ContainerConfig();
        }
        container = DatabaseFactory.createContainer(containerConfig);
        return container;
    }

    private static SpiContainer createContainer(ContainerConfig containerConfig) {
        Iterator<SpiContainerFactory> factories = ServiceLoader.load(SpiContainerFactory.class).iterator();
        if (factories.hasNext()) {
            return factories.next().create(containerConfig);
        }
        throw new IllegalStateException("Service loader didn't find a SpiContainerFactory?");
    }

    static {
        EbeanVersion.getVersion();
    }
}

