/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.Database;
import io.ebean.DatabaseFactory;
import io.ebean.DbPrimary;
import io.ebean.EbeanVersion;
import io.ebean.config.BeanNotEnhancedException;
import io.ebean.datasource.DataSourceConfigurationException;
import jakarta.persistence.PersistenceException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

final class DbContext {
    private static final System.Logger log = EbeanVersion.log;
    private static final DbContext INSTANCE;
    private final ConcurrentHashMap<String, Database> concMap = new ConcurrentHashMap();
    private final HashMap<String, Database> syncMap = new HashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private Database defaultDatabase;

    private DbContext() {
        try {
            String defaultName;
            if (!DbPrimary.isSkip() && (defaultName = DbPrimary.getDefaultServerName()) != null && !defaultName.trim().isEmpty()) {
                this.defaultDatabase = this.getWithCreate(defaultName.trim());
            }
        }
        catch (BeanNotEnhancedException e) {
            String msg = "Bean is not enhanced? See https://ebean.io/docs/trouble-shooting#not-enhanced";
            log.log(System.Logger.Level.ERROR, msg, (Throwable)e);
            throw e;
        }
        catch (DataSourceConfigurationException e) {
            String msg = "Configuration error creating DataSource for the default Database. This typically means a missing application-test.yaml or missing ebean-test dependency. See https://ebean.io/docs/trouble-shooting#datasource";
            log.log(System.Logger.Level.ERROR, msg, (Throwable)e);
            throw new DataSourceConfigurationException(msg, (Throwable)e);
        }
        catch (Throwable e) {
            log.log(System.Logger.Level.ERROR, "Error trying to create the default Database", e);
            throw new RuntimeException(e);
        }
    }

    static DbContext getInstance() {
        return INSTANCE;
    }

    Database getDefault() {
        if (this.defaultDatabase == null) {
            String msg = "The default Database has not been defined? This is normally set via the ebean.datasource.default property. Otherwise it should be registered programmatically via registerServer()";
            throw new PersistenceException(msg);
        }
        return this.defaultDatabase;
    }

    Database get(String name) {
        if (name == null || name.isEmpty()) {
            return this.defaultDatabase;
        }
        Database server = this.concMap.get(name);
        if (server != null) {
            return server;
        }
        return this.getWithCreate(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Database getWithCreate(String name) {
        this.lock.lock();
        try {
            Database server = this.syncMap.get(name);
            if (server == null) {
                server = DatabaseFactory.create(name);
                this.register(server, false);
            }
            Database database = server;
            return database;
        }
        finally {
            this.lock.unlock();
        }
    }

    void register(Database server, boolean isDefault) {
        this.registerWithName(server.name(), server, isDefault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWithName(String name, Database server, boolean isDefault) {
        this.lock.lock();
        try {
            this.concMap.put(name, server);
            this.syncMap.put(name, server);
            if (isDefault) {
                this.defaultDatabase = server;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    Database mock(String name, Database server, boolean defaultServer) {
        Database originalPrimaryServer = this.defaultDatabase;
        this.registerWithName(name, server, defaultServer);
        return originalPrimaryServer;
    }

    static {
        EbeanVersion.getVersion();
        INSTANCE = new DbContext();
    }
}

