/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform;

import java.util.LinkedHashMap;
import java.util.Map;

public class DbDefaultValue {
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final String NOW = "now";
    public static final String NULL = "null";
    protected final Map<String, String> map = new LinkedHashMap<String, String>();

    public void setNow(String dbFunction) {
        this.put(NOW, dbFunction);
    }

    public void setFalse(String dbFalseLiteral) {
        this.put(FALSE, dbFalseLiteral);
    }

    public void setTrue(String dbTrueLiteral) {
        this.put(TRUE, dbTrueLiteral);
    }

    public void put(String dbLiteral, String dbTranslated) {
        this.map.put(dbLiteral, dbTranslated);
    }

    public String convert(String dbDefaultLiteral) {
        if (dbDefaultLiteral == null) {
            return null;
        }
        if (dbDefaultLiteral.startsWith("$RAW:")) {
            return dbDefaultLiteral.substring(5);
        }
        String val = this.map.get(dbDefaultLiteral);
        return val != null ? val : dbDefaultLiteral;
    }

    public static String toSqlLiteral(String defaultValue, Class<?> propertyType, int sqlType) {
        if (propertyType == null || defaultValue == null || NULL.equals(defaultValue) || defaultValue.startsWith("'") && defaultValue.endsWith("'") || defaultValue.startsWith("$RAW:")) {
            return defaultValue;
        }
        if (Boolean.class.isAssignableFrom(propertyType) || Boolean.TYPE.isAssignableFrom(propertyType)) {
            return DbDefaultValue.toBooleanLiteral(defaultValue);
        }
        if (Number.class.isAssignableFrom(propertyType) || Byte.TYPE.equals(propertyType) || Short.TYPE.equals(propertyType) || Integer.TYPE.equals(propertyType) || Long.TYPE.equals(propertyType) || Float.TYPE.equals(propertyType) || Double.TYPE.equals(propertyType) || propertyType.isEnum() && sqlType == 4) {
            Double.valueOf(defaultValue);
            return defaultValue;
        }
        switch (sqlType) {
            case 91: {
                return DbDefaultValue.toDateLiteral(defaultValue);
            }
            case 92: 
            case 2013: {
                return DbDefaultValue.toTimeLiteral(defaultValue);
            }
            case 93: 
            case 2014: {
                return DbDefaultValue.toDateTimeLiteral(defaultValue);
            }
        }
        return DbDefaultValue.toTextLiteral(defaultValue);
    }

    private static String toBooleanLiteral(String value) {
        if (FALSE.equals(value) || TRUE.equals(value)) {
            return value;
        }
        throw new IllegalArgumentException("'" + value + "' is not a valid value for boolean");
    }

    private static String toTextLiteral(String value) {
        StringBuilder sb = new StringBuilder(value.length() + 10);
        sb.append('\'');
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(ch);
        }
        sb.append('\'');
        return sb.toString();
    }

    private static String toDateLiteral(String value) {
        if (NOW.equals(value)) {
            return value;
        }
        return DbDefaultValue.toTextLiteral(value);
    }

    private static String toTimeLiteral(String value) {
        if (NOW.equals(value)) {
            return value;
        }
        return DbDefaultValue.toTextLiteral(value);
    }

    private static String toDateTimeLiteral(String value) {
        if (NOW.equals(value)) {
            return value;
        }
        return DbDefaultValue.toTextLiteral(value);
    }
}

