/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.Query;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrderBy<T>
implements Serializable {
    private static final long serialVersionUID = 9157089257745730539L;
    private transient Query<T> query;
    private final List<Property> list;

    public static <P> OrderBy<P> of(String orderByClause) {
        return new OrderBy(orderByClause);
    }

    @Deprecated(forRemoval=true)
    public OrderBy() {
        this.list = new ArrayList<Property>(3);
    }

    private OrderBy(List<Property> list) {
        this.list = list;
    }

    @Deprecated(forRemoval=true)
    public OrderBy(String orderByClause) {
        this(null, orderByClause);
    }

    @Deprecated(forRemoval=true)
    public OrderBy(Query<T> query, String orderByClause) {
        this.query = query;
        this.list = new ArrayList<Property>(3);
        this.parse(orderByClause);
    }

    public void reverse() {
        for (Property aList : this.list) {
            aList.reverse();
        }
    }

    public Query<T> asc(String propertyName) {
        this.list.add(new Property(propertyName, true));
        return this.query;
    }

    public Query<T> asc(String propertyName, String collation) {
        this.list.add(new Property(propertyName, true, collation));
        return this.query;
    }

    public Query<T> desc(String propertyName) {
        this.list.add(new Property(propertyName, false));
        return this.query;
    }

    public Query<T> desc(String propertyName, String collation) {
        this.list.add(new Property(propertyName, false, collation));
        return this.query;
    }

    public boolean containsProperty(String propertyName) {
        for (Property aList : this.list) {
            if (!propertyName.equals(aList.getProperty())) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    public OrderBy<T> copyWithTrim(String path) {
        ArrayList<Property> newList = new ArrayList<Property>(this.list.size());
        for (Property aList : this.list) {
            newList.add(aList.copyWithTrim(path));
        }
        return new OrderBy<T>(newList);
    }

    public List<Property> getProperties() {
        return this.list;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Query<T> getQuery() {
        return this.query;
    }

    public void setQuery(Query<T> query) {
        this.query = query;
    }

    public OrderBy<T> copy() {
        OrderBy<T> copy = new OrderBy<T>();
        for (Property property : this.list) {
            copy.add(property.copy());
        }
        return copy;
    }

    public void add(String rawExpression) {
        this.parse(rawExpression);
    }

    public void add(Property p) {
        this.list.add(p);
    }

    public String toString() {
        return this.list.toString();
    }

    public String toStringFormat() {
        if (this.list.isEmpty()) {
            return null;
        }
        StringAppend append = new StringAppend();
        for (int i = 0; i < this.list.size(); ++i) {
            Property property = this.list.get(i);
            if (i > 0) {
                append.append(", ");
            }
            property.toStringFormat(append);
        }
        return append.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderBy)) {
            return false;
        }
        OrderBy e = (OrderBy)obj;
        return e.list.equals(this.list);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public OrderBy<T> clear() {
        this.list.clear();
        return this;
    }

    private void parse(String orderByClause) {
        if (orderByClause == null) {
            return;
        }
        for (String chunk : orderByClause.split(",")) {
            Property p = this.parseProperty(chunk);
            if (p == null) continue;
            this.list.add(p);
        }
    }

    private Property parseProperty(String chunk) {
        String[] pairs = chunk.split(" ");
        if (pairs.length == 0) {
            return null;
        }
        ArrayList<String> wordList = new ArrayList<String>(pairs.length);
        for (String pair : pairs) {
            if (this.isEmptyString(pair)) continue;
            wordList.add(pair);
        }
        if (wordList.isEmpty()) {
            return null;
        }
        if (wordList.size() == 1) {
            return new Property((String)wordList.get(0), true);
        }
        if (wordList.size() == 2) {
            boolean asc = this.isAscending((String)wordList.get(1));
            return new Property((String)wordList.get(0), asc);
        }
        if (wordList.size() == 4) {
            boolean asc = this.isAscending((String)wordList.get(1));
            return new Property((String)wordList.get(0), asc, (String)wordList.get(2), (String)wordList.get(3));
        }
        return new Property(chunk.trim(), true);
    }

    private boolean isAscending(String s) {
        if ((s = s.toLowerCase()).startsWith("asc")) {
            return true;
        }
        if (s.startsWith("desc")) {
            return false;
        }
        throw new RuntimeException("Expecting [" + s + "] to be asc or desc?");
    }

    private boolean isEmptyString(String s) {
        return s == null || s.isEmpty();
    }

    public static class Property
    implements Serializable {
        private static final long serialVersionUID = 1546009780322478077L;
        private String property;
        private boolean ascending;
        private String collation;
        private String nulls;
        private String highLow;

        public Property(String property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        public Property(String property, boolean ascending, String nulls, String highLow) {
            this.property = property;
            this.ascending = ascending;
            this.nulls = nulls;
            this.highLow = highLow;
        }

        public Property(String property, boolean ascending, String collation) {
            this.property = property;
            this.ascending = ascending;
            this.collation = collation;
        }

        public Property(String property, boolean ascending, String collation, String nulls, String highLow) {
            this.property = property;
            this.ascending = ascending;
            this.collation = collation;
            this.nulls = nulls;
            this.highLow = highLow;
        }

        public Property copyWithTrim(String path) {
            return new Property(this.property.substring(path.length() + 1), this.ascending, this.collation, this.nulls, this.highLow);
        }

        public int hashCode() {
            int hc = this.property.hashCode();
            hc = hc * 92821 + (this.ascending ? 0 : 1);
            hc = hc * 92821 + (this.collation == null ? 0 : this.collation.hashCode());
            hc = hc * 92821 + (this.nulls == null ? 0 : this.nulls.hashCode());
            hc = hc * 92821 + (this.highLow == null ? 0 : this.highLow.hashCode());
            return hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Property)) {
                return false;
            }
            Property e = (Property)obj;
            if (this.ascending != e.ascending) {
                return false;
            }
            if (!this.property.equals(e.property)) {
                return false;
            }
            if (!Objects.equals(this.collation, e.collation)) {
                return false;
            }
            if (!Objects.equals(this.nulls, e.nulls)) {
                return false;
            }
            return Objects.equals(this.highLow, e.highLow);
        }

        public String toString() {
            return this.property;
        }

        public void toStringFormat(Append append) {
            if (this.collation != null) {
                if (this.collation.contains("${}")) {
                    append.parse(this.collation.replace("${}", this.property));
                } else {
                    append.property(this.property).append(" collate ").append(this.collation);
                }
            } else {
                append.property(this.property);
            }
            if (!this.ascending) {
                append.append(" desc");
            }
            if (this.nulls != null) {
                append.append(" ").append(this.nulls).append(" ").append(this.highLow);
            }
        }

        public void reverse() {
            this.ascending = !this.ascending;
        }

        public void trim(String pathPrefix) {
            this.property = this.property.substring(pathPrefix.length() + 1);
        }

        public Property copy() {
            return new Property(this.property, this.ascending, this.collation, this.nulls, this.highLow);
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }

    private static final class StringAppend
    implements Append {
        private final StringBuilder builder = new StringBuilder();

        private StringAppend() {
        }

        public String toString() {
            return this.builder.toString();
        }

        @Override
        public Append property(String property) {
            this.builder.append(property);
            return this;
        }

        @Override
        public Append append(String literal) {
            this.builder.append(literal);
            return this;
        }

        @Override
        public Append parse(String raw) {
            this.builder.append(raw);
            return this;
        }
    }

    public static interface Append {
        public Append property(String var1);

        public Append append(String var1);

        public Append parse(String var1);
    }
}

