/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.common;

import io.ebean.DB;
import io.ebean.ExpressionList;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionLoader;
import io.ebean.bean.EntityBean;
import io.ebean.common.ModifyHolder;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractBeanCollection<E>
implements BeanCollection<E> {
    private static final long serialVersionUID = 3365725236140187588L;
    protected final ReentrantLock lock = new ReentrantLock();
    protected boolean disableLazyLoad;
    protected transient BeanCollectionLoader loader;
    protected transient ExpressionList<?> filterMany;
    protected boolean registeredWithLoadContext;
    protected String ebeanServerName;
    protected EntityBean ownerBean;
    protected String propertyName;
    protected ModifyHolder<E> modifyHolder;
    protected BeanCollection.ModifyListenMode modifyListenMode;
    protected boolean modifyListening;

    AbstractBeanCollection() {
    }

    AbstractBeanCollection(BeanCollectionLoader loader, EntityBean ownerBean, String propertyName) {
        this.loader = loader;
        this.ebeanServerName = loader.name();
        this.ownerBean = ownerBean;
        this.propertyName = propertyName;
    }

    @Override
    public EntityBean owner() {
        return this.ownerBean;
    }

    @Override
    public String propertyName() {
        return this.propertyName;
    }

    @Override
    public ExpressionList<?> filterMany() {
        return this.filterMany;
    }

    @Override
    public void setFilterMany(ExpressionList<?> filterMany) {
        this.filterMany = filterMany;
    }

    @Override
    public void setDisableLazyLoad(boolean disableLazyLoad) {
        this.disableLazyLoad = disableLazyLoad;
    }

    void lazyLoadCollection(boolean onlyIds) {
        if (this.loader == null) {
            this.loader = (BeanCollectionLoader)((Object)DB.byName(this.ebeanServerName));
        }
        this.loader.loadMany(this, onlyIds);
        this.checkEmptyLazyLoad();
    }

    @Override
    public boolean isRegisteredWithLoadContext() {
        return this.registeredWithLoadContext;
    }

    @Override
    public void setLoader(BeanCollectionLoader loader) {
        this.registeredWithLoadContext = true;
        this.loader = loader;
        this.ebeanServerName = loader.name();
    }

    @Override
    public boolean hasModifications() {
        return this.modifyHolder != null && this.modifyHolder.hasModifications();
    }

    @Override
    public BeanCollection.ModifyListenMode modifyListening() {
        return this.modifyListenMode;
    }

    @Override
    public void setModifyListening(BeanCollection.ModifyListenMode mode) {
        this.modifyListenMode = mode;
        boolean bl = this.modifyListening = mode != null && BeanCollection.ModifyListenMode.NONE != mode;
        if (this.modifyListening) {
            this.modifyHolder = null;
        }
    }

    public BeanCollection.ModifyListenMode getModifyListenMode() {
        return this.modifyListenMode;
    }

    ModifyHolder<E> getModifyHolder() {
        if (this.modifyHolder == null) {
            this.modifyHolder = new ModifyHolder();
        }
        return this.modifyHolder;
    }

    @Override
    public void modifyAddition(E bean) {
        if (this.modifyListening) {
            this.getModifyHolder().modifyAddition(bean);
        }
    }

    @Override
    public void modifyRemoval(Object bean) {
        if (this.modifyListening) {
            this.getModifyHolder().modifyRemoval(bean);
        }
    }

    @Override
    public void modifyReset() {
        if (this.modifyHolder != null) {
            this.modifyHolder.reset();
        }
    }

    @Override
    public Set<E> modifyAdditions() {
        if (this.modifyHolder == null) {
            return null;
        }
        return this.modifyHolder.getModifyAdditions();
    }

    @Override
    public Set<E> modifyRemovals() {
        if (this.modifyHolder == null) {
            return null;
        }
        return this.modifyHolder.getModifyRemovals();
    }

    @Override
    public boolean holdsModifications() {
        return this.modifyHolder != null && this.modifyHolder.hasModifications();
    }

    @Override
    public boolean wasTouched() {
        return this.modifyHolder != null && this.modifyHolder.wasTouched();
    }
}

