/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import com.fasterxml.jackson.core.JsonFactory;
import io.avaje.config.Config;
import io.ebean.Database;
import io.ebean.DatabaseBuilder;
import io.ebean.DatabaseFactory;
import io.ebean.EbeanVersion;
import io.ebean.PersistenceContextScope;
import io.ebean.annotation.MutationDetection;
import io.ebean.annotation.PersistBatch;
import io.ebean.annotation.Platform;
import io.ebean.cache.ServerCachePlugin;
import io.ebean.config.AutoConfigure;
import io.ebean.config.AutoTuneConfig;
import io.ebean.config.BackgroundExecutorWrapper;
import io.ebean.config.ClassLoadConfig;
import io.ebean.config.ContainerConfig;
import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.CurrentUserProvider;
import io.ebean.config.DbConstraintNaming;
import io.ebean.config.EncryptDeployManager;
import io.ebean.config.EncryptKeyManager;
import io.ebean.config.Encryptor;
import io.ebean.config.ExternalTransactionManager;
import io.ebean.config.IdGenerator;
import io.ebean.config.JsonConfig;
import io.ebean.config.LengthCheck;
import io.ebean.config.MatchingNamingConvention;
import io.ebean.config.MdcBackgroundExecutorWrapper;
import io.ebean.config.NamingConvention;
import io.ebean.config.PlatformConfig;
import io.ebean.config.ProfilingConfig;
import io.ebean.config.PropertiesWrapper;
import io.ebean.config.QueryPlanListener;
import io.ebean.config.SlowQueryListener;
import io.ebean.config.TenantCatalogProvider;
import io.ebean.config.TenantDataSourceProvider;
import io.ebean.config.TenantMode;
import io.ebean.config.TenantSchemaProvider;
import io.ebean.config.UnderscoreNamingConvention;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbEncrypt;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.IdType;
import io.ebean.datasource.DataSourceBuilder;
import io.ebean.event.BeanFindController;
import io.ebean.event.BeanPersistController;
import io.ebean.event.BeanPersistListener;
import io.ebean.event.BeanPostConstructListener;
import io.ebean.event.BeanPostLoad;
import io.ebean.event.BeanQueryAdapter;
import io.ebean.event.BulkTableEventListener;
import io.ebean.event.ServerConfigStartup;
import io.ebean.event.changelog.ChangeLogListener;
import io.ebean.event.changelog.ChangeLogPrepare;
import io.ebean.event.changelog.ChangeLogRegister;
import io.ebean.meta.MetricNamingMatch;
import io.ebean.util.StringHelper;
import jakarta.persistence.EnumType;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.sql.DataSource;

public class DatabaseConfig
implements DatabaseBuilder.Settings {
    private String name = "db";
    private final Map<String, Object> serviceObject = new HashMap<String, Object>();
    private ContainerConfig containerConfig;
    private Properties properties;
    private String resourceDirectory;
    private boolean register = true;
    private boolean defaultServer = true;
    private boolean disableClasspathSearch;
    private TenantMode tenantMode = TenantMode.NONE;
    private String tenantPartitionColumn = "tenant_id";
    private CurrentTenantProvider currentTenantProvider;
    private TenantDataSourceProvider tenantDataSourceProvider;
    private TenantSchemaProvider tenantSchemaProvider;
    private TenantCatalogProvider tenantCatalogProvider;
    private boolean loadModuleInfo = true;
    private boolean includeLabelInSql = true;
    private Set<Class<?>> classes = new HashSet();
    private List<String> packages = new ArrayList<String>();
    private CurrentUserProvider currentUserProvider;
    private AutoTuneConfig autoTuneConfig = new AutoTuneConfig();
    private JsonConfig.DateTime jsonDateTime = JsonConfig.DateTime.ISO8601;
    private JsonConfig.Date jsonDate = JsonConfig.Date.ISO8601;
    private JsonConfig.Include jsonInclude = JsonConfig.Include.ALL;
    private MutationDetection jsonMutationDetection = MutationDetection.HASH;
    private String databasePlatformName;
    private DatabasePlatform databasePlatform;
    private int jdbcFetchSizeFindList;
    private int jdbcFetchSizeFindEach = 100;
    private String asOfViewSuffix = "_with_history";
    private String asOfSysPeriod = "sys_period";
    private String historyTableSuffix = "_history";
    private boolean autoPersistUpdates;
    private PersistBatch persistBatch = PersistBatch.NONE;
    private PersistBatch persistBatchOnCascade = PersistBatch.INHERIT;
    private int persistBatchSize = 100;
    private EnumType defaultEnumType = EnumType.ORDINAL;
    private boolean disableLazyLoading;
    private int lazyLoadBatchSize = 100;
    private int queryBatchSize = 100;
    private boolean eagerFetchLobs;
    private String dataTimeZone;
    private boolean ddlGenerate;
    private boolean ddlRun;
    private boolean ddlExtra = true;
    private boolean ddlCreateOnly;
    private String ddlInitSql;
    private String ddlSeedSql;
    private String ddlHeader;
    private boolean ddlStrictMode = true;
    private String ddlPlaceholders;
    private Map<String, String> ddlPlaceholderMap;
    private boolean runMigration;
    private boolean skipCacheAfterWrite = true;
    private boolean useJtaTransactionManager;
    private ExternalTransactionManager externalTransactionManager;
    private boolean skipDataSourceCheck;
    private boolean readOnlyDatabase;
    private boolean shutdownHook = true;
    private DataSource dataSource;
    private DataSource readOnlyDataSource;
    private DataSourceBuilder.Settings dataSourceConfig = DataSourceBuilder.create().settings();
    private boolean autoReadOnlyDataSource;
    private DataSourceBuilder.Settings readOnlyDataSourceConfig = DataSourceBuilder.create().settings();
    private String dbSchema;
    private ClassLoadConfig classLoadConfig = new ClassLoadConfig();
    private NamingConvention namingConvention = new UnderscoreNamingConvention();
    private boolean updateAllPropertiesInBatch;
    private PlatformConfig platformConfig = new PlatformConfig();
    private UuidVersion uuidVersion = UuidVersion.VERSION4;
    private String uuidStateFile;
    private String uuidNodeId;
    private Clock clock = Clock.systemUTC();
    private List<IdGenerator> idGenerators = new ArrayList<IdGenerator>();
    private List<BeanFindController> findControllers = new ArrayList<BeanFindController>();
    private List<BeanPersistController> persistControllers = new ArrayList<BeanPersistController>();
    private List<BeanPostLoad> postLoaders = new ArrayList<BeanPostLoad>();
    private List<BeanPostConstructListener> postConstructListeners = new ArrayList<BeanPostConstructListener>();
    private List<BeanPersistListener> persistListeners = new ArrayList<BeanPersistListener>();
    private List<BeanQueryAdapter> queryAdapters = new ArrayList<BeanQueryAdapter>();
    private final List<BulkTableEventListener> bulkTableEventListeners = new ArrayList<BulkTableEventListener>();
    private final List<ServerConfigStartup> configStartupListeners = new ArrayList<ServerConfigStartup>();
    private boolean changeLogIncludeInserts = true;
    private ChangeLogPrepare changeLogPrepare;
    private ChangeLogListener changeLogListener;
    private ChangeLogRegister changeLogRegister;
    private boolean changeLogAsync = true;
    private EncryptKeyManager encryptKeyManager;
    private EncryptDeployManager encryptDeployManager;
    private Encryptor encryptor;
    private DbEncrypt dbEncrypt;
    private boolean dbOffline;
    private ServerCachePlugin serverCachePlugin;
    private PersistenceContextScope persistenceContextScope = PersistenceContextScope.TRANSACTION;
    private JsonFactory jsonFactory;
    private boolean localTimeWithNanos;
    private boolean durationWithNanos;
    private int maxCallStack = 5;
    private boolean transactionRollbackOnChecked = true;
    private int backgroundExecutorSchedulePoolSize = 1;
    private int backgroundExecutorShutdownSecs = 30;
    private BackgroundExecutorWrapper backgroundExecutorWrapper = new MdcBackgroundExecutorWrapper();
    private int cacheMaxSize = 10000;
    private int cacheMaxIdleTime = 600;
    private int cacheMaxTimeToLive = 21600;
    private int queryCacheMaxSize = 1000;
    private int queryCacheMaxIdleTime = 600;
    private int queryCacheMaxTimeToLive = 21600;
    private Object objectMapper;
    private boolean expressionEqualsWithNullAsNoop;
    private boolean expressionNativeIlike;
    private String jodaLocalTimeMode;
    private int queryPlanTTLSeconds = 300;
    private String queryPlanExplain;
    private boolean disableL2Cache;
    private String enabledL2Regions;
    private boolean localOnlyL2Cache;
    private boolean useValidationNotNull = true;
    private boolean notifyL2CacheInForeground;
    private boolean queryPlanEnable;
    private long queryPlanThresholdMicros = Long.MAX_VALUE;
    private boolean queryPlanCapture;
    private long queryPlanCapturePeriodSecs = 600L;
    private long queryPlanCaptureMaxTimeMillis = 10000L;
    private int queryPlanCaptureMaxCount = 10;
    private QueryPlanListener queryPlanListener;
    private long slowQueryMillis;
    private SlowQueryListener slowQueryListener;
    private ProfilingConfig profilingConfig = new ProfilingConfig();
    private List<String> mappingLocations = new ArrayList<String>();
    private boolean idGeneratorAutomatic = true;
    private boolean dumpMetricsOnShutdown;
    private String dumpMetricsOptions;
    private LengthCheck lengthCheck = LengthCheck.OFF;
    private Function<String, String> metricNaming = MetricNamingMatch.INSTANCE;

    @Override
    public Database build() {
        return DatabaseFactory.create(this);
    }

    @Override
    public DatabaseBuilder.Settings settings() {
        return this;
    }

    @Override
    public DatabaseBuilder apply(Consumer<DatabaseBuilder.Settings> applyConfiguration) {
        applyConfiguration.accept(this);
        return this;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public DatabaseConfig setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    @Override
    public long getSlowQueryMillis() {
        return this.slowQueryMillis;
    }

    @Override
    public DatabaseConfig setSlowQueryMillis(long slowQueryMillis) {
        this.slowQueryMillis = slowQueryMillis;
        return this;
    }

    @Override
    public SlowQueryListener getSlowQueryListener() {
        return this.slowQueryListener;
    }

    @Override
    public DatabaseConfig setSlowQueryListener(SlowQueryListener slowQueryListener) {
        this.slowQueryListener = slowQueryListener;
        return this;
    }

    @Override
    public DatabaseConfig putServiceObject(String key, Object configObject) {
        this.serviceObject.put(key, configObject);
        return this;
    }

    @Override
    public <T> DatabaseConfig putServiceObject(Class<T> iface, T configObject) {
        this.serviceObject.put(this.serviceObjectKey(iface), configObject);
        return this;
    }

    @Override
    public Object getServiceObject(String key) {
        return this.serviceObject.get(key);
    }

    @Override
    public DatabaseConfig putServiceObject(Object configObject) {
        String key = this.serviceObjectKey(configObject);
        this.serviceObject.put(key, configObject);
        return this;
    }

    @Override
    public <P> P getServiceObject(Class<P> cls) {
        return (P)this.serviceObject.get(this.serviceObjectKey(cls));
    }

    private String serviceObjectKey(Object configObject) {
        return this.serviceObjectKey(configObject.getClass());
    }

    private String serviceObjectKey(Class<?> cls) {
        String simpleName = cls.getSimpleName();
        return Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
    }

    @Override
    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    @Override
    public DatabaseConfig setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
        return this;
    }

    @Override
    public JsonConfig.DateTime getJsonDateTime() {
        return this.jsonDateTime;
    }

    @Override
    public DatabaseConfig setJsonDateTime(JsonConfig.DateTime jsonDateTime) {
        this.jsonDateTime = jsonDateTime;
        return this;
    }

    @Override
    public JsonConfig.Date getJsonDate() {
        return this.jsonDate;
    }

    @Override
    public DatabaseConfig setJsonDate(JsonConfig.Date jsonDate) {
        this.jsonDate = jsonDate;
        return this;
    }

    @Override
    public JsonConfig.Include getJsonInclude() {
        return this.jsonInclude;
    }

    @Override
    public DatabaseConfig setJsonInclude(JsonConfig.Include jsonInclude) {
        this.jsonInclude = jsonInclude;
        return this;
    }

    @Override
    public MutationDetection getJsonMutationDetection() {
        return this.jsonMutationDetection;
    }

    @Override
    public DatabaseConfig setJsonMutationDetection(MutationDetection jsonMutationDetection) {
        this.jsonMutationDetection = jsonMutationDetection;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatabaseConfig setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ContainerConfig getContainerConfig() {
        return this.containerConfig;
    }

    @Override
    public DatabaseConfig setContainerConfig(ContainerConfig containerConfig) {
        this.containerConfig = containerConfig;
        return this;
    }

    @Override
    public boolean isRegister() {
        return this.register;
    }

    @Override
    public DatabaseConfig setRegister(boolean register) {
        this.register = register;
        return this;
    }

    @Override
    public boolean isDefaultServer() {
        return this.defaultServer;
    }

    @Override
    public DatabaseConfig setDefaultServer(boolean defaultServer) {
        this.defaultServer = defaultServer;
        return this;
    }

    @Override
    public CurrentUserProvider getCurrentUserProvider() {
        return this.currentUserProvider;
    }

    @Override
    public DatabaseConfig setCurrentUserProvider(CurrentUserProvider currentUserProvider) {
        this.currentUserProvider = currentUserProvider;
        return this;
    }

    @Override
    public TenantMode getTenantMode() {
        return this.tenantMode;
    }

    @Override
    public DatabaseConfig setTenantMode(TenantMode tenantMode) {
        this.tenantMode = tenantMode;
        return this;
    }

    @Override
    public String getTenantPartitionColumn() {
        return this.tenantPartitionColumn;
    }

    @Override
    public DatabaseConfig setTenantPartitionColumn(String tenantPartitionColumn) {
        this.tenantPartitionColumn = tenantPartitionColumn;
        return this;
    }

    @Override
    public CurrentTenantProvider getCurrentTenantProvider() {
        return this.currentTenantProvider;
    }

    @Override
    public DatabaseConfig setCurrentTenantProvider(CurrentTenantProvider currentTenantProvider) {
        this.currentTenantProvider = currentTenantProvider;
        return this;
    }

    @Override
    public TenantDataSourceProvider getTenantDataSourceProvider() {
        return this.tenantDataSourceProvider;
    }

    @Override
    public DatabaseConfig setTenantDataSourceProvider(TenantDataSourceProvider tenantDataSourceProvider) {
        this.tenantDataSourceProvider = tenantDataSourceProvider;
        return this;
    }

    @Override
    public TenantSchemaProvider getTenantSchemaProvider() {
        return this.tenantSchemaProvider;
    }

    @Override
    public DatabaseConfig setTenantSchemaProvider(TenantSchemaProvider tenantSchemaProvider) {
        this.tenantSchemaProvider = tenantSchemaProvider;
        return this;
    }

    @Override
    public TenantCatalogProvider getTenantCatalogProvider() {
        return this.tenantCatalogProvider;
    }

    @Override
    public DatabaseConfig setTenantCatalogProvider(TenantCatalogProvider tenantCatalogProvider) {
        this.tenantCatalogProvider = tenantCatalogProvider;
        return this;
    }

    @Override
    public boolean isAutoPersistUpdates() {
        return this.autoPersistUpdates;
    }

    @Override
    public DatabaseConfig setAutoPersistUpdates(boolean autoPersistUpdates) {
        this.autoPersistUpdates = autoPersistUpdates;
        return this;
    }

    @Override
    public PersistBatch getPersistBatch() {
        return this.persistBatch;
    }

    @Override
    public DatabaseConfig setPersistBatch(PersistBatch persistBatch) {
        this.persistBatch = persistBatch;
        return this;
    }

    @Override
    public PersistBatch getPersistBatchOnCascade() {
        return this.persistBatchOnCascade;
    }

    @Override
    public DatabaseConfig setPersistBatchOnCascade(PersistBatch persistBatchOnCascade) {
        this.persistBatchOnCascade = persistBatchOnCascade;
        return this;
    }

    @Override
    public DatabaseConfig setPersistBatching(boolean persistBatching) {
        this.persistBatch = persistBatching ? PersistBatch.ALL : PersistBatch.NONE;
        return this;
    }

    @Override
    public int getPersistBatchSize() {
        return this.persistBatchSize;
    }

    @Override
    public DatabaseConfig setPersistBatchSize(int persistBatchSize) {
        this.persistBatchSize = persistBatchSize;
        return this;
    }

    @Override
    public int getQueryBatchSize() {
        return this.queryBatchSize;
    }

    @Override
    public DatabaseConfig setQueryBatchSize(int queryBatchSize) {
        this.queryBatchSize = queryBatchSize;
        return this;
    }

    @Override
    public EnumType getDefaultEnumType() {
        return this.defaultEnumType;
    }

    @Override
    public DatabaseConfig setDefaultEnumType(EnumType defaultEnumType) {
        this.defaultEnumType = defaultEnumType;
        return this;
    }

    @Override
    public boolean isDisableLazyLoading() {
        return this.disableLazyLoading;
    }

    @Override
    public DatabaseConfig setDisableLazyLoading(boolean disableLazyLoading) {
        this.disableLazyLoading = disableLazyLoading;
        return this;
    }

    @Override
    public int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    @Override
    public DatabaseConfig setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.lazyLoadBatchSize = lazyLoadBatchSize;
        return this;
    }

    @Override
    public DatabaseConfig setDatabaseSequenceBatchSize(int databaseSequenceBatchSize) {
        this.platformConfig.setDatabaseSequenceBatchSize(databaseSequenceBatchSize);
        return this;
    }

    @Override
    public int getJdbcFetchSizeFindList() {
        return this.jdbcFetchSizeFindList;
    }

    @Override
    public DatabaseConfig setJdbcFetchSizeFindList(int jdbcFetchSizeFindList) {
        this.jdbcFetchSizeFindList = jdbcFetchSizeFindList;
        return this;
    }

    @Override
    public int getJdbcFetchSizeFindEach() {
        return this.jdbcFetchSizeFindEach;
    }

    @Override
    public DatabaseConfig setJdbcFetchSizeFindEach(int jdbcFetchSizeFindEach) {
        this.jdbcFetchSizeFindEach = jdbcFetchSizeFindEach;
        return this;
    }

    @Override
    public ChangeLogPrepare getChangeLogPrepare() {
        return this.changeLogPrepare;
    }

    @Override
    public DatabaseConfig setChangeLogPrepare(ChangeLogPrepare changeLogPrepare) {
        this.changeLogPrepare = changeLogPrepare;
        return this;
    }

    @Override
    public ChangeLogListener getChangeLogListener() {
        return this.changeLogListener;
    }

    @Override
    public DatabaseConfig setChangeLogListener(ChangeLogListener changeLogListener) {
        this.changeLogListener = changeLogListener;
        return this;
    }

    @Override
    public ChangeLogRegister getChangeLogRegister() {
        return this.changeLogRegister;
    }

    @Override
    public DatabaseConfig setChangeLogRegister(ChangeLogRegister changeLogRegister) {
        this.changeLogRegister = changeLogRegister;
        return this;
    }

    @Override
    public boolean isChangeLogIncludeInserts() {
        return this.changeLogIncludeInserts;
    }

    @Override
    public DatabaseConfig setChangeLogIncludeInserts(boolean changeLogIncludeInserts) {
        this.changeLogIncludeInserts = changeLogIncludeInserts;
        return this;
    }

    @Override
    public boolean isChangeLogAsync() {
        return this.changeLogAsync;
    }

    @Override
    public DatabaseConfig setChangeLogAsync(boolean changeLogAsync) {
        this.changeLogAsync = changeLogAsync;
        return this;
    }

    @Override
    public ProfilingConfig getProfilingConfig() {
        return this.profilingConfig;
    }

    @Override
    public DatabaseConfig setProfilingConfig(ProfilingConfig profilingConfig) {
        this.profilingConfig = profilingConfig;
        return this;
    }

    @Override
    public String getDbSchema() {
        return this.dbSchema;
    }

    @Override
    public DatabaseConfig setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
        return this;
    }

    @Override
    public int getGeometrySRID() {
        return this.platformConfig.getGeometrySRID();
    }

    @Override
    public DatabaseConfig setGeometrySRID(int geometrySRID) {
        this.platformConfig.setGeometrySRID(geometrySRID);
        return this;
    }

    @Override
    public String getDataTimeZone() {
        return System.getProperty("ebean.dataTimeZone", this.dataTimeZone);
    }

    @Override
    public DatabaseConfig setDataTimeZone(String dataTimeZone) {
        this.dataTimeZone = dataTimeZone;
        return this;
    }

    @Override
    public String getAsOfViewSuffix() {
        return this.asOfViewSuffix;
    }

    @Override
    public DatabaseConfig setAsOfViewSuffix(String asOfViewSuffix) {
        this.asOfViewSuffix = asOfViewSuffix;
        return this;
    }

    @Override
    public String getAsOfSysPeriod() {
        return this.asOfSysPeriod;
    }

    @Override
    public DatabaseConfig setAsOfSysPeriod(String asOfSysPeriod) {
        this.asOfSysPeriod = asOfSysPeriod;
        return this;
    }

    @Override
    public String getHistoryTableSuffix() {
        return this.historyTableSuffix;
    }

    @Override
    public DatabaseConfig setHistoryTableSuffix(String historyTableSuffix) {
        this.historyTableSuffix = historyTableSuffix;
        return this;
    }

    @Override
    public boolean isUseJtaTransactionManager() {
        return this.useJtaTransactionManager;
    }

    @Override
    public DatabaseConfig setUseJtaTransactionManager(boolean useJtaTransactionManager) {
        this.useJtaTransactionManager = useJtaTransactionManager;
        return this;
    }

    @Override
    public ExternalTransactionManager getExternalTransactionManager() {
        return this.externalTransactionManager;
    }

    @Override
    public DatabaseConfig setExternalTransactionManager(ExternalTransactionManager externalTransactionManager) {
        this.externalTransactionManager = externalTransactionManager;
        return this;
    }

    @Override
    public ServerCachePlugin getServerCachePlugin() {
        return this.serverCachePlugin;
    }

    @Override
    public DatabaseConfig setServerCachePlugin(ServerCachePlugin serverCachePlugin) {
        this.serverCachePlugin = serverCachePlugin;
        return this;
    }

    @Override
    public boolean isEagerFetchLobs() {
        return this.eagerFetchLobs;
    }

    @Override
    public DatabaseConfig setEagerFetchLobs(boolean eagerFetchLobs) {
        this.eagerFetchLobs = eagerFetchLobs;
        return this;
    }

    @Override
    public int getMaxCallStack() {
        return this.maxCallStack;
    }

    @Override
    public DatabaseConfig setMaxCallStack(int maxCallStack) {
        this.maxCallStack = maxCallStack;
        return this;
    }

    @Override
    public boolean isTransactionRollbackOnChecked() {
        return this.transactionRollbackOnChecked;
    }

    @Override
    public DatabaseConfig setTransactionRollbackOnChecked(boolean transactionRollbackOnChecked) {
        this.transactionRollbackOnChecked = transactionRollbackOnChecked;
        return this;
    }

    @Override
    public int getBackgroundExecutorSchedulePoolSize() {
        return this.backgroundExecutorSchedulePoolSize;
    }

    @Override
    public DatabaseConfig setBackgroundExecutorSchedulePoolSize(int backgroundExecutorSchedulePoolSize) {
        this.backgroundExecutorSchedulePoolSize = backgroundExecutorSchedulePoolSize;
        return this;
    }

    @Override
    public int getBackgroundExecutorShutdownSecs() {
        return this.backgroundExecutorShutdownSecs;
    }

    @Override
    public DatabaseConfig setBackgroundExecutorShutdownSecs(int backgroundExecutorShutdownSecs) {
        this.backgroundExecutorShutdownSecs = backgroundExecutorShutdownSecs;
        return this;
    }

    @Override
    public BackgroundExecutorWrapper getBackgroundExecutorWrapper() {
        return this.backgroundExecutorWrapper;
    }

    @Override
    public DatabaseConfig setBackgroundExecutorWrapper(BackgroundExecutorWrapper backgroundExecutorWrapper) {
        this.backgroundExecutorWrapper = backgroundExecutorWrapper;
        return this;
    }

    @Override
    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    @Override
    public DatabaseConfig setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
        return this;
    }

    @Override
    public int getCacheMaxIdleTime() {
        return this.cacheMaxIdleTime;
    }

    @Override
    public DatabaseConfig setCacheMaxIdleTime(int cacheMaxIdleTime) {
        this.cacheMaxIdleTime = cacheMaxIdleTime;
        return this;
    }

    @Override
    public int getCacheMaxTimeToLive() {
        return this.cacheMaxTimeToLive;
    }

    @Override
    public DatabaseConfig setCacheMaxTimeToLive(int cacheMaxTimeToLive) {
        this.cacheMaxTimeToLive = cacheMaxTimeToLive;
        return this;
    }

    @Override
    public int getQueryCacheMaxSize() {
        return this.queryCacheMaxSize;
    }

    @Override
    public DatabaseConfig setQueryCacheMaxSize(int queryCacheMaxSize) {
        this.queryCacheMaxSize = queryCacheMaxSize;
        return this;
    }

    @Override
    public int getQueryCacheMaxIdleTime() {
        return this.queryCacheMaxIdleTime;
    }

    @Override
    public DatabaseConfig setQueryCacheMaxIdleTime(int queryCacheMaxIdleTime) {
        this.queryCacheMaxIdleTime = queryCacheMaxIdleTime;
        return this;
    }

    @Override
    public int getQueryCacheMaxTimeToLive() {
        return this.queryCacheMaxTimeToLive;
    }

    @Override
    public DatabaseConfig setQueryCacheMaxTimeToLive(int queryCacheMaxTimeToLive) {
        this.queryCacheMaxTimeToLive = queryCacheMaxTimeToLive;
        return this;
    }

    @Override
    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    @Override
    public DatabaseConfig setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
        return this;
    }

    @Override
    public boolean isAllQuotedIdentifiers() {
        return this.platformConfig.isAllQuotedIdentifiers();
    }

    @Override
    public DatabaseConfig setAllQuotedIdentifiers(boolean allQuotedIdentifiers) {
        this.platformConfig.setAllQuotedIdentifiers(allQuotedIdentifiers);
        if (allQuotedIdentifiers) {
            this.adjustNamingConventionForAllQuoted();
        }
        return this;
    }

    private void adjustNamingConventionForAllQuoted() {
        if (this.namingConvention instanceof UnderscoreNamingConvention) {
            this.namingConvention = new MatchingNamingConvention();
        }
    }

    @Override
    public DbConstraintNaming getConstraintNaming() {
        return this.platformConfig.getConstraintNaming();
    }

    @Override
    public DatabaseConfig setConstraintNaming(DbConstraintNaming constraintNaming) {
        this.platformConfig.setConstraintNaming(constraintNaming);
        return this;
    }

    @Override
    public AutoTuneConfig getAutoTuneConfig() {
        return this.autoTuneConfig;
    }

    @Override
    public DatabaseConfig setAutoTuneConfig(AutoTuneConfig autoTuneConfig) {
        this.autoTuneConfig = autoTuneConfig;
        return this;
    }

    @Override
    public boolean skipDataSourceCheck() {
        return this.skipDataSourceCheck || this.readOnlyDatabase;
    }

    @Override
    public DatabaseConfig setSkipDataSourceCheck(boolean skipDataSourceCheck) {
        this.skipDataSourceCheck = skipDataSourceCheck;
        return this;
    }

    @Override
    public DatabaseBuilder readOnlyDatabase(boolean readOnlyDatabase) {
        this.readOnlyDatabase = readOnlyDatabase;
        return this;
    }

    @Override
    public boolean readOnlyDatabase() {
        return this.readOnlyDatabase;
    }

    @Override
    public DatabaseBuilder shutdownHook(boolean shutdownHook) {
        this.shutdownHook = shutdownHook;
        return this;
    }

    @Override
    public boolean shutdownHook() {
        return this.shutdownHook;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public DatabaseConfig setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Override
    public DataSource getReadOnlyDataSource() {
        return this.readOnlyDataSource;
    }

    @Override
    public DatabaseConfig setReadOnlyDataSource(DataSource readOnlyDataSource) {
        this.readOnlyDataSource = readOnlyDataSource;
        return this;
    }

    @Override
    public DataSourceBuilder.Settings getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    @Override
    public DatabaseConfig setDataSourceConfig(DataSourceBuilder dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig.settings();
        return this;
    }

    @Override
    public boolean isAutoReadOnlyDataSource() {
        return this.autoReadOnlyDataSource;
    }

    @Override
    public DatabaseConfig setAutoReadOnlyDataSource(boolean autoReadOnlyDataSource) {
        this.autoReadOnlyDataSource = autoReadOnlyDataSource;
        return this;
    }

    @Override
    public DataSourceBuilder.Settings getReadOnlyDataSourceConfig() {
        return this.readOnlyDataSourceConfig;
    }

    @Override
    public DatabaseConfig setReadOnlyDataSourceConfig(DataSourceBuilder readOnly) {
        this.readOnlyDataSourceConfig = readOnly == null ? null : readOnly.settings();
        return this;
    }

    @Override
    public String getDatabaseBooleanTrue() {
        return this.platformConfig.getDatabaseBooleanTrue();
    }

    @Override
    public DatabaseConfig setDatabaseBooleanTrue(String databaseTrue) {
        this.platformConfig.setDatabaseBooleanTrue(databaseTrue);
        return this;
    }

    @Override
    public String getDatabaseBooleanFalse() {
        return this.platformConfig.getDatabaseBooleanFalse();
    }

    @Override
    public DatabaseConfig setDatabaseBooleanFalse(String databaseFalse) {
        this.platformConfig.setDatabaseBooleanFalse(databaseFalse);
        return this;
    }

    @Override
    public int getDatabaseSequenceBatchSize() {
        return this.platformConfig.getDatabaseSequenceBatchSize();
    }

    @Override
    public DatabaseConfig setDatabaseSequenceBatch(int databaseSequenceBatchSize) {
        this.platformConfig.setDatabaseSequenceBatchSize(databaseSequenceBatchSize);
        return this;
    }

    @Override
    public String getDatabasePlatformName() {
        return this.databasePlatformName;
    }

    @Override
    public DatabaseConfig setDatabasePlatformName(String databasePlatformName) {
        this.databasePlatformName = databasePlatformName;
        return this;
    }

    @Override
    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    @Override
    public DatabaseConfig setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
        return this;
    }

    @Override
    public IdType getIdType() {
        return this.platformConfig.getIdType();
    }

    @Override
    public DatabaseConfig setIdType(IdType idType) {
        this.platformConfig.setIdType(idType);
        return this;
    }

    @Override
    public EncryptKeyManager getEncryptKeyManager() {
        return this.encryptKeyManager;
    }

    @Override
    public DatabaseConfig setEncryptKeyManager(EncryptKeyManager encryptKeyManager) {
        this.encryptKeyManager = encryptKeyManager;
        return this;
    }

    @Override
    public EncryptDeployManager getEncryptDeployManager() {
        return this.encryptDeployManager;
    }

    @Override
    public DatabaseConfig setEncryptDeployManager(EncryptDeployManager encryptDeployManager) {
        this.encryptDeployManager = encryptDeployManager;
        return this;
    }

    @Override
    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    @Override
    public DatabaseConfig setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
        return this;
    }

    @Override
    public boolean isDbOffline() {
        return this.dbOffline;
    }

    @Override
    public DatabaseConfig setDbOffline(boolean dbOffline) {
        this.dbOffline = dbOffline;
        return this;
    }

    @Override
    public DbEncrypt getDbEncrypt() {
        return this.dbEncrypt;
    }

    @Override
    public DatabaseConfig setDbEncrypt(DbEncrypt dbEncrypt) {
        this.dbEncrypt = dbEncrypt;
        return this;
    }

    @Override
    public PlatformConfig getPlatformConfig() {
        return this.platformConfig;
    }

    @Override
    public DatabaseConfig setPlatformConfig(PlatformConfig platformConfig) {
        this.platformConfig = platformConfig;
        return this;
    }

    @Override
    public DatabaseConfig setDbUuid(PlatformConfig.DbUuid dbUuid) {
        this.platformConfig.setDbUuid(dbUuid);
        return this;
    }

    @Override
    public UuidVersion getUuidVersion() {
        return this.uuidVersion;
    }

    @Override
    public DatabaseConfig setUuidVersion(UuidVersion uuidVersion) {
        this.uuidVersion = uuidVersion;
        return this;
    }

    @Override
    public String getUuidStateFile() {
        if (this.uuidStateFile == null || this.uuidStateFile.isEmpty()) {
            this.uuidStateFile = this.name + "-uuid.state";
            String homeDir = System.getProperty("user.home");
            if (homeDir != null && homeDir.isEmpty()) {
                this.uuidStateFile = homeDir + "/.ebean/" + this.uuidStateFile;
            }
        }
        return this.uuidStateFile;
    }

    @Override
    public DatabaseConfig setUuidStateFile(String uuidStateFile) {
        this.uuidStateFile = uuidStateFile;
        return this;
    }

    @Override
    public String getUuidNodeId() {
        return this.uuidNodeId;
    }

    @Override
    public DatabaseConfig setUuidNodeId(String uuidNodeId) {
        this.uuidNodeId = uuidNodeId;
        return this;
    }

    @Override
    public boolean isLocalTimeWithNanos() {
        return this.localTimeWithNanos;
    }

    @Override
    public DatabaseConfig setLocalTimeWithNanos(boolean localTimeWithNanos) {
        this.localTimeWithNanos = localTimeWithNanos;
        return this;
    }

    @Override
    public boolean isDurationWithNanos() {
        return this.durationWithNanos;
    }

    @Override
    public DatabaseConfig setDurationWithNanos(boolean durationWithNanos) {
        this.durationWithNanos = durationWithNanos;
        return this;
    }

    @Override
    public DatabaseConfig setRunMigration(boolean runMigration) {
        this.runMigration = runMigration;
        return this;
    }

    @Override
    public boolean isRunMigration() {
        String run = System.getProperty("ebean.migration.run");
        return run != null ? Boolean.parseBoolean(run) : this.runMigration;
    }

    @Override
    public DatabaseConfig setDdlGenerate(boolean ddlGenerate) {
        this.ddlGenerate = ddlGenerate;
        return this;
    }

    @Override
    public DatabaseConfig setDdlRun(boolean ddlRun) {
        this.ddlRun = ddlRun;
        return this;
    }

    @Override
    public DatabaseConfig setDdlExtra(boolean ddlExtra) {
        this.ddlExtra = ddlExtra;
        return this;
    }

    @Override
    public boolean isDdlCreateOnly() {
        return this.ddlCreateOnly;
    }

    @Override
    public DatabaseConfig setDdlCreateOnly(boolean ddlCreateOnly) {
        this.ddlCreateOnly = ddlCreateOnly;
        return this;
    }

    @Override
    public String getDdlSeedSql() {
        return this.ddlSeedSql;
    }

    @Override
    public DatabaseConfig setDdlSeedSql(String ddlSeedSql) {
        this.ddlSeedSql = ddlSeedSql;
        return this;
    }

    @Override
    public String getDdlInitSql() {
        return this.ddlInitSql;
    }

    @Override
    public DatabaseConfig setDdlInitSql(String ddlInitSql) {
        this.ddlInitSql = ddlInitSql;
        return this;
    }

    @Override
    public boolean isDdlGenerate() {
        return this.ddlGenerate;
    }

    @Override
    public boolean isDdlRun() {
        return this.ddlRun;
    }

    @Override
    public boolean isDdlExtra() {
        return this.ddlExtra;
    }

    @Override
    public DatabaseConfig setDdlHeader(String ddlHeader) {
        this.ddlHeader = ddlHeader;
        return this;
    }

    @Override
    public String getDdlHeader() {
        if (this.ddlHeader != null && !this.ddlHeader.isEmpty()) {
            String header = this.ddlHeader.replace("${version}", EbeanVersion.getVersion());
            header = header.replace("${timestamp}", ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT));
            return header;
        }
        return this.ddlHeader;
    }

    @Override
    public boolean isDdlStrictMode() {
        return this.ddlStrictMode;
    }

    @Override
    public DatabaseConfig setDdlStrictMode(boolean ddlStrictMode) {
        this.ddlStrictMode = ddlStrictMode;
        return this;
    }

    @Override
    public String getDdlPlaceholders() {
        return this.ddlPlaceholders;
    }

    @Override
    public DatabaseConfig setDdlPlaceholders(String ddlPlaceholders) {
        this.ddlPlaceholders = ddlPlaceholders;
        return this;
    }

    @Override
    public Map<String, String> getDdlPlaceholderMap() {
        return this.ddlPlaceholderMap;
    }

    @Override
    public DatabaseConfig setDdlPlaceholderMap(Map<String, String> ddlPlaceholderMap) {
        this.ddlPlaceholderMap = ddlPlaceholderMap;
        return this;
    }

    @Override
    public boolean isDisableClasspathSearch() {
        return this.disableClasspathSearch;
    }

    @Override
    public DatabaseConfig setDisableClasspathSearch(boolean disableClasspathSearch) {
        this.disableClasspathSearch = disableClasspathSearch;
        return this;
    }

    @Override
    public String getJodaLocalTimeMode() {
        return this.jodaLocalTimeMode;
    }

    @Override
    public DatabaseConfig setJodaLocalTimeMode(String jodaLocalTimeMode) {
        this.jodaLocalTimeMode = jodaLocalTimeMode;
        return this;
    }

    @Override
    public DatabaseConfig addClass(Class<?> cls) {
        this.classes.add(cls);
        return this;
    }

    @Override
    public DatabaseConfig addAll(Collection<Class<?>> classList) {
        if (classList != null && !classList.isEmpty()) {
            this.classes.addAll(classList);
        }
        return this;
    }

    @Override
    public DatabaseConfig addPackage(String packageName) {
        this.packages.add(packageName);
        return this;
    }

    @Override
    public List<String> getPackages() {
        return this.packages;
    }

    @Override
    public DatabaseConfig setPackages(List<String> packages) {
        this.packages = packages;
        return this;
    }

    public void setClasses(Collection<Class<?>> classes) {
        this.classes = new HashSet(classes);
    }

    @Override
    public DatabaseConfig classes(Collection<Class<?>> classes) {
        this.classes = new HashSet(classes);
        return this;
    }

    @Override
    public Set<Class<?>> classes() {
        return this.classes;
    }

    @Override
    @Deprecated(forRemoval=true)
    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    @Override
    public boolean isSkipCacheAfterWrite() {
        return this.skipCacheAfterWrite;
    }

    @Override
    public DatabaseConfig setSkipCacheAfterWrite(boolean skipCacheAfterWrite) {
        this.skipCacheAfterWrite = skipCacheAfterWrite;
        return this;
    }

    @Override
    public boolean isUpdateAllPropertiesInBatch() {
        return this.updateAllPropertiesInBatch;
    }

    @Override
    public DatabaseConfig setUpdateAllPropertiesInBatch(boolean updateAllPropertiesInBatch) {
        this.updateAllPropertiesInBatch = updateAllPropertiesInBatch;
        return this;
    }

    @Override
    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    @Override
    public DatabaseConfig setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
        return this;
    }

    @Override
    public DatabaseConfig addCustomMapping(DbType type, String columnDefinition, Platform platform) {
        this.platformConfig.addCustomMapping(type, columnDefinition, platform);
        return this;
    }

    @Override
    public DatabaseConfig addCustomMapping(DbType type, String columnDefinition) {
        this.platformConfig.addCustomMapping(type, columnDefinition);
        return this;
    }

    @Override
    public DatabaseConfig add(BeanQueryAdapter beanQueryAdapter) {
        this.queryAdapters.add(beanQueryAdapter);
        return this;
    }

    @Override
    public List<BeanQueryAdapter> getQueryAdapters() {
        return this.queryAdapters;
    }

    @Override
    public DatabaseConfig setQueryAdapters(List<BeanQueryAdapter> queryAdapters) {
        this.queryAdapters = queryAdapters;
        return this;
    }

    @Override
    public List<IdGenerator> getIdGenerators() {
        return this.idGenerators;
    }

    @Override
    public DatabaseConfig setIdGenerators(List<IdGenerator> idGenerators) {
        this.idGenerators = idGenerators;
        return this;
    }

    @Override
    public DatabaseConfig add(IdGenerator idGenerator) {
        this.idGenerators.add(idGenerator);
        return this;
    }

    @Override
    public DatabaseConfig add(BeanPersistController beanPersistController) {
        this.persistControllers.add(beanPersistController);
        return this;
    }

    @Override
    public DatabaseConfig add(BeanPostLoad postLoad) {
        this.postLoaders.add(postLoad);
        return this;
    }

    @Override
    public DatabaseConfig add(BeanPostConstructListener listener) {
        this.postConstructListeners.add(listener);
        return this;
    }

    @Override
    public List<BeanFindController> getFindControllers() {
        return this.findControllers;
    }

    @Override
    public DatabaseConfig setFindControllers(List<BeanFindController> findControllers) {
        this.findControllers = findControllers;
        return this;
    }

    @Override
    public List<BeanPostLoad> getPostLoaders() {
        return this.postLoaders;
    }

    @Override
    public DatabaseConfig setPostLoaders(List<BeanPostLoad> postLoaders) {
        this.postLoaders = postLoaders;
        return this;
    }

    @Override
    public List<BeanPostConstructListener> getPostConstructListeners() {
        return this.postConstructListeners;
    }

    @Override
    public DatabaseConfig setPostConstructListeners(List<BeanPostConstructListener> listeners) {
        this.postConstructListeners = listeners;
        return this;
    }

    @Override
    public List<BeanPersistController> getPersistControllers() {
        return this.persistControllers;
    }

    @Override
    public DatabaseConfig setPersistControllers(List<BeanPersistController> persistControllers) {
        this.persistControllers = persistControllers;
        return this;
    }

    @Override
    public DatabaseConfig add(BeanPersistListener beanPersistListener) {
        this.persistListeners.add(beanPersistListener);
        return this;
    }

    @Override
    public List<BeanPersistListener> getPersistListeners() {
        return this.persistListeners;
    }

    @Override
    public DatabaseConfig add(BulkTableEventListener bulkTableEventListener) {
        this.bulkTableEventListeners.add(bulkTableEventListener);
        return this;
    }

    @Override
    public List<BulkTableEventListener> getBulkTableEventListeners() {
        return this.bulkTableEventListeners;
    }

    @Override
    public DatabaseConfig addServerConfigStartup(ServerConfigStartup configStartupListener) {
        this.configStartupListeners.add(configStartupListener);
        return this;
    }

    @Override
    public List<ServerConfigStartup> getServerConfigStartupListeners() {
        return this.configStartupListeners;
    }

    @Override
    public DatabaseConfig setPersistListeners(List<BeanPersistListener> persistListeners) {
        this.persistListeners = persistListeners;
        return this;
    }

    @Override
    public PersistenceContextScope getPersistenceContextScope() {
        return this.persistenceContextScope == null ? PersistenceContextScope.TRANSACTION : this.persistenceContextScope;
    }

    @Override
    public DatabaseConfig setPersistenceContextScope(PersistenceContextScope persistenceContextScope) {
        this.persistenceContextScope = persistenceContextScope;
        return this;
    }

    @Override
    public ClassLoadConfig getClassLoadConfig() {
        return this.classLoadConfig;
    }

    @Override
    public DatabaseConfig setClassLoadConfig(ClassLoadConfig classLoadConfig) {
        this.classLoadConfig = classLoadConfig;
        return this;
    }

    @Override
    public DatabaseConfig loadFromProperties() {
        this.properties = Config.asProperties();
        this.configureFromProperties();
        return this;
    }

    @Override
    public DatabaseConfig loadFromProperties(Properties properties) {
        this.properties = Config.asConfiguration().eval(properties);
        this.configureFromProperties();
        return this;
    }

    private void configureFromProperties() {
        List<AutoConfigure> autoConfigures = this.autoConfiguration();
        this.loadSettings(new PropertiesWrapper("ebean", this.name, this.properties, this.classLoadConfig));
        for (AutoConfigure autoConfigure : autoConfigures) {
            autoConfigure.postConfigure(this);
        }
    }

    private List<AutoConfigure> autoConfiguration() {
        ArrayList<AutoConfigure> list = new ArrayList<AutoConfigure>();
        for (AutoConfigure autoConfigure : ServiceLoader.load(AutoConfigure.class)) {
            autoConfigure.preConfigure(this);
            list.add(autoConfigure);
        }
        return list;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    protected void loadDataSourceSettings(PropertiesWrapper p) {
        this.dataSourceConfig.loadSettings(p.properties, this.name);
        this.readOnlyDataSourceConfig.loadSettings(p.properties, this.name + "-ro");
    }

    protected void loadAutoTuneSettings(PropertiesWrapper p) {
        this.autoTuneConfig.loadSettings(p);
    }

    protected void loadSettings(PropertiesWrapper p) {
        this.dbSchema = p.get("dbSchema", this.dbSchema);
        this.profilingConfig.loadSettings(p, this.name);
        this.platformConfig.loadSettings(p);
        if (this.platformConfig.isAllQuotedIdentifiers()) {
            this.adjustNamingConventionForAllQuoted();
        }
        this.namingConvention = this.createNamingConvention(p, this.namingConvention);
        if (this.namingConvention != null) {
            this.namingConvention.loadFromProperties(p);
        }
        if (this.autoTuneConfig == null) {
            this.autoTuneConfig = new AutoTuneConfig();
        }
        this.loadAutoTuneSettings(p);
        if (this.dataSourceConfig == null) {
            this.dataSourceConfig = DataSourceBuilder.create().settings();
        }
        this.loadDataSourceSettings(p);
        this.defaultServer = p.getBoolean("defaultServer", this.defaultServer);
        this.shutdownHook = p.getBoolean("shutdownHook", this.shutdownHook);
        this.readOnlyDatabase = p.getBoolean("readOnlyDatabase", this.readOnlyDatabase);
        this.autoPersistUpdates = p.getBoolean("autoPersistUpdates", this.autoPersistUpdates);
        this.loadModuleInfo = p.getBoolean("loadModuleInfo", this.loadModuleInfo);
        this.includeLabelInSql = p.getBoolean("includeLabelInSql", this.includeLabelInSql);
        this.maxCallStack = p.getInt("maxCallStack", this.maxCallStack);
        this.dumpMetricsOnShutdown = p.getBoolean("dumpMetricsOnShutdown", this.dumpMetricsOnShutdown);
        this.dumpMetricsOptions = p.get("dumpMetricsOptions", this.dumpMetricsOptions);
        this.queryPlanTTLSeconds = p.getInt("queryPlanTTLSeconds", this.queryPlanTTLSeconds);
        this.slowQueryMillis = p.getLong("slowQueryMillis", this.slowQueryMillis);
        this.queryPlanEnable = p.getBoolean("queryPlan.enable", this.queryPlanEnable);
        this.queryPlanThresholdMicros = p.getLong("queryPlan.thresholdMicros", this.queryPlanThresholdMicros);
        this.queryPlanCapture = p.getBoolean("queryPlan.capture", this.queryPlanCapture);
        this.queryPlanCapturePeriodSecs = p.getLong("queryPlan.capturePeriodSecs", this.queryPlanCapturePeriodSecs);
        this.queryPlanCaptureMaxTimeMillis = p.getLong("queryPlan.captureMaxTimeMillis", this.queryPlanCaptureMaxTimeMillis);
        this.queryPlanCaptureMaxCount = p.getInt("queryPlan.captureMaxCount", this.queryPlanCaptureMaxCount);
        this.queryPlanExplain = p.get("queryPlan.explain", this.queryPlanExplain);
        this.disableL2Cache = p.getBoolean("disableL2Cache", this.disableL2Cache);
        this.localOnlyL2Cache = p.getBoolean("localOnlyL2Cache", this.localOnlyL2Cache);
        this.enabledL2Regions = p.get("enabledL2Regions", this.enabledL2Regions);
        this.notifyL2CacheInForeground = p.getBoolean("notifyL2CacheInForeground", this.notifyL2CacheInForeground);
        this.useJtaTransactionManager = p.getBoolean("useJtaTransactionManager", this.useJtaTransactionManager);
        this.useValidationNotNull = p.getBoolean("useValidationNotNull", this.useValidationNotNull);
        this.autoReadOnlyDataSource = p.getBoolean("autoReadOnlyDataSource", this.autoReadOnlyDataSource);
        this.idGeneratorAutomatic = p.getBoolean("idGeneratorAutomatic", this.idGeneratorAutomatic);
        this.backgroundExecutorSchedulePoolSize = p.getInt("backgroundExecutorSchedulePoolSize", this.backgroundExecutorSchedulePoolSize);
        this.backgroundExecutorShutdownSecs = p.getInt("backgroundExecutorShutdownSecs", this.backgroundExecutorShutdownSecs);
        this.backgroundExecutorWrapper = p.createInstance(BackgroundExecutorWrapper.class, "backgroundExecutorWrapper", this.backgroundExecutorWrapper);
        this.disableClasspathSearch = p.getBoolean("disableClasspathSearch", this.disableClasspathSearch);
        this.currentUserProvider = p.createInstance(CurrentUserProvider.class, "currentUserProvider", this.currentUserProvider);
        this.databasePlatform = p.createInstance(DatabasePlatform.class, "databasePlatform", this.databasePlatform);
        this.encryptKeyManager = p.createInstance(EncryptKeyManager.class, "encryptKeyManager", this.encryptKeyManager);
        this.encryptDeployManager = p.createInstance(EncryptDeployManager.class, "encryptDeployManager", this.encryptDeployManager);
        this.encryptor = p.createInstance(Encryptor.class, "encryptor", this.encryptor);
        this.dbEncrypt = p.createInstance(DbEncrypt.class, "dbEncrypt", this.dbEncrypt);
        this.dbOffline = p.getBoolean("dbOffline", this.dbOffline);
        this.serverCachePlugin = p.createInstance(ServerCachePlugin.class, "serverCachePlugin", this.serverCachePlugin);
        String packagesProp = p.get("search.packages", p.get("packages", null));
        this.packages = this.searchList(packagesProp, this.packages);
        this.skipCacheAfterWrite = p.getBoolean("skipCacheAfterWrite", this.skipCacheAfterWrite);
        this.updateAllPropertiesInBatch = p.getBoolean("updateAllPropertiesInBatch", this.updateAllPropertiesInBatch);
        if (p.get("batch.mode") != null || p.get("persistBatching") != null) {
            throw new IllegalArgumentException("Property 'batch.mode' or 'persistBatching' is being set but no longer used. Please change to use 'persistBatchMode'");
        }
        this.persistBatch = p.getEnum(PersistBatch.class, "persistBatch", this.persistBatch);
        this.persistBatchOnCascade = p.getEnum(PersistBatch.class, "persistBatchOnCascade", this.persistBatchOnCascade);
        int batchSize = p.getInt("batch.size", this.persistBatchSize);
        this.persistBatchSize = p.getInt("persistBatchSize", batchSize);
        this.persistenceContextScope = PersistenceContextScope.valueOf(p.get("persistenceContextScope", "TRANSACTION"));
        this.changeLogAsync = p.getBoolean("changeLogAsync", this.changeLogAsync);
        this.changeLogIncludeInserts = p.getBoolean("changeLogIncludeInserts", this.changeLogIncludeInserts);
        this.expressionEqualsWithNullAsNoop = p.getBoolean("expressionEqualsWithNullAsNoop", this.expressionEqualsWithNullAsNoop);
        this.expressionNativeIlike = p.getBoolean("expressionNativeIlike", this.expressionNativeIlike);
        this.dataTimeZone = p.get("dataTimeZone", this.dataTimeZone);
        this.asOfViewSuffix = p.get("asOfViewSuffix", this.asOfViewSuffix);
        this.asOfSysPeriod = p.get("asOfSysPeriod", this.asOfSysPeriod);
        this.historyTableSuffix = p.get("historyTableSuffix", this.historyTableSuffix);
        this.jdbcFetchSizeFindEach = p.getInt("jdbcFetchSizeFindEach", this.jdbcFetchSizeFindEach);
        this.jdbcFetchSizeFindList = p.getInt("jdbcFetchSizeFindList", this.jdbcFetchSizeFindList);
        this.databasePlatformName = p.get("databasePlatformName", this.databasePlatformName);
        this.lengthCheck = p.getEnum(LengthCheck.class, "lengthCheck", this.lengthCheck);
        this.uuidVersion = p.getEnum(UuidVersion.class, "uuidVersion", this.uuidVersion);
        this.uuidStateFile = p.get("uuidStateFile", this.uuidStateFile);
        this.uuidNodeId = p.get("uuidNodeId", this.uuidNodeId);
        this.localTimeWithNanos = p.getBoolean("localTimeWithNanos", this.localTimeWithNanos);
        this.jodaLocalTimeMode = p.get("jodaLocalTimeMode", this.jodaLocalTimeMode);
        this.defaultEnumType = p.getEnum(EnumType.class, "defaultEnumType", this.defaultEnumType);
        this.disableLazyLoading = p.getBoolean("disableLazyLoading", this.disableLazyLoading);
        this.lazyLoadBatchSize = p.getInt("lazyLoadBatchSize", this.lazyLoadBatchSize);
        this.queryBatchSize = p.getInt("queryBatchSize", this.queryBatchSize);
        this.jsonInclude = p.getEnum(JsonConfig.Include.class, "jsonInclude", this.jsonInclude);
        this.jsonDateTime = p.getEnum(JsonConfig.DateTime.class, "jsonDateTime", this.jsonDateTime);
        this.jsonDate = p.getEnum(JsonConfig.Date.class, "jsonDate", this.jsonDate);
        this.jsonMutationDetection = p.getEnum(MutationDetection.class, "jsonMutationDetection", this.jsonMutationDetection);
        this.skipDataSourceCheck = p.getBoolean("skipDataSourceCheck", this.skipDataSourceCheck);
        this.runMigration = p.getBoolean("migration.run", this.runMigration);
        this.ddlGenerate = p.getBoolean("ddl.generate", this.ddlGenerate);
        this.ddlRun = p.getBoolean("ddl.run", this.ddlRun);
        this.ddlExtra = p.getBoolean("ddl.extra", this.ddlExtra);
        this.ddlCreateOnly = p.getBoolean("ddl.createOnly", this.ddlCreateOnly);
        this.ddlInitSql = p.get("ddl.initSql", this.ddlInitSql);
        this.ddlSeedSql = p.get("ddl.seedSql", this.ddlSeedSql);
        this.ddlStrictMode = p.getBoolean("ddl.strictMode", this.ddlStrictMode);
        this.ddlPlaceholders = p.get("ddl.placeholders", this.ddlPlaceholders);
        this.ddlHeader = p.get("ddl.header", this.ddlHeader);
        String mode = p.get("tenant.mode");
        if (mode != null) {
            for (TenantMode value : TenantMode.values()) {
                if (!value.name().equalsIgnoreCase(mode)) continue;
                this.tenantMode = value;
                break;
            }
        }
        this.currentTenantProvider = p.createInstance(CurrentTenantProvider.class, "tenant.currentTenantProvider", this.currentTenantProvider);
        this.tenantCatalogProvider = p.createInstance(TenantCatalogProvider.class, "tenant.catalogProvider", this.tenantCatalogProvider);
        this.tenantSchemaProvider = p.createInstance(TenantSchemaProvider.class, "tenant.schemaProvider", this.tenantSchemaProvider);
        this.tenantPartitionColumn = p.get("tenant.partitionColumn", this.tenantPartitionColumn);
        this.classes = this.readClasses(p);
        String mappingsProp = p.get("mappingLocations", null);
        this.mappingLocations = this.searchList(mappingsProp, this.mappingLocations);
    }

    private NamingConvention createNamingConvention(PropertiesWrapper properties, NamingConvention namingConvention) {
        NamingConvention nc = properties.createInstance(NamingConvention.class, "namingConvention", null);
        return nc != null ? nc : namingConvention;
    }

    private Set<Class<?>> readClasses(PropertiesWrapper properties) {
        String[] split;
        String classNames = properties.get("classes", null);
        if (classNames == null) {
            return this.classes;
        }
        HashSet classList = new HashSet();
        for (String cn : split = StringHelper.splitNames(classNames)) {
            if ("class".equalsIgnoreCase(cn)) continue;
            try {
                classList.add(Class.forName(cn));
            }
            catch (ClassNotFoundException e) {
                String msg = "Error registering class [" + cn + "] from [" + classNames + "]";
                throw new RuntimeException(msg, e);
            }
        }
        return classList;
    }

    private List<String> searchList(String searchNames, List<String> defaultValue) {
        if (searchNames != null) {
            String[] entries = StringHelper.splitNames(searchNames);
            ArrayList<String> hitList = new ArrayList<String>(entries.length);
            Collections.addAll(hitList, entries);
            return hitList;
        }
        return defaultValue;
    }

    @Override
    public PersistBatch appliedPersistBatchOnCascade() {
        if (this.persistBatchOnCascade == PersistBatch.INHERIT) {
            return this.databasePlatform.persistBatchOnCascade();
        }
        return this.persistBatchOnCascade;
    }

    @Override
    public Object getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public DatabaseConfig setObjectMapper(Object objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    @Override
    public boolean isExpressionEqualsWithNullAsNoop() {
        return this.expressionEqualsWithNullAsNoop;
    }

    @Override
    public DatabaseConfig setExpressionEqualsWithNullAsNoop(boolean expressionEqualsWithNullAsNoop) {
        this.expressionEqualsWithNullAsNoop = expressionEqualsWithNullAsNoop;
        return this;
    }

    @Override
    public boolean isExpressionNativeIlike() {
        return this.expressionNativeIlike;
    }

    @Override
    public DatabaseConfig setExpressionNativeIlike(boolean expressionNativeIlike) {
        this.expressionNativeIlike = expressionNativeIlike;
        return this;
    }

    @Override
    public String getEnabledL2Regions() {
        return this.enabledL2Regions;
    }

    @Override
    public DatabaseConfig setEnabledL2Regions(String enabledL2Regions) {
        this.enabledL2Regions = enabledL2Regions;
        return this;
    }

    @Override
    public boolean isDisableL2Cache() {
        return this.disableL2Cache;
    }

    @Override
    public DatabaseConfig setDisableL2Cache(boolean disableL2Cache) {
        this.disableL2Cache = disableL2Cache;
        return this;
    }

    @Override
    public boolean isLocalOnlyL2Cache() {
        return this.localOnlyL2Cache;
    }

    @Override
    public DatabaseConfig setLocalOnlyL2Cache(boolean localOnlyL2Cache) {
        this.localOnlyL2Cache = localOnlyL2Cache;
        return this;
    }

    @Override
    public boolean isUseValidationNotNull() {
        return this.useValidationNotNull;
    }

    @Override
    public DatabaseConfig setUseValidationNotNull(boolean useValidationNotNull) {
        this.useValidationNotNull = useValidationNotNull;
        return this;
    }

    @Override
    public boolean isNotifyL2CacheInForeground() {
        return this.notifyL2CacheInForeground;
    }

    @Override
    public DatabaseConfig setNotifyL2CacheInForeground(boolean notifyL2CacheInForeground) {
        this.notifyL2CacheInForeground = notifyL2CacheInForeground;
        return this;
    }

    @Override
    public int getQueryPlanTTLSeconds() {
        return this.queryPlanTTLSeconds;
    }

    @Override
    public String getQueryPlanExplain() {
        return this.queryPlanExplain;
    }

    @Override
    public DatabaseBuilder queryPlanExplain(String queryPlanExplain) {
        this.queryPlanExplain = queryPlanExplain;
        return this;
    }

    @Override
    public DatabaseConfig setQueryPlanTTLSeconds(int queryPlanTTLSeconds) {
        this.queryPlanTTLSeconds = queryPlanTTLSeconds;
        return this;
    }

    @Override
    public PlatformConfig newPlatformConfig(String propertiesPath, String platformPrefix) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        PropertiesWrapper p = new PropertiesWrapper(propertiesPath, platformPrefix, this.properties, this.classLoadConfig);
        PlatformConfig config = new PlatformConfig(this.platformConfig);
        config.loadSettings(p);
        return config;
    }

    @Override
    public DatabaseConfig addMappingLocation(String mappingLocation) {
        if (this.mappingLocations == null) {
            this.mappingLocations = new ArrayList<String>();
        }
        this.mappingLocations.add(mappingLocation);
        return this;
    }

    @Override
    public List<String> getMappingLocations() {
        return this.mappingLocations;
    }

    @Override
    public DatabaseConfig setMappingLocations(List<String> mappingLocations) {
        this.mappingLocations = mappingLocations;
        return this;
    }

    @Override
    public boolean isIdGeneratorAutomatic() {
        return this.idGeneratorAutomatic;
    }

    @Override
    public DatabaseConfig setIdGeneratorAutomatic(boolean idGeneratorAutomatic) {
        this.idGeneratorAutomatic = idGeneratorAutomatic;
        return this;
    }

    @Override
    public boolean isQueryPlanEnable() {
        return this.queryPlanEnable;
    }

    @Override
    public DatabaseConfig setQueryPlanEnable(boolean queryPlanEnable) {
        this.queryPlanEnable = queryPlanEnable;
        return this;
    }

    @Override
    public long getQueryPlanThresholdMicros() {
        return this.queryPlanThresholdMicros;
    }

    @Override
    public DatabaseConfig setQueryPlanThresholdMicros(long queryPlanThresholdMicros) {
        this.queryPlanThresholdMicros = queryPlanThresholdMicros;
        return this;
    }

    @Override
    public boolean isQueryPlanCapture() {
        return this.queryPlanCapture;
    }

    @Override
    public DatabaseConfig setQueryPlanCapture(boolean queryPlanCapture) {
        this.queryPlanCapture = queryPlanCapture;
        return this;
    }

    @Override
    public long getQueryPlanCapturePeriodSecs() {
        return this.queryPlanCapturePeriodSecs;
    }

    @Override
    public DatabaseConfig setQueryPlanCapturePeriodSecs(long queryPlanCapturePeriodSecs) {
        this.queryPlanCapturePeriodSecs = queryPlanCapturePeriodSecs;
        return this;
    }

    @Override
    public long getQueryPlanCaptureMaxTimeMillis() {
        return this.queryPlanCaptureMaxTimeMillis;
    }

    @Override
    public DatabaseConfig setQueryPlanCaptureMaxTimeMillis(long queryPlanCaptureMaxTimeMillis) {
        this.queryPlanCaptureMaxTimeMillis = queryPlanCaptureMaxTimeMillis;
        return this;
    }

    @Override
    public int getQueryPlanCaptureMaxCount() {
        return this.queryPlanCaptureMaxCount;
    }

    @Override
    public DatabaseConfig setQueryPlanCaptureMaxCount(int queryPlanCaptureMaxCount) {
        this.queryPlanCaptureMaxCount = queryPlanCaptureMaxCount;
        return this;
    }

    @Override
    public QueryPlanListener getQueryPlanListener() {
        return this.queryPlanListener;
    }

    @Override
    public DatabaseConfig setQueryPlanListener(QueryPlanListener queryPlanListener) {
        this.queryPlanListener = queryPlanListener;
        return this;
    }

    @Override
    public boolean isDumpMetricsOnShutdown() {
        return this.dumpMetricsOnShutdown;
    }

    @Override
    public DatabaseConfig setDumpMetricsOnShutdown(boolean dumpMetricsOnShutdown) {
        this.dumpMetricsOnShutdown = dumpMetricsOnShutdown;
        return this;
    }

    @Override
    public String getDumpMetricsOptions() {
        return this.dumpMetricsOptions;
    }

    @Override
    public DatabaseConfig setDumpMetricsOptions(String dumpMetricsOptions) {
        this.dumpMetricsOptions = dumpMetricsOptions;
        return this;
    }

    @Override
    public boolean isLoadModuleInfo() {
        return this.loadModuleInfo;
    }

    @Override
    public boolean isIncludeLabelInSql() {
        return this.includeLabelInSql;
    }

    @Override
    @Deprecated(forRemoval=true)
    public boolean isAutoLoadModuleInfo() {
        return this.loadModuleInfo;
    }

    @Override
    public DatabaseConfig setLoadModuleInfo(boolean loadModuleInfo) {
        this.loadModuleInfo = loadModuleInfo;
        return this;
    }

    @Override
    public DatabaseConfig includeLabelInSql(boolean includeLabelInSql) {
        this.includeLabelInSql = includeLabelInSql;
        return this;
    }

    @Override
    public Function<String, String> getMetricNaming() {
        return this.metricNaming;
    }

    @Override
    public DatabaseConfig setMetricNaming(Function<String, String> metricNaming) {
        this.metricNaming = metricNaming;
        return this;
    }

    @Override
    public LengthCheck getLengthCheck() {
        return this.lengthCheck;
    }

    @Override
    public DatabaseConfig lengthCheck(LengthCheck lengthCheck) {
        this.lengthCheck = lengthCheck;
        return this;
    }

    public static enum UuidVersion {
        VERSION4,
        VERSION1,
        VERSION1RND;

    }
}

