/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.event;

import io.ebean.Database;
import io.ebean.EbeanVersion;
import io.ebean.event.ClassUtil;
import io.ebean.service.SpiContainer;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public final class ShutdownManager {
    private static final System.Logger log = EbeanVersion.log;
    private static final ReentrantLock lock = new ReentrantLock();
    private static final List<Database> databases = Collections.synchronizedList(new ArrayList());
    private static final ShutdownHook shutdownHook = new ShutdownHook();
    private static boolean stopping;
    private static SpiContainer container;

    private ShutdownManager() {
    }

    public static void registerContainer(SpiContainer ebeanContainer) {
        container = ebeanContainer;
    }

    public static void touch() {
    }

    public static boolean isStopping() {
        lock.lock();
        try {
            boolean bl = stopping;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public static void deregisterShutdownHook() {
        lock.lock();
        try {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        catch (IllegalStateException ex) {
            if (!ex.getMessage().equals("Shutdown in progress")) {
                throw ex;
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void registerShutdownHook() {
        lock.lock();
        try {
            if ("true".equalsIgnoreCase(System.getProperty("ebean.registerShutdownHook", "true"))) {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
        }
        catch (IllegalStateException ex) {
            if (!ex.getMessage().equals("Shutdown in progress")) {
                throw ex;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        lock.lock();
        try {
            if (stopping) {
                return;
            }
            log.log(System.Logger.Level.DEBUG, "Ebean shutting down");
            stopping = true;
            ShutdownManager.deregisterShutdownHook();
            String shutdownRunner = System.getProperty("ebean.shutdown.runnable");
            if (shutdownRunner != null) {
                try {
                    Runnable r = (Runnable)ClassUtil.newInstance(shutdownRunner);
                    r.run();
                }
                catch (Exception e) {
                    log.log(System.Logger.Level.ERROR, "Error running custom shutdown runnable", (Throwable)e);
                }
            }
            if (container != null) {
                container.shutdown();
            }
            for (Database server : new ArrayList<Database>(databases)) {
                try {
                    server.shutdown();
                }
                catch (Exception ex) {
                    log.log(System.Logger.Level.ERROR, "Error executing shutdown runnable", (Throwable)ex);
                    ex.printStackTrace();
                }
            }
            if ("true".equalsIgnoreCase(System.getProperty("ebean.datasource.deregisterAllDrivers", "false"))) {
                ShutdownManager.deregisterAllJdbcDrivers();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void deregisterAllJdbcDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                log.log(System.Logger.Level.INFO, "De-registering jdbc driver: " + String.valueOf(driver));
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                log.log(System.Logger.Level.ERROR, "Error de-registering driver " + String.valueOf(driver), (Throwable)e);
            }
        }
    }

    public static void registerDatabase(Database server) {
        databases.add(server);
    }

    public static void unregisterDatabase(Database server) {
        databases.remove(server);
    }

    static {
        ShutdownManager.registerShutdownHook();
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
            super("EbeanHook");
        }

        @Override
        public void run() {
            ShutdownManager.shutdown();
        }
    }
}

