/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.autotune.service;

import io.ebeaninternal.server.autotune.model.Autotune;
import io.ebeaninternal.server.autotune.service.SortAutoTuneDocument;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class AutoTuneXmlWriter {
    public static String now() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        return df.format(new Date());
    }

    public void write(Autotune document, String fileName, boolean withNow) {
        SortAutoTuneDocument.sort(document);
        if (withNow) {
            fileName = fileName + "-" + AutoTuneXmlWriter.now() + ".xml";
        }
        this.write(document, new File(fileName));
    }

    public void write(Autotune profiling, File file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Autotune.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)profiling, file);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

