/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.autotune.service;

import io.ebean.bean.CallOrigin;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.config.AutoTuneConfig;
import io.ebean.config.AutoTuneMode;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.autotune.ProfilingListener;
import io.ebeaninternal.server.autotune.model.Origin;
import io.ebeaninternal.server.autotune.service.TunedQueryInfo;
import io.ebeaninternal.server.querydefn.OrmQueryDetail;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;

public class BaseQueryTuner {
    private final boolean queryTuning;
    private final boolean profiling;
    private final AutoTuneMode mode;
    private final Map<String, TunedQueryInfo> tunedQueryInfoMap = new ConcurrentHashMap<String, TunedQueryInfo>();
    private final SpiEbeanServer server;
    private final ProfilingListener profilingListener;
    private final boolean skipAll;

    BaseQueryTuner(AutoTuneConfig config, SpiEbeanServer server, ProfilingListener profilingListener) {
        this.server = server;
        this.profilingListener = profilingListener;
        this.mode = config.getMode();
        this.queryTuning = config.isQueryTuning();
        this.profiling = config.isProfiling();
        this.skipAll = !this.queryTuning && !this.profiling;
    }

    public Collection<TunedQueryInfo> getAll() {
        return this.tunedQueryInfoMap.values();
    }

    public void put(Origin origin) {
        this.tunedQueryInfoMap.put(origin.getKey(), new TunedQueryInfo(origin));
    }

    public void load(String key, TunedQueryInfo queryInfo) {
        this.tunedQueryInfoMap.put(key, queryInfo);
    }

    public OrmQueryDetail get(String key) {
        TunedQueryInfo info = this.tunedQueryInfoMap.get(key);
        return info == null ? null : info.getTunedDetail();
    }

    boolean tuneQuery(SpiQuery<?> query) {
        if (this.skipAll || !this.tunableQuery(query)) {
            return false;
        }
        if (query.getProfilingListener() != null) {
            return false;
        }
        if (!this.useTuning(query)) {
            if (this.profiling) {
                this.profiling(query, this.server.createCallOrigin());
            }
            return false;
        }
        if (query.getParentNode() != null) {
            query.setProfilingListener(this.profilingListener);
            return true;
        }
        CallOrigin callOrigin = this.server.createCallOrigin();
        ObjectGraphNode origin = query.setOrigin(callOrigin);
        if (this.profiling && this.profilingListener.isProfileRequest(origin, query)) {
            query.setProfilingListener(this.profilingListener);
        }
        if (this.queryTuning) {
            TunedQueryInfo tuneInfo = this.tunedQueryInfoMap.get(origin.getOriginQueryPoint().getKey());
            return tuneInfo != null && tuneInfo.tuneQuery(query);
        }
        return false;
    }

    private boolean tunableQuery(SpiQuery<?> query) {
        SpiQuery.Type type = query.getType();
        switch (type) {
            case COUNT: 
            case ATTRIBUTE: 
            case ID_LIST: 
            case UPDATE: 
            case DELETE: 
            case SUBQUERY: {
                return false;
            }
        }
        return !query.isForceHitDatabase() && SpiQuery.TemporalMode.VERSIONS != query.getTemporalMode();
    }

    private void profiling(SpiQuery<?> query, CallOrigin call) {
        ObjectGraphNode origin = query.setOrigin(call);
        if (this.profilingListener.isProfileRequest(origin, query)) {
            query.setProfilingListener(this.profilingListener);
        }
    }

    private boolean useTuning(SpiQuery<?> query) {
        Boolean autoTune = query.isAutoTune();
        if (autoTune != null) {
            return autoTune;
        }
        switch (this.mode) {
            case DEFAULT_ON: {
                return true;
            }
            case DEFAULT_OFF: {
                return false;
            }
            case DEFAULT_ONIFEMPTY: {
                return query.isDetailEmpty();
            }
        }
        throw new PersistenceException("Invalid AutoTuneMode " + this.mode);
    }

    public Set<String> keySet() {
        return this.tunedQueryInfoMap.keySet();
    }
}

