/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.autotune.service;

import io.ebean.bean.NodeUsageCollector;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.bean.ObjectGraphOrigin;
import io.ebean.config.AutoTuneConfig;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.autotune.ProfilingListener;
import io.ebeaninternal.server.autotune.service.AutoTuneCollection;
import io.ebeaninternal.server.autotune.service.ProfileOrigin;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class ProfileManager
implements ProfilingListener {
    private final ReentrantLock lock = new ReentrantLock(false);
    private final boolean queryTuningAddVersion;
    private final double profilingRate;
    private final int profilingBase;
    private final Map<String, ProfileOrigin> profileMap = new ConcurrentHashMap<String, ProfileOrigin>();
    private final SpiEbeanServer server;

    public ProfileManager(AutoTuneConfig config, SpiEbeanServer server) {
        this.server = server;
        this.profilingRate = config.getProfilingRate();
        this.profilingBase = config.getProfilingBase();
        this.queryTuningAddVersion = config.isQueryTuningAddVersion();
    }

    public boolean isProfileRequest(ObjectGraphNode origin, SpiQuery<?> query) {
        ProfileOrigin profileOrigin = this.profileMap.get(origin.getOriginQueryPoint().getKey());
        if (profileOrigin == null) {
            this.profileMap.put(origin.getOriginQueryPoint().getKey(), this.createProfileOrigin(origin, query));
            return true;
        }
        return profileOrigin.isProfile();
    }

    private ProfileOrigin createProfileOrigin(ObjectGraphNode origin, SpiQuery<?> query) {
        ProfileOrigin profileOrigin = new ProfileOrigin(origin.getOriginQueryPoint(), this.queryTuningAddVersion, this.profilingBase, this.profilingRate);
        profileOrigin.setOriginalQuery(query.getDetail().toString());
        return profileOrigin;
    }

    public void collectQueryInfo(ObjectGraphNode node, long beans, long micros) {
        ObjectGraphOrigin origin;
        if (node != null && (origin = node.getOriginQueryPoint()) != null) {
            ProfileOrigin stats = this.getProfileOrigin(origin);
            stats.collectQueryInfo(node, beans, micros);
        }
    }

    public void collectNodeUsage(NodeUsageCollector usageCollector) {
        ProfileOrigin profileOrigin = this.getProfileOrigin(usageCollector.getNode().getOriginQueryPoint());
        profileOrigin.collectUsageInfo(usageCollector);
    }

    private ProfileOrigin getProfileOrigin(ObjectGraphOrigin originQueryPoint) {
        this.lock.lock();
        try {
            ProfileOrigin profileOrigin = this.profileMap.computeIfAbsent(originQueryPoint.getKey(), k -> new ProfileOrigin(originQueryPoint, this.queryTuningAddVersion, this.profilingBase, this.profilingRate));
            return profileOrigin;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AutoTuneCollection profilingCollection(boolean reset) {
        AutoTuneCollection req = new AutoTuneCollection();
        for (ProfileOrigin origin : this.profileMap.values()) {
            BeanDescriptor desc = this.server.getBeanDescriptorById(origin.getOrigin().getBeanType());
            if (desc == null) continue;
            origin.profilingCollection(desc, req, reset);
        }
        return req;
    }
}

