/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebean.CacheMode;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionLoader;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.LoadManyBuffer;
import io.ebeaninternal.api.LoadRequest;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.BindPadding;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadManyRequest
extends LoadRequest {
    private static final Logger logger = LoggerFactory.getLogger(LoadManyRequest.class);
    private final List<BeanCollection<?>> batch;
    private final LoadManyBuffer loadContext;
    private final boolean onlyIds;
    private final boolean loadCache;

    public LoadManyRequest(LoadManyBuffer loadContext, boolean onlyIds, boolean loadCache) {
        this(loadContext, null, true, onlyIds, loadCache);
    }

    public LoadManyRequest(LoadManyBuffer loadContext, OrmQueryRequest<?> parentRequest) {
        this(loadContext, parentRequest, false, false, false);
    }

    private LoadManyRequest(LoadManyBuffer loadContext, OrmQueryRequest<?> parentRequest, boolean lazy, boolean onlyIds, boolean loadCache) {
        super(parentRequest, lazy);
        this.loadContext = loadContext;
        this.batch = loadContext.getBatch();
        this.onlyIds = onlyIds;
        this.loadCache = loadCache;
    }

    @Override
    public Class<?> beanType() {
        return this.loadContext.getBeanDescriptor().getBeanType();
    }

    public String description() {
        return this.loadContext.getFullPath();
    }

    private List<Object> parentIdList(SpiEbeanServer server) {
        ArrayList<Object> idList = new ArrayList<Object>();
        BeanPropertyAssocMany<?> many = this.many();
        for (BeanCollection<?> bc : this.batch) {
            idList.add(many.getParentId(bc.getOwnerBean()));
            bc.setLoader((BeanCollectionLoader)server);
        }
        if (many.getTargetDescriptor().isPadInExpression()) {
            BindPadding.padIds(idList);
        }
        return idList;
    }

    private BeanPropertyAssocMany<?> many() {
        return this.loadContext.getBeanProperty();
    }

    public SpiQuery<?> createQuery(SpiEbeanServer server) {
        String extraWhere;
        BeanPropertyAssocMany many = this.many();
        SpiQuery query = many.newQuery(server);
        String orderBy = many.getLazyFetchOrderBy();
        if (orderBy != null) {
            query.order(orderBy);
        }
        if ((extraWhere = many.getExtraWhere()) != null) {
            query.where().raw(extraWhere.replace("${ta}", "t0").replace("${mta}", "int_"));
        }
        query.setLazyLoadForParents(many);
        many.addWhereParentIdIn(query, this.parentIdList(server), this.loadContext.isUseDocStore());
        query.setPersistenceContext(this.loadContext.getPersistenceContext());
        query.setLoadDescription(this.lazy ? "+lazy" : "+query", this.description());
        if (this.lazy) {
            query.setLazyLoadBatchSize(this.loadContext.getBatchSize());
        } else {
            query.setBeanCacheMode(CacheMode.OFF);
        }
        this.loadContext.configureQuery(query);
        if (this.onlyIds) {
            query.select(many.getTargetIdProperty());
        }
        return query;
    }

    public void postLoad() {
        BeanDescriptor<?> desc = this.loadContext.getBeanDescriptor();
        BeanPropertyAssocMany<?> many = this.many();
        for (BeanCollection<?> bc : this.batch) {
            if (bc.checkEmptyLazyLoad()) {
                if (!logger.isDebugEnabled()) continue;
                EntityBean ownerBean = bc.getOwnerBean();
                Object parentId = desc.getId(ownerBean);
                logger.debug("BeanCollection after lazy load was empty. type:" + ownerBean.getClass().getName() + " id:" + parentId + " owner:" + ownerBean);
                continue;
            }
            if (!this.loadCache || !many.isUseCache()) continue;
            desc.cacheManyPropPut(many, bc, desc.getId(bc.getOwnerBean()));
        }
    }
}

