/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.deploy.BeanDescriptorMap;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.meta.DeployBeanTable;
import io.ebeaninternal.server.deploy.meta.DeployTableJoin;
import io.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanTable {
    private static final Logger logger = LoggerFactory.getLogger(BeanTable.class);
    private final BeanDescriptorMap owner;
    private final Class<?> beanType;
    private final String baseTable;
    private final BeanProperty idProperty;

    public BeanTable(DeployBeanTable mutable, BeanDescriptorMap owner) {
        this.owner = owner;
        this.beanType = mutable.getBeanType();
        this.baseTable = InternString.intern(mutable.getBaseTable());
        this.idProperty = mutable.createIdProperty(owner);
    }

    public BeanTable(BeanDescriptorMap owner, String tableName, Class<?> beanType) {
        this.owner = owner;
        this.beanType = beanType;
        this.baseTable = tableName;
        this.idProperty = null;
    }

    public String toString() {
        return this.baseTable;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public String getUnqualifiedBaseTable() {
        String[] chunks = this.baseTable.split("\\.");
        return chunks.length == 2 ? chunks[1] : chunks[0];
    }

    public BeanProperty getIdProperty() {
        return this.idProperty;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public void createJoinColumn(String foreignKeyPrefix, DeployTableJoin join, boolean reverse, String sqlFormulaSelect) {
        if (this.idProperty == null) {
            return;
        }
        if (this.idProperty instanceof BeanPropertyAssocOne) {
            BeanProperty[] props;
            BeanPropertyAssocOne assocOne = (BeanPropertyAssocOne)this.idProperty;
            for (BeanProperty prop : props = assocOne.getProperties()) {
                this.addToJoin(foreignKeyPrefix, join, reverse, sqlFormulaSelect, true, prop);
            }
        } else {
            this.addToJoin(foreignKeyPrefix, join, reverse, sqlFormulaSelect, false, this.idProperty);
        }
    }

    private void addToJoin(String foreignKeyPrefix, DeployTableJoin join, boolean reverse, String sqlFormulaSelect, boolean complexKey, BeanProperty prop) {
        String lc;
        String fk = lc = prop.getDbColumn();
        if (foreignKeyPrefix != null) {
            fk = this.owner.getNamingConvention().getForeignKey(foreignKeyPrefix, fk);
        }
        if (complexKey) {
            logger.debug("On table[{}] foreign key column [{}]", (Object)this.baseTable, (Object)lc);
            fk = lc;
        }
        if (sqlFormulaSelect != null) {
            fk = sqlFormulaSelect;
        }
        DeployTableJoinColumn joinCol = new DeployTableJoinColumn(lc, fk);
        joinCol.setForeignSqlFormula(sqlFormulaSelect);
        if (reverse) {
            joinCol = joinCol.reverse();
        }
        join.addJoinColumn(joinCol);
    }

    public String getIdColumn() {
        return this.idProperty.dbColumn;
    }
}

