/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.QueryPlanMetric;
import io.ebean.metric.TimedMetric;
import io.ebean.metric.TimedMetricStats;
import io.ebeaninternal.server.profile.DQueryPlanMeta;
import io.ebeaninternal.server.profile.DTimeMetricStats;
import io.ebeaninternal.server.profile.DTimedMetric;

final class DQueryPlanMetric
implements QueryPlanMetric {
    private final DQueryPlanMeta meta;
    private final DTimedMetric metric;
    private boolean collected;

    DQueryPlanMetric(DQueryPlanMeta meta, DTimedMetric metric) {
        this.meta = meta;
        this.metric = metric;
    }

    public void visit(MetricVisitor visitor) {
        DTimeMetricStats stats = this.metric.collect(visitor.reset());
        if (stats != null) {
            visitor.visitQuery((MetaQueryMetric)new Stats(this.meta, stats, this.collected));
            this.collected = true;
        }
    }

    public TimedMetric getMetric() {
        return this.metric;
    }

    private static class Stats
    implements MetaQueryMetric {
        private final DQueryPlanMeta meta;
        private final TimedMetricStats stats;
        private final boolean collected;

        private Stats(DQueryPlanMeta meta, TimedMetricStats stats, boolean collected) {
            this.meta = meta;
            this.stats = stats;
            this.collected = collected;
        }

        public String toString() {
            return this.meta + " " + this.stats + " sql:" + this.sql();
        }

        public Class<?> type() {
            return this.meta.getType();
        }

        public boolean initialCollection() {
            return !this.collected;
        }

        public String hash() {
            return this.meta.getHash();
        }

        public String label() {
            return this.meta.getLabel();
        }

        public String sql() {
            return this.meta.getSql();
        }

        public String name() {
            return this.meta.getName();
        }

        public String location() {
            return this.meta.getLocation();
        }

        public long count() {
            return this.stats.count();
        }

        public long total() {
            return this.stats.total();
        }

        public long max() {
            return this.stats.max();
        }

        public long mean() {
            return this.stats.mean();
        }
    }
}

