/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.changelog;

import io.ebean.event.changelog.BeanChange;
import io.ebean.event.changelog.ChangeLogListener;
import io.ebean.event.changelog.ChangeSet;
import io.ebean.event.changelog.ChangeType;
import io.ebean.plugin.Plugin;
import io.ebean.plugin.SpiServer;
import io.ebeaninternal.server.changelog.ChangeJsonBuilder;
import java.io.StringWriter;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultChangeLogListener
implements ChangeLogListener,
Plugin {
    private static final Logger logger = LoggerFactory.getLogger(DefaultChangeLogListener.class);
    private static final Logger changeLog = LoggerFactory.getLogger((String)"io.ebean.ChangeLog");
    private ChangeJsonBuilder jsonBuilder;
    private int defaultBufferSize = 400;

    public void configure(SpiServer server) {
        String bufferSize;
        this.jsonBuilder = new ChangeJsonBuilder();
        Properties properties = server.config().getProperties();
        if (properties != null && (bufferSize = properties.getProperty("ebean.changeLog.bufferSize")) != null) {
            this.defaultBufferSize = Integer.parseInt(bufferSize);
        }
    }

    public void online(boolean online) {
    }

    public void shutdown() {
    }

    public void log(ChangeSet changeSet) {
        for (BeanChange beanChange : changeSet.getChanges()) {
            try {
                StringWriter writer = new StringWriter(this.getBufferSize(beanChange));
                this.jsonBuilder.writeBeanJson(writer, beanChange, changeSet);
                changeLog.info(writer.toString());
            }
            catch (Exception e) {
                logger.error("Exception logging beanChange " + beanChange.toString(), (Throwable)e);
            }
        }
    }

    private int getBufferSize(BeanChange beanChange) {
        return ChangeType.DELETE == beanChange.getEvent() ? 250 : this.defaultBufferSize;
    }
}

