/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.clickhouse.ClickHousePlatform;
import io.ebean.config.dbplatform.cockroach.CockroachPlatform;
import io.ebean.config.dbplatform.db2.DB2Platform;
import io.ebean.config.dbplatform.h2.H2Platform;
import io.ebean.config.dbplatform.hana.HanaPlatform;
import io.ebean.config.dbplatform.hsqldb.HsqldbPlatform;
import io.ebean.config.dbplatform.mariadb.MariaDbPlatform;
import io.ebean.config.dbplatform.mysql.MySql55Platform;
import io.ebean.config.dbplatform.mysql.MySqlPlatform;
import io.ebean.config.dbplatform.nuodb.NuoDbPlatform;
import io.ebean.config.dbplatform.oracle.Oracle11Platform;
import io.ebean.config.dbplatform.oracle.OraclePlatform;
import io.ebean.config.dbplatform.postgres.Postgres9Platform;
import io.ebean.config.dbplatform.postgres.PostgresPlatform;
import io.ebean.config.dbplatform.sqlanywhere.SqlAnywherePlatform;
import io.ebean.config.dbplatform.sqlite.SQLitePlatform;
import io.ebean.config.dbplatform.sqlserver.SqlServer16Platform;
import io.ebean.config.dbplatform.sqlserver.SqlServer17Platform;
import io.ebeaninternal.api.DbOffline;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePlatformFactory {
    private static final Logger logger = LoggerFactory.getLogger(DatabasePlatformFactory.class);

    public DatabasePlatform create(DatabaseConfig config) {
        try {
            String offlinePlatform = DbOffline.getPlatform();
            if (offlinePlatform != null) {
                logger.info("offline platform [{}]", (Object)offlinePlatform);
                return this.byDatabaseName(offlinePlatform);
            }
            if (config.getDatabasePlatformName() != null) {
                return this.byDatabaseName(config.getDatabasePlatformName());
            }
            if (config.getDataSourceConfig().isOffline()) {
                throw new PersistenceException("DatabasePlatformName must be specified with offline mode");
            }
            return this.byDataSource(config.getDataSource());
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    private DatabasePlatform byDatabaseName(String dbName) {
        if ((dbName = dbName.toLowerCase()).equals("h2")) {
            return new H2Platform();
        }
        if (dbName.equals("mariadb")) {
            return new MariaDbPlatform();
        }
        if (dbName.equals("mysql")) {
            return new MySqlPlatform();
        }
        if (dbName.equals("mysql55")) {
            return new MySql55Platform();
        }
        if (dbName.equals("postgres") || dbName.equals("postgres9")) {
            return new PostgresPlatform();
        }
        if (dbName.equals("oracle11") || dbName.equals("oracle10") || dbName.equals("oracle9")) {
            return new Oracle11Platform();
        }
        if (dbName.equals("oracle")) {
            return new OraclePlatform();
        }
        if (dbName.equals("sqlserver16")) {
            return new SqlServer16Platform();
        }
        if (dbName.equals("sqlserver17")) {
            return new SqlServer17Platform();
        }
        if (dbName.equals("sqlserver")) {
            throw new IllegalArgumentException("Please choose the more specific sqlserver16 or sqlserver17 platform. Refer to issue #1340 for details");
        }
        if (dbName.equals("sqlanywhere")) {
            return new SqlAnywherePlatform();
        }
        if (dbName.equals("db2")) {
            return new DB2Platform();
        }
        if (dbName.equals("clickhouse")) {
            return new ClickHousePlatform();
        }
        if (dbName.equals("nuodb")) {
            return new NuoDbPlatform();
        }
        if (dbName.equals("sqlite")) {
            return new SQLitePlatform();
        }
        if (dbName.equals("hana")) {
            return new HanaPlatform();
        }
        throw new RuntimeException("database platform " + dbName + " is not known?");
    }

    private DatabasePlatform byDataSource(DataSource dataSource) {
        DatabasePlatform databasePlatform;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                databasePlatform = this.byDatabaseMeta(connection.getMetaData(), connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PersistenceException((Throwable)ex);
                }
            }
            connection.close();
        }
        return databasePlatform;
    }

    private DatabasePlatform byDatabaseMeta(DatabaseMetaData metaData, Connection connection) throws SQLException {
        String dbProductName = metaData.getDatabaseProductName().toLowerCase();
        int majorVersion = metaData.getDatabaseMajorVersion();
        int minorVersion = metaData.getDatabaseMinorVersion();
        logger.debug("platform for productName[{}] version[{}.{}]", new Object[]{dbProductName, majorVersion, minorVersion});
        if (dbProductName.contains("oracle")) {
            return this.oracleVersion(majorVersion);
        }
        if (dbProductName.contains("microsoft")) {
            throw new IllegalArgumentException("For SqlServer please explicitly choose either sqlserver16 or sqlserver17 as the platform via DatabaseConfig.setDatabasePlatformName. Refer to issue #1340 for more details");
        }
        if (dbProductName.contains("h2")) {
            return new H2Platform();
        }
        if (dbProductName.contains("hsql database engine")) {
            return new HsqldbPlatform();
        }
        if (dbProductName.contains("postgres")) {
            return DatabasePlatformFactory.readPostgres(connection, majorVersion);
        }
        if (dbProductName.contains("mariadb")) {
            return new MariaDbPlatform();
        }
        if (dbProductName.contains("mysql")) {
            return this.mysqlVersion(majorVersion, minorVersion);
        }
        if (dbProductName.contains("nuo")) {
            return new NuoDbPlatform();
        }
        if (dbProductName.contains("sqlite")) {
            return new SQLitePlatform();
        }
        if (dbProductName.contains("db2")) {
            return new DB2Platform();
        }
        if (dbProductName.contains("sql anywhere")) {
            return new SqlAnywherePlatform();
        }
        if (dbProductName.contains("hdb")) {
            return new HanaPlatform();
        }
        if (dbProductName.contains("clickhouse")) {
            return new ClickHousePlatform();
        }
        return new DatabasePlatform();
    }

    private DatabasePlatform oracleVersion(int majorVersion) {
        return majorVersion < 12 ? new Oracle11Platform() : new OraclePlatform();
    }

    private DatabasePlatform mysqlVersion(int majorVersion, int minorVersion) {
        if (majorVersion <= 5 && minorVersion <= 5) {
            return new MySql55Platform();
        }
        return new MySqlPlatform();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DatabasePlatform readPostgres(Connection connection, int majorVersion) {
        try (PreparedStatement statement = connection.prepareStatement("select version() as \"version\"");
             ResultSet resultSet = statement.executeQuery();){
            String productVersion;
            if (resultSet.next() && (productVersion = resultSet.getString("version").toLowerCase()).contains("cockroach")) {
                CockroachPlatform cockroachPlatform = new CockroachPlatform();
                return cockroachPlatform;
            }
        }
        catch (SQLException e) {
            logger.warn("Error running detection query on Postgres", (Throwable)e);
        }
        if (majorVersion > 9) return new PostgresPlatform();
        return new Postgres9Platform();
    }
}

