/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.DB;
import io.ebean.SqlUpdate;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.api.SpiTransaction;
import java.io.Serializable;
import java.util.Collection;

public final class DefaultSqlUpdate
implements Serializable,
SpiSqlUpdate {
    private static final long serialVersionUID = -6493829438421253102L;
    private final transient SpiEbeanServer server;
    private final BindParams bindParams;
    private final String origSql;
    private String baseSql;
    private String generatedSql;
    private String label = "";
    private int timeout;
    private boolean isAutoTableMod = true;
    private int addPos;
    private int bindExpansion;
    private boolean getGeneratedKeys;
    private Object generatedKey;
    private boolean batched;
    private transient SpiTransaction transaction;

    public DefaultSqlUpdate(SpiEbeanServer server, String sql, BindParams bindParams) {
        this.server = server;
        this.origSql = sql;
        this.baseSql = sql;
        this.bindParams = bindParams;
    }

    public DefaultSqlUpdate(SpiEbeanServer server, String sql) {
        this(server, sql, new BindParams());
    }

    public DefaultSqlUpdate(String sql) {
        this(null, sql, new BindParams());
    }

    @Override
    public SpiSqlUpdate copy() {
        return new DefaultSqlUpdate(this.server, this.origSql, new BindParams());
    }

    @Override
    public void reset() {
        this.addPos = 0;
    }

    public Object executeGetKey() {
        this.execute();
        return this.getGeneratedKey();
    }

    public int execute() {
        if (this.server != null) {
            if (this.batched) {
                this.server.executeBatch(this, this.transaction);
                return -1;
            }
            return this.server.execute(this);
        }
        return DB.getDefault().execute((SqlUpdate)this);
    }

    public int executeNow() {
        if (this.server != null) {
            return this.server.executeNow(this);
        }
        throw new IllegalStateException("server is null?");
    }

    public int[] executeBatch() {
        if (this.server == null) {
            throw new IllegalStateException("No EbeanServer set?");
        }
        if (!this.batched) {
            throw new IllegalStateException("No prior addBatch() called?");
        }
        return this.server.executeBatch(this, this.transaction);
    }

    public void addBatch() {
        if (this.server == null) {
            throw new IllegalStateException("No EbeanServer set?");
        }
        if (this.transaction == null) {
            this.transaction = this.server.currentServerTransaction();
            if (this.transaction == null) {
                throw new IllegalStateException("No current transaction? Must have a transaction to use addBatch()");
            }
        }
        this.batched = true;
        this.server.addBatch(this, this.transaction);
    }

    public Object getGeneratedKey() {
        return this.generatedKey;
    }

    @Override
    public void setGeneratedKey(Object idValue) {
        this.generatedKey = idValue;
    }

    public boolean isAutoTableMod() {
        return this.isAutoTableMod;
    }

    public SqlUpdate setAutoTableMod(boolean isAutoTableMod) {
        this.isAutoTableMod = isAutoTableMod;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public SqlUpdate setLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public boolean isGetGeneratedKeys() {
        return this.getGeneratedKeys;
    }

    public SqlUpdate setGetGeneratedKeys(boolean getGeneratedKeys) {
        this.getGeneratedKeys = getGeneratedKeys;
        return this;
    }

    public String getGeneratedSql() {
        return this.generatedSql;
    }

    @Override
    public void setGeneratedSql(String generatedSql) {
        this.generatedSql = generatedSql;
        this.baseSql = this.origSql;
        if (this.bindExpansion > 0) {
            this.bindParams.reset();
            this.bindExpansion = 0;
        }
    }

    public String getSql() {
        return this.origSql;
    }

    @Override
    public String getBaseSql() {
        return this.baseSql;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public SqlUpdate setTimeout(int secs) {
        this.timeout = secs;
        return this;
    }

    public SqlUpdate setParams(Object ... values) {
        return this.setParameters(values);
    }

    public SqlUpdate setNextParameter(Object value) {
        return this.setParameter(value);
    }

    public SqlUpdate setParameters(Object ... values) {
        for (Object value : values) {
            this.setParameter(++this.addPos, value);
        }
        return this;
    }

    public SqlUpdate setParameter(Object value) {
        this.setParameter(++this.addPos, value);
        return this;
    }

    private SqlUpdate setParamWithBindExpansion(int position, Collection<?> values, String bindLiteral) {
        StringBuilder sqlExpand = new StringBuilder(values.size() * 2);
        position += this.bindExpansion;
        int offset = 0;
        for (Object val : values) {
            if (offset > 0) {
                sqlExpand.append(",");
            }
            sqlExpand.append("?");
            this.bindParams.setParameter(position + offset++, val);
        }
        this.bindExpansion += offset - 1;
        this.baseSql = this.baseSql.replace(bindLiteral, sqlExpand.toString());
        return this;
    }

    public SqlUpdate setParameter(int position, Object value) {
        String bindLiteral;
        int pos;
        if (value instanceof Collection && (pos = this.baseSql.indexOf(bindLiteral = "?" + position)) > -1) {
            return this.setParamWithBindExpansion(position, (Collection)value, bindLiteral);
        }
        this.bindParams.setParameter(this.bindExpansion + position, value);
        return this;
    }

    public SqlUpdate setNull(int position, int jdbcType) {
        this.bindParams.setNullParameter(this.bindExpansion + position, jdbcType);
        return this;
    }

    public SqlUpdate setNullParameter(int position, int jdbcType) {
        return this.setNull(position, jdbcType);
    }

    public SqlUpdate setParameter(String name, Object param) {
        this.bindParams.setParameter(name, param);
        return this;
    }

    public SqlUpdate setNull(String name, int jdbcType) {
        this.bindParams.setNullParameter(name, jdbcType);
        return this;
    }

    public SqlUpdate setNullParameter(String name, int jdbcType) {
        return this.setNull(name, jdbcType);
    }

    @Override
    public BindParams getBindParams() {
        return this.bindParams;
    }
}

