/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import com.fasterxml.jackson.core.JsonFactory;
import io.ebean.BackgroundExecutor;
import io.ebean.ExpressionFactory;
import io.ebean.annotation.Platform;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheManager;
import io.ebean.cache.ServerCacheNotify;
import io.ebean.cache.ServerCacheNotifyPlugin;
import io.ebean.cache.ServerCacheOptions;
import io.ebean.cache.ServerCachePlugin;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.ExternalTransactionManager;
import io.ebean.config.ProfilingConfig;
import io.ebean.config.SlowQueryListener;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbHistorySupport;
import io.ebean.event.changelog.ChangeLogListener;
import io.ebean.event.changelog.ChangeLogPrepare;
import io.ebean.event.changelog.ChangeLogRegister;
import io.ebean.event.readaudit.ReadAuditLogger;
import io.ebean.event.readaudit.ReadAuditPrepare;
import io.ebean.plugin.Plugin;
import io.ebean.plugin.SpiServer;
import io.ebeaninternal.api.DbOffline;
import io.ebeaninternal.api.ExtraMetrics;
import io.ebeaninternal.api.QueryPlanManager;
import io.ebeaninternal.api.SpiBackgroundExecutor;
import io.ebeaninternal.api.SpiDdlGenerator;
import io.ebeaninternal.api.SpiDdlGeneratorProvider;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiJsonContext;
import io.ebeaninternal.api.SpiLogManager;
import io.ebeaninternal.api.SpiLogger;
import io.ebeaninternal.api.SpiLoggerFactory;
import io.ebeaninternal.api.SpiProfileHandler;
import io.ebeaninternal.server.autotune.AutoTuneService;
import io.ebeaninternal.server.autotune.AutoTuneServiceProvider;
import io.ebeaninternal.server.autotune.NoAutoTuneService;
import io.ebeaninternal.server.cache.CacheManagerOptions;
import io.ebeaninternal.server.cache.DefaultCacheAdapter;
import io.ebeaninternal.server.cache.DefaultServerCacheManager;
import io.ebeaninternal.server.cache.DefaultServerCachePlugin;
import io.ebeaninternal.server.cache.SpiCacheManager;
import io.ebeaninternal.server.changelog.DefaultChangeLogListener;
import io.ebeaninternal.server.changelog.DefaultChangeLogPrepare;
import io.ebeaninternal.server.changelog.DefaultChangeLogRegister;
import io.ebeaninternal.server.cluster.ClusterManager;
import io.ebeaninternal.server.core.ClockService;
import io.ebeaninternal.server.core.DefaultSlowQueryListener;
import io.ebeaninternal.server.core.InternalConfigXmlMap;
import io.ebeaninternal.server.core.MultiTenantDbCatalogSupplier;
import io.ebeaninternal.server.core.MultiTenantDbSchemaSupplier;
import io.ebeaninternal.server.core.MultiTenantDbSupplier;
import io.ebeaninternal.server.core.OrmQueryEngine;
import io.ebeaninternal.server.core.Persister;
import io.ebeaninternal.server.core.RelationalQueryEngine;
import io.ebeaninternal.server.core.SimpleDataSourceProvider;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.core.timezone.DataTimeZone;
import io.ebeaninternal.server.core.timezone.MySqlDataTimeZone;
import io.ebeaninternal.server.core.timezone.NoDataTimeZone;
import io.ebeaninternal.server.core.timezone.OracleDataTimeZone;
import io.ebeaninternal.server.core.timezone.SimpleDataTimeZone;
import io.ebeaninternal.server.deploy.BeanDescriptorManager;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedPropertyFactory;
import io.ebeaninternal.server.deploy.parse.DeployCreateProperties;
import io.ebeaninternal.server.deploy.parse.DeployInherit;
import io.ebeaninternal.server.deploy.parse.DeployUtil;
import io.ebeaninternal.server.dto.DtoBeanManager;
import io.ebeaninternal.server.expression.DefaultExpressionFactory;
import io.ebeaninternal.server.expression.platform.DbExpressionHandler;
import io.ebeaninternal.server.expression.platform.DbExpressionHandlerFactory;
import io.ebeaninternal.server.logger.DLogManager;
import io.ebeaninternal.server.logger.DLoggerFactory;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.persist.DefaultPersister;
import io.ebeaninternal.server.persist.platform.MultiValueBind;
import io.ebeaninternal.server.persist.platform.PostgresMultiValueBind;
import io.ebeaninternal.server.query.CQueryEngine;
import io.ebeaninternal.server.query.CQueryPlanManager;
import io.ebeaninternal.server.query.DefaultOrmQueryEngine;
import io.ebeaninternal.server.query.DefaultRelationalQueryEngine;
import io.ebeaninternal.server.query.DtoQueryEngine;
import io.ebeaninternal.server.query.QueryPlanLogger;
import io.ebeaninternal.server.query.QueryPlanLoggerExplain;
import io.ebeaninternal.server.query.QueryPlanLoggerOracle;
import io.ebeaninternal.server.query.QueryPlanLoggerPostgres;
import io.ebeaninternal.server.query.QueryPlanLoggerSqlServer;
import io.ebeaninternal.server.readaudit.DefaultReadAuditLogger;
import io.ebeaninternal.server.readaudit.DefaultReadAuditPrepare;
import io.ebeaninternal.server.text.json.DJsonContext;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import io.ebeaninternal.server.transaction.DefaultProfileHandler;
import io.ebeaninternal.server.transaction.DefaultTransactionScopeManager;
import io.ebeaninternal.server.transaction.DocStoreTransactionManager;
import io.ebeaninternal.server.transaction.ExternalTransactionScopeManager;
import io.ebeaninternal.server.transaction.JtaTransactionManager;
import io.ebeaninternal.server.transaction.NoopProfileHandler;
import io.ebeaninternal.server.transaction.TableModState;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeaninternal.server.transaction.TransactionManagerOptions;
import io.ebeaninternal.server.transaction.TransactionScopeManager;
import io.ebeaninternal.server.type.DefaultTypeManager;
import io.ebeaninternal.server.type.TypeManager;
import io.ebeaninternal.xmapping.api.XmapEbean;
import io.ebeaninternal.xmapping.api.XmapService;
import io.ebeanservice.docstore.api.DocStoreFactory;
import io.ebeanservice.docstore.api.DocStoreIntegration;
import io.ebeanservice.docstore.api.DocStoreUpdateProcessor;
import io.ebeanservice.docstore.none.NoneDocStoreFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(InternalConfiguration.class);
    private final TableModState tableModState;
    private final boolean online;
    private final DatabaseConfig config;
    private final BootupClasses bootupClasses;
    private final DatabasePlatform databasePlatform;
    private final DeployInherit deployInherit;
    private final TypeManager typeManager;
    private final DtoBeanManager dtoBeanManager;
    private final ClockService clockService;
    private final DataTimeZone dataTimeZone;
    private final Binder binder;
    private final DeployCreateProperties deployCreateProperties;
    private final DeployUtil deployUtil;
    private final BeanDescriptorManager beanDescriptorManager;
    private final CQueryEngine cQueryEngine;
    private final ClusterManager clusterManager;
    private final SpiCacheManager cacheManager;
    private final ServerCachePlugin serverCachePlugin;
    private final boolean jacksonCorePresent;
    private final ExpressionFactory expressionFactory;
    private final SpiBackgroundExecutor backgroundExecutor;
    private final JsonFactory jsonFactory;
    private final DocStoreFactory docStoreFactory;
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final MultiValueBind multiValueBind;
    private final SpiLogManager logManager;
    private final ExtraMetrics extraMetrics = new ExtraMetrics();
    private ServerCacheNotify cacheNotify;
    private boolean localL2Caching;

    InternalConfiguration(boolean online, ClusterManager clusterManager, SpiBackgroundExecutor backgroundExecutor, DatabaseConfig config, BootupClasses bootupClasses) {
        this.online = online;
        this.config = config;
        this.jacksonCorePresent = config.getClassLoadConfig().isJacksonCorePresent();
        this.clockService = new ClockService(config.getClock());
        this.tableModState = new TableModState();
        this.logManager = this.initLogManager();
        this.docStoreFactory = this.initDocStoreFactory((DocStoreFactory)config.service(DocStoreFactory.class));
        this.jsonFactory = config.getJsonFactory();
        this.clusterManager = clusterManager;
        this.backgroundExecutor = backgroundExecutor;
        this.bootupClasses = bootupClasses;
        this.databasePlatform = config.getDatabasePlatform();
        this.expressionFactory = this.initExpressionFactory(config);
        this.typeManager = new DefaultTypeManager(config, bootupClasses);
        this.multiValueBind = this.createMultiValueBind(this.databasePlatform.getPlatform());
        this.deployInherit = new DeployInherit(bootupClasses);
        this.deployCreateProperties = new DeployCreateProperties(this.typeManager);
        this.deployUtil = new DeployUtil(this.typeManager, config);
        this.serverCachePlugin = this.initServerCachePlugin();
        this.cacheManager = this.initCacheManager();
        InternalConfigXmlMap xmlMap = this.initExternalMapping();
        this.dtoBeanManager = new DtoBeanManager(this.typeManager, xmlMap.readDtoMapping());
        this.beanDescriptorManager = new BeanDescriptorManager(this);
        Map<String, String> asOfTableMapping = this.beanDescriptorManager.deploy(xmlMap.xmlDeployment());
        Map<String, String> draftTableMap = this.beanDescriptorManager.draftTableMap();
        this.beanDescriptorManager.scheduleBackgroundTrim();
        this.dataTimeZone = this.initDataTimeZone();
        this.binder = this.getBinder(this.typeManager, this.databasePlatform, this.dataTimeZone);
        this.cQueryEngine = new CQueryEngine(config, this.databasePlatform, this.binder, asOfTableMapping, draftTableMap);
    }

    public boolean isJacksonCorePresent() {
        return this.jacksonCorePresent;
    }

    private InternalConfigXmlMap initExternalMapping() {
        List<XmapEbean> xmEbeans = this.readExternalMapping();
        return new InternalConfigXmlMap(xmEbeans, this.config.getClassLoadConfig().getClassLoader());
    }

    private List<XmapEbean> readExternalMapping() {
        XmapService xmapService = (XmapService)this.config.service(XmapService.class);
        if (xmapService == null) {
            return Collections.emptyList();
        }
        return xmapService.read(this.config.getClassLoadConfig().getClassLoader(), this.config.getMappingLocations());
    }

    private SpiLogManager initLogManager() {
        SpiLoggerFactory loggerFactory = (SpiLoggerFactory)this.config.service(SpiLoggerFactory.class);
        if (loggerFactory == null) {
            loggerFactory = new DLoggerFactory();
        }
        SpiLogger sql = loggerFactory.create("io.ebean.SQL");
        SpiLogger sum = loggerFactory.create("io.ebean.SUM");
        SpiLogger txn = loggerFactory.create("io.ebean.TXN");
        return new DLogManager(sql, sum, txn);
    }

    private ExpressionFactory initExpressionFactory(DatabaseConfig config) {
        boolean nativeIlike = config.isExpressionNativeIlike() && this.databasePlatform.isSupportsNativeIlike();
        return new DefaultExpressionFactory(config.isExpressionEqualsWithNullAsNoop(), nativeIlike);
    }

    private DocStoreFactory initDocStoreFactory(DocStoreFactory service) {
        return service == null ? new NoneDocStoreFactory() : service;
    }

    public DocStoreFactory getDocStoreFactory() {
        return this.docStoreFactory;
    }

    ClockService getClockService() {
        return this.clockService;
    }

    public ExtraMetrics getExtraMetrics() {
        return this.extraMetrics;
    }

    public <T> T plugin(T maybePlugin) {
        if (maybePlugin instanceof Plugin) {
            this.plugins.add((Plugin)maybePlugin);
        }
        return maybePlugin;
    }

    public List<Plugin> getPlugins() {
        for (Plugin plugin : ServiceLoader.load(Plugin.class)) {
            if (this.plugins.contains(plugin)) continue;
            this.plugins.add(plugin);
        }
        return this.plugins;
    }

    public ChangeLogPrepare changeLogPrepare(ChangeLogPrepare prepare) {
        return this.plugin(prepare != null ? prepare : new DefaultChangeLogPrepare());
    }

    public ChangeLogRegister changeLogRegister(ChangeLogRegister register) {
        boolean includeInserts = this.config.isChangeLogIncludeInserts();
        return this.plugin(register != null ? register : new DefaultChangeLogRegister(includeInserts));
    }

    public ChangeLogListener changeLogListener(ChangeLogListener listener) {
        return this.plugin(listener != null ? listener : (this.jacksonCorePresent ? new DefaultChangeLogListener() : null));
    }

    ReadAuditLogger getReadAuditLogger() {
        ReadAuditLogger found = this.bootupClasses.getReadAuditLogger();
        return this.plugin(found != null ? found : (this.jacksonCorePresent ? new DefaultReadAuditLogger() : null));
    }

    ReadAuditPrepare getReadAuditPrepare() {
        ReadAuditPrepare found = this.bootupClasses.getReadAuditPrepare();
        return this.plugin(found != null ? found : new DefaultReadAuditPrepare());
    }

    private Binder getBinder(TypeManager typeManager, DatabasePlatform databasePlatform, DataTimeZone dataTimeZone) {
        DbExpressionHandler jsonHandler = this.getDbExpressionHandler(databasePlatform);
        DbHistorySupport historySupport = databasePlatform.getHistorySupport();
        if (historySupport == null) {
            return new Binder(typeManager, this.logManager, 0, false, jsonHandler, dataTimeZone, this.multiValueBind);
        }
        return new Binder(typeManager, this.logManager, historySupport.getBindCount(), historySupport.isStandardsBased(), jsonHandler, dataTimeZone, this.multiValueBind);
    }

    private DbExpressionHandler getDbExpressionHandler(DatabasePlatform databasePlatform) {
        return DbExpressionHandlerFactory.from(databasePlatform);
    }

    private MultiValueBind createMultiValueBind(Platform platform) {
        if (platform.base() == Platform.POSTGRES) {
            return new PostgresMultiValueBind();
        }
        return new MultiValueBind();
    }

    SpiJsonContext createJsonContext(SpiEbeanServer server) {
        return this.jacksonCorePresent ? new DJsonContext(server, this.jsonFactory, this.typeManager) : null;
    }

    AutoTuneService createAutoTuneService(SpiEbeanServer server) {
        AutoTuneServiceProvider provider = (AutoTuneServiceProvider)this.config.service(AutoTuneServiceProvider.class);
        return provider == null ? new NoAutoTuneService() : provider.create(server, this.config);
    }

    DtoQueryEngine createDtoQueryEngine() {
        return new DtoQueryEngine(this.binder);
    }

    RelationalQueryEngine createRelationalQueryEngine() {
        return new DefaultRelationalQueryEngine(this.binder, this.config.getDatabaseBooleanTrue(), this.config.getPlatformConfig().getDbUuid().useBinaryOptimized());
    }

    OrmQueryEngine createOrmQueryEngine() {
        return new DefaultOrmQueryEngine(this.cQueryEngine, this.binder);
    }

    Persister createPersister(SpiEbeanServer server) {
        return new DefaultPersister(server, this.binder, this.beanDescriptorManager);
    }

    public SpiCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public BootupClasses getBootupClasses() {
        return this.bootupClasses;
    }

    private Platform getPlatform() {
        return this.getDatabasePlatform().getPlatform();
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.config.getDatabasePlatform();
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public Binder getBinder() {
        return this.binder;
    }

    BeanDescriptorManager getBeanDescriptorManager() {
        return this.beanDescriptorManager;
    }

    public DeployInherit getDeployInherit() {
        return this.deployInherit;
    }

    public DeployCreateProperties getDeployCreateProperties() {
        return this.deployCreateProperties;
    }

    public DeployUtil getDeployUtil() {
        return this.deployUtil;
    }

    CQueryEngine getCQueryEngine() {
        return this.cQueryEngine;
    }

    public SpiBackgroundExecutor getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    public GeneratedPropertyFactory getGeneratedPropertyFactory() {
        boolean offlineMode = this.config.isDbOffline() || DbOffline.isSet();
        return new GeneratedPropertyFactory(offlineMode, this.config, this.bootupClasses.getIdGenerators());
    }

    DocStoreIntegration createDocStoreIntegration(SpiServer server) {
        return this.plugin(this.docStoreFactory.create(server));
    }

    TransactionManager createTransactionManager(SpiServer server, DocStoreUpdateProcessor indexUpdateProcessor) {
        TransactionScopeManager scopeManager = this.createTransactionScopeManager();
        boolean notifyL2CacheInForeground = this.cacheManager.isLocalL2Caching() || this.config.isNotifyL2CacheInForeground();
        TransactionManagerOptions options = new TransactionManagerOptions(server, notifyL2CacheInForeground, this.config, scopeManager, this.clusterManager, this.backgroundExecutor, indexUpdateProcessor, this.beanDescriptorManager, this.dataSource(), this.profileHandler(), this.logManager, this.tableModState, this.cacheNotify, this.clockService);
        if (this.config.isDocStoreOnly()) {
            return new DocStoreTransactionManager(options);
        }
        return new TransactionManager(options);
    }

    private SpiProfileHandler profileHandler() {
        ProfilingConfig profilingConfig = this.config.getProfilingConfig();
        if (!profilingConfig.isEnabled()) {
            return new NoopProfileHandler();
        }
        SpiProfileHandler handler = (SpiProfileHandler)this.config.service(SpiProfileHandler.class);
        if (handler == null) {
            handler = new DefaultProfileHandler(profilingConfig);
        }
        return this.plugin(handler);
    }

    private DataSourceSupplier dataSource() {
        switch (this.config.getTenantMode()) {
            case DB: 
            case DB_WITH_MASTER: {
                return new MultiTenantDbSupplier(this.config.getCurrentTenantProvider(), this.config.getTenantDataSourceProvider());
            }
            case SCHEMA: {
                return new MultiTenantDbSchemaSupplier(this.config.getCurrentTenantProvider(), this.config.getDataSource(), this.config.getReadOnlyDataSource(), this.config.getTenantSchemaProvider());
            }
            case CATALOG: {
                return new MultiTenantDbCatalogSupplier(this.config.getCurrentTenantProvider(), this.config.getDataSource(), this.config.getReadOnlyDataSource(), this.config.getTenantCatalogProvider());
            }
        }
        return new SimpleDataSourceProvider(this.config.getDataSource(), this.config.getReadOnlyDataSource());
    }

    private TransactionScopeManager createTransactionScopeManager() {
        ExternalTransactionManager externalTransactionManager = this.config.getExternalTransactionManager();
        if (externalTransactionManager == null && this.config.isUseJtaTransactionManager()) {
            externalTransactionManager = new JtaTransactionManager();
        }
        if (externalTransactionManager != null) {
            logger.info("Using Transaction Manager [" + externalTransactionManager.getClass() + "]");
            return new ExternalTransactionScopeManager(externalTransactionManager);
        }
        return new DefaultTransactionScopeManager();
    }

    private DataTimeZone initDataTimeZone() {
        String tz = this.config.getDataTimeZone();
        if (tz == null) {
            if (this.isMySql(this.getPlatform())) {
                return new MySqlDataTimeZone();
            }
            return new NoDataTimeZone();
        }
        if (this.getPlatform().base() == Platform.ORACLE) {
            return new OracleDataTimeZone(tz);
        }
        return new SimpleDataTimeZone(tz);
    }

    private boolean isMySql(Platform platform) {
        return platform.base() == Platform.MYSQL;
    }

    public DataTimeZone getDataTimeZone() {
        return this.dataTimeZone;
    }

    public ServerCacheManager cacheManager() {
        return new DefaultCacheAdapter(this.cacheManager);
    }

    long getSlowQueryMicros() {
        long millis = this.config.getSlowQueryMillis();
        return millis < 1L ? Long.MAX_VALUE : millis * 1000L;
    }

    SlowQueryListener getSlowQueryListener() {
        long millis = this.config.getSlowQueryMillis();
        if (millis < 1L) {
            return null;
        }
        SlowQueryListener listener = this.config.getSlowQueryListener();
        if (listener == null && (listener = (SlowQueryListener)this.config.service(SlowQueryListener.class)) == null) {
            listener = new DefaultSlowQueryListener();
        }
        return listener;
    }

    public MultiValueBind getMultiValueBind() {
        return this.multiValueBind;
    }

    DtoBeanManager getDtoBeanManager() {
        return this.dtoBeanManager;
    }

    SpiLogManager getLogManager() {
        return this.logManager;
    }

    private ServerCachePlugin initServerCachePlugin() {
        if (this.config.isLocalOnlyL2Cache()) {
            this.localL2Caching = true;
            return new DefaultServerCachePlugin();
        }
        ServerCachePlugin plugin = this.config.getServerCachePlugin();
        if (plugin == null) {
            ServiceLoader<ServerCachePlugin> cacheFactories = ServiceLoader.load(ServerCachePlugin.class);
            Iterator<ServerCachePlugin> iterator = cacheFactories.iterator();
            if (iterator.hasNext()) {
                plugin = iterator.next();
                logger.debug("using ServerCacheFactory {}", plugin.getClass());
            } else {
                this.localL2Caching = true;
                plugin = new DefaultServerCachePlugin();
            }
        }
        return plugin;
    }

    private SpiCacheManager initCacheManager() {
        if (!this.online || this.config.isDisableL2Cache()) {
            return new DefaultServerCacheManager();
        }
        ServerCacheFactory factory = this.serverCachePlugin.create(this.config, (BackgroundExecutor)this.backgroundExecutor);
        ServerCacheNotifyPlugin notifyPlugin = (ServerCacheNotifyPlugin)this.config.service(ServerCacheNotifyPlugin.class);
        this.cacheNotify = notifyPlugin != null ? notifyPlugin.create(this.config) : factory.createCacheNotify((ServerCacheNotify)this.tableModState);
        ServerCacheOptions beanOptions = new ServerCacheOptions();
        beanOptions.setMaxSize(this.config.getCacheMaxSize());
        beanOptions.setMaxIdleSecs(this.config.getCacheMaxIdleTime());
        beanOptions.setMaxSecsToLive(this.config.getCacheMaxTimeToLive());
        ServerCacheOptions queryOptions = new ServerCacheOptions();
        queryOptions.setMaxSize(this.config.getQueryCacheMaxSize());
        queryOptions.setMaxIdleSecs(this.config.getQueryCacheMaxIdleTime());
        queryOptions.setMaxSecsToLive(this.config.getQueryCacheMaxTimeToLive());
        CacheManagerOptions builder = new CacheManagerOptions(this.clusterManager, this.config, this.localL2Caching).with(beanOptions, queryOptions).with(factory, this.tableModState);
        return new DefaultServerCacheManager(builder);
    }

    public QueryPlanManager initQueryPlanManager(TransactionManager transactionManager) {
        if (!this.config.isQueryPlanEnable()) {
            return QueryPlanManager.NOOP;
        }
        long threshold = this.config.getQueryPlanThresholdMicros();
        return new CQueryPlanManager(transactionManager, threshold, this.queryPlanLogger(this.databasePlatform.getPlatform()), this.extraMetrics);
    }

    QueryPlanLogger queryPlanLogger(Platform platform) {
        switch (platform.base()) {
            case POSTGRES: {
                return new QueryPlanLoggerPostgres();
            }
            case SQLSERVER: {
                return new QueryPlanLoggerSqlServer();
            }
            case ORACLE: {
                return new QueryPlanLoggerOracle();
            }
        }
        return new QueryPlanLoggerExplain();
    }

    public SpiDdlGenerator initDdlGenerator(SpiEbeanServer server) {
        SpiDdlGeneratorProvider service = (SpiDdlGeneratorProvider)this.config.service(SpiDdlGeneratorProvider.class);
        return service == null ? new NoopDdl() : service.generator(server);
    }

    private static class NoopDdl
    implements SpiDdlGenerator {
        private NoopDdl() {
        }

        @Override
        public void execute(boolean online) {
        }
    }
}

