/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core.bootup;

import io.ebean.annotation.DocStore;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.IdGenerator;
import io.ebean.config.ScalarTypeConverter;
import io.ebean.core.type.ScalarType;
import io.ebean.event.BeanFindController;
import io.ebean.event.BeanPersistController;
import io.ebean.event.BeanPersistListener;
import io.ebean.event.BeanPostConstructListener;
import io.ebean.event.BeanPostLoad;
import io.ebean.event.BeanQueryAdapter;
import io.ebean.event.ServerConfigStartup;
import io.ebean.event.changelog.ChangeLogListener;
import io.ebean.event.changelog.ChangeLogPrepare;
import io.ebean.event.changelog.ChangeLogRegister;
import io.ebean.event.readaudit.ReadAuditLogger;
import io.ebean.event.readaudit.ReadAuditPrepare;
import io.ebean.util.AnnotationUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.persistence.AttributeConverter;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootupClasses
implements Predicate<Class<?>> {
    private static final Logger logger = LoggerFactory.getLogger(BootupClasses.class);
    private final List<Class<?>> embeddableList = new ArrayList();
    private final List<Class<?>> entityList = new ArrayList();
    private final List<Class<? extends ScalarType<?>>> scalarTypeList = new ArrayList();
    private final List<Class<? extends ScalarTypeConverter<?, ?>>> scalarConverterList = new ArrayList();
    private final List<Class<? extends AttributeConverter<?, ?>>> attributeConverterList = new ArrayList();
    private final List<Class<? extends IdGenerator>> idGeneratorCandidates = new ArrayList<Class<? extends IdGenerator>>();
    private final List<Class<? extends BeanPersistController>> beanPersistControllerCandidates = new ArrayList<Class<? extends BeanPersistController>>();
    private final List<Class<? extends BeanPostLoad>> beanPostLoadCandidates = new ArrayList<Class<? extends BeanPostLoad>>();
    private final List<Class<? extends BeanPostConstructListener>> beanPostConstructListenerCandidates = new ArrayList<Class<? extends BeanPostConstructListener>>();
    private final List<Class<? extends BeanFindController>> beanFindControllerCandidates = new ArrayList<Class<? extends BeanFindController>>();
    private final List<Class<? extends BeanPersistListener>> beanPersistListenerCandidates = new ArrayList<Class<? extends BeanPersistListener>>();
    private final List<Class<? extends BeanQueryAdapter>> beanQueryAdapterCandidates = new ArrayList<Class<? extends BeanQueryAdapter>>();
    private final List<Class<? extends ServerConfigStartup>> serverConfigStartupCandidates = new ArrayList<Class<? extends ServerConfigStartup>>();
    private final List<IdGenerator> idGeneratorInstances = new ArrayList<IdGenerator>();
    private final List<BeanPersistController> beanPersistControllerInstances = new ArrayList<BeanPersistController>();
    private final List<BeanPostLoad> beanPostLoadInstances = new ArrayList<BeanPostLoad>();
    private final List<BeanPostConstructListener> beanPostConstructListenerInstances = new ArrayList<BeanPostConstructListener>();
    private final List<BeanFindController> beanFindControllerInstances = new ArrayList<BeanFindController>();
    private final List<BeanPersistListener> beanPersistListenerInstances = new ArrayList<BeanPersistListener>();
    private final List<BeanQueryAdapter> beanQueryAdapterInstances = new ArrayList<BeanQueryAdapter>();
    private final List<ServerConfigStartup> serverConfigStartupInstances = new ArrayList<ServerConfigStartup>();
    private Class<? extends ChangeLogPrepare> changeLogPrepareClass;
    private Class<? extends ChangeLogListener> changeLogListenerClass;
    private Class<? extends ChangeLogRegister> changeLogRegisterClass;
    private Class<? extends ReadAuditPrepare> readAuditPrepareClass;
    private Class<? extends ReadAuditLogger> readAuditLoggerClass;
    private ChangeLogPrepare changeLogPrepare;
    private ChangeLogListener changeLogListener;
    private ChangeLogRegister changeLogRegister;
    private ReadAuditPrepare readAuditPrepare;
    private ReadAuditLogger readAuditLogger;

    public BootupClasses() {
    }

    public BootupClasses(List<Class<?>> list) {
        if (list != null) {
            for (Class<?> cls : list) {
                this.test(cls);
            }
        }
    }

    public void runServerConfigStartup(DatabaseConfig config) {
        for (Class<? extends ServerConfigStartup> cls : this.serverConfigStartupCandidates) {
            try {
                ServerConfigStartup newInstance = cls.newInstance();
                newInstance.onStart(config);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error running ServerConfigStartup " + cls, e);
            }
        }
        for (ServerConfigStartup startup : this.serverConfigStartupInstances) {
            try {
                startup.onStart(config);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error running ServerConfigStartup " + startup.getClass(), e);
            }
        }
    }

    private <T> void add(List<T> toAdd, List<T> instances, List<Class<? extends T>> candidates) {
        if (toAdd != null) {
            for (T obj : toAdd) {
                instances.add(obj);
                candidates.remove(obj.getClass());
            }
        }
    }

    public void addIdGenerators(List<IdGenerator> idGenerators) {
        this.add(idGenerators, this.idGeneratorInstances, this.idGeneratorCandidates);
    }

    public void addPersistControllers(List<BeanPersistController> beanControllers) {
        this.add(beanControllers, this.beanPersistControllerInstances, this.beanPersistControllerCandidates);
    }

    public void addPostLoaders(List<BeanPostLoad> postLoaders) {
        this.add(postLoaders, this.beanPostLoadInstances, this.beanPostLoadCandidates);
    }

    public void addPostConstructListeners(List<BeanPostConstructListener> postConstructListener) {
        this.add(postConstructListener, this.beanPostConstructListenerInstances, this.beanPostConstructListenerCandidates);
    }

    public void addFindControllers(List<BeanFindController> findControllers) {
        this.add(findControllers, this.beanFindControllerInstances, this.beanFindControllerCandidates);
    }

    public void addPersistListeners(List<BeanPersistListener> listenerInstances) {
        this.add(listenerInstances, this.beanPersistListenerInstances, this.beanPersistListenerCandidates);
    }

    public void addQueryAdapters(List<BeanQueryAdapter> queryAdapters) {
        this.add(queryAdapters, this.beanQueryAdapterInstances, this.beanQueryAdapterCandidates);
    }

    public void addServerConfigStartup(List<ServerConfigStartup> startupInstances) {
        this.add(startupInstances, this.serverConfigStartupInstances, this.serverConfigStartupCandidates);
    }

    public void addChangeLogInstances(DatabaseConfig config) {
        this.readAuditPrepare = config.getReadAuditPrepare();
        this.readAuditLogger = config.getReadAuditLogger();
        this.changeLogPrepare = config.getChangeLogPrepare();
        this.changeLogListener = config.getChangeLogListener();
        this.changeLogRegister = config.getChangeLogRegister();
        if (this.readAuditPrepare == null && this.readAuditPrepareClass != null) {
            this.readAuditPrepare = this.create(this.readAuditPrepareClass, false);
        }
        if (this.readAuditLogger == null && this.readAuditLoggerClass != null) {
            this.readAuditLogger = this.create(this.readAuditLoggerClass, false);
        }
        if (this.changeLogPrepare == null && this.changeLogPrepareClass != null) {
            this.changeLogPrepare = this.create(this.changeLogPrepareClass, false);
        }
        if (this.changeLogListener == null && this.changeLogListenerClass != null) {
            this.changeLogListener = this.create(this.changeLogListenerClass, false);
        }
        if (this.changeLogRegister == null && this.changeLogRegisterClass != null) {
            this.changeLogRegister = this.create(this.changeLogRegisterClass, false);
        }
    }

    private <T> T create(Class<T> cls, boolean logOnException) {
        try {
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.debug("Ignore/expected - no default constructor: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            if (logOnException) {
                logger.error("Error creating " + cls, (Throwable)e);
                return null;
            }
            throw new IllegalStateException("Error creating " + cls, e);
        }
    }

    private <T> List<T> createAdd(List<T> instances, List<Class<? extends T>> candidates) {
        for (Class<T> clazz : candidates) {
            T newInstance = this.create(clazz, true);
            if (newInstance == null) continue;
            instances.add(newInstance);
        }
        candidates.clear();
        return instances;
    }

    public ChangeLogPrepare getChangeLogPrepare() {
        return this.changeLogPrepare;
    }

    public ChangeLogListener getChangeLogListener() {
        return this.changeLogListener;
    }

    public ChangeLogRegister getChangeLogRegister() {
        return this.changeLogRegister;
    }

    public ReadAuditPrepare getReadAuditPrepare() {
        return this.readAuditPrepare;
    }

    public ReadAuditLogger getReadAuditLogger() {
        return this.readAuditLogger;
    }

    public List<IdGenerator> getIdGenerators() {
        return this.createAdd(this.idGeneratorInstances, this.idGeneratorCandidates);
    }

    public List<BeanPersistController> getBeanPersistControllers() {
        return this.createAdd(this.beanPersistControllerInstances, this.beanPersistControllerCandidates);
    }

    public List<BeanPostLoad> getBeanPostLoaders() {
        return this.createAdd(this.beanPostLoadInstances, this.beanPostLoadCandidates);
    }

    public List<BeanPostConstructListener> getBeanPostConstructoListeners() {
        return this.createAdd(this.beanPostConstructListenerInstances, this.beanPostConstructListenerCandidates);
    }

    public List<BeanFindController> getBeanFindControllers() {
        return this.createAdd(this.beanFindControllerInstances, this.beanFindControllerCandidates);
    }

    public List<BeanPersistListener> getBeanPersistListeners() {
        return this.createAdd(this.beanPersistListenerInstances, this.beanPersistListenerCandidates);
    }

    public List<BeanQueryAdapter> getBeanQueryAdapters() {
        return this.createAdd(this.beanQueryAdapterInstances, this.beanQueryAdapterCandidates);
    }

    public List<Class<?>> getEmbeddables() {
        return this.embeddableList;
    }

    public List<Class<?>> getEntities() {
        return this.entityList;
    }

    public List<Class<? extends ScalarType<?>>> getScalarTypes() {
        return this.scalarTypeList;
    }

    public List<Class<? extends ScalarTypeConverter<?, ?>>> getScalarConverters() {
        return this.scalarConverterList;
    }

    public List<Class<? extends AttributeConverter<?, ?>>> getAttributeConverters() {
        return this.attributeConverterList;
    }

    @Override
    public boolean test(Class<?> cls) {
        if (this.isEmbeddable(cls)) {
            this.embeddableList.add(cls);
        } else if (this.isEntity(cls)) {
            this.entityList.add(cls);
        } else {
            return this.isInterestingInterface(cls);
        }
        return true;
    }

    private boolean isInterestingInterface(Class<?> cls) {
        if (Modifier.isAbstract(cls.getModifiers())) {
            return false;
        }
        boolean interesting = false;
        if (ScalarType.class.isAssignableFrom(cls)) {
            this.scalarTypeList.add(cls);
            interesting = true;
        }
        if (ScalarTypeConverter.class.isAssignableFrom(cls)) {
            this.scalarConverterList.add(cls);
            interesting = true;
        }
        if (AttributeConverter.class.isAssignableFrom(cls)) {
            this.attributeConverterList.add(cls);
            interesting = true;
        }
        if (IdGenerator.class.isAssignableFrom(cls)) {
            this.idGeneratorCandidates.add(cls);
            interesting = true;
        }
        if (BeanPersistController.class.isAssignableFrom(cls)) {
            this.beanPersistControllerCandidates.add(cls);
            interesting = true;
        }
        if (BeanPostLoad.class.isAssignableFrom(cls)) {
            this.beanPostLoadCandidates.add(cls);
            interesting = true;
        }
        if (BeanPostConstructListener.class.isAssignableFrom(cls)) {
            this.beanPostConstructListenerCandidates.add(cls);
            interesting = true;
        }
        if (BeanFindController.class.isAssignableFrom(cls)) {
            this.beanFindControllerCandidates.add(cls);
            interesting = true;
        }
        if (BeanPersistListener.class.isAssignableFrom(cls)) {
            this.beanPersistListenerCandidates.add(cls);
            interesting = true;
        }
        if (BeanQueryAdapter.class.isAssignableFrom(cls)) {
            this.beanQueryAdapterCandidates.add(cls);
            interesting = true;
        }
        if (ServerConfigStartup.class.isAssignableFrom(cls)) {
            this.serverConfigStartupCandidates.add(cls);
            interesting = true;
        }
        if (ChangeLogListener.class.isAssignableFrom(cls)) {
            this.changeLogListenerClass = cls;
            interesting = true;
        }
        if (ChangeLogRegister.class.isAssignableFrom(cls)) {
            this.changeLogRegisterClass = cls;
            interesting = true;
        }
        if (ChangeLogPrepare.class.isAssignableFrom(cls)) {
            this.changeLogPrepareClass = cls;
            interesting = true;
        }
        if (ReadAuditPrepare.class.isAssignableFrom(cls)) {
            this.readAuditPrepareClass = cls;
            interesting = true;
        }
        if (ReadAuditLogger.class.isAssignableFrom(cls)) {
            this.readAuditLoggerClass = cls;
            interesting = true;
        }
        return interesting;
    }

    private boolean isEntity(Class<?> cls) {
        return this.has(cls, Entity.class) || this.has(cls, Table.class) || this.has(cls, DocStore.class);
    }

    private boolean isEmbeddable(Class<?> cls) {
        return this.has(cls, Embeddable.class);
    }

    private boolean has(Class<?> cls, Class<? extends Annotation> ann) {
        return AnnotationUtil.has(cls, ann);
    }
}

