/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.generatedproperty;

import io.ebean.config.ClassLoadConfig;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedInsertDate;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedInsertJavaTime;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedInsertJodaTime;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedInsertLong;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedInsertTimestamp;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;

final class InsertTimestampFactory {
    private final Map<Class<?>, GeneratedProperty> map = new HashMap();

    InsertTimestampFactory(ClassLoadConfig classLoadConfig) {
        this.map.put(Timestamp.class, new GeneratedInsertTimestamp());
        this.map.put(Date.class, new GeneratedInsertDate());
        GeneratedInsertLong longTime = new GeneratedInsertLong();
        this.map.put(Long.class, longTime);
        this.map.put(Long.TYPE, longTime);
        this.map.put(Instant.class, new GeneratedInsertJavaTime.InstantDT());
        this.map.put(java.time.LocalDateTime.class, new GeneratedInsertJavaTime.LocalDT());
        this.map.put(OffsetDateTime.class, new GeneratedInsertJavaTime.OffsetDT());
        this.map.put(ZonedDateTime.class, new GeneratedInsertJavaTime.ZonedDT());
        if (classLoadConfig.isJodaTimePresent()) {
            this.map.put(LocalDateTime.class, new GeneratedInsertJodaTime.LocalDT());
            this.map.put(DateTime.class, new GeneratedInsertJodaTime.DateTimeDT());
        }
    }

    void setInsertTimestamp(DeployBeanProperty property) {
        property.setGeneratedProperty(this.createInsertTimestamp(property));
    }

    GeneratedProperty createInsertTimestamp(DeployBeanProperty property) {
        Class<?> propType = property.getPropertyType();
        GeneratedProperty generatedProperty = this.map.get(propType);
        if (generatedProperty != null) {
            return generatedProperty;
        }
        throw new PersistenceException("Generated Insert Timestamp not supported on " + propType.getName());
    }
}

