/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.id;

import io.ebean.bean.EntityBean;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.core.DefaultSqlUpdate;
import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.persist.MultiValueWrapper;
import io.ebeaninternal.server.persist.platform.MultiValueBind;
import io.ebeaninternal.server.type.DataBind;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class IdBinderSimple
implements IdBinder {
    private final BeanProperty idProperty;
    private final String bindIdSql;
    private final Class<?> expectedType;
    private final MultiValueBind multiValueBind;
    private final ScalarType scalarType;

    public IdBinderSimple(BeanProperty idProperty, MultiValueBind multiValueBind) {
        this.idProperty = idProperty;
        this.scalarType = idProperty.scalarType();
        this.expectedType = idProperty.type();
        this.bindIdSql = InternString.intern(idProperty.dbColumn() + " = ? ");
        this.multiValueBind = multiValueBind;
    }

    @Override
    public void initialise() {
    }

    @Override
    public boolean isIdInExpandedForm() {
        return false;
    }

    @Override
    public String getOrderBy(String pathPrefix, boolean ascending) {
        StringBuilder sb = new StringBuilder();
        if (pathPrefix != null) {
            sb.append(pathPrefix).append(".");
        }
        sb.append(this.idProperty.name());
        if (!ascending) {
            sb.append(" desc");
        }
        return sb.toString();
    }

    @Override
    public void buildRawSqlSelectChain(String prefix, List<String> selectChain) {
        this.idProperty.buildRawSqlSelectChain(prefix, selectChain);
    }

    @Override
    public BeanProperty getBeanProperty() {
        return this.idProperty;
    }

    @Override
    public String getIdProperty() {
        return this.idProperty.name();
    }

    @Override
    public BeanProperty findBeanProperty(String dbColumnName) {
        if (dbColumnName.equalsIgnoreCase(this.idProperty.dbColumn())) {
            return this.idProperty;
        }
        return null;
    }

    @Override
    public boolean isComplexId() {
        return false;
    }

    @Override
    public String getDefaultOrderBy() {
        return this.idProperty.name();
    }

    @Override
    public String getBindIdInSql(String baseTableAlias) {
        if (baseTableAlias == null) {
            return this.idProperty.dbColumn();
        }
        return baseTableAlias + "." + this.idProperty.dbColumn();
    }

    @Override
    public String getBindIdSql(String baseTableAlias) {
        if (baseTableAlias == null) {
            return this.bindIdSql;
        }
        return baseTableAlias + "." + this.bindIdSql;
    }

    @Override
    public Object[] getIdValues(EntityBean bean) {
        return new Object[]{this.idProperty.getValue(bean)};
    }

    @Override
    public Object[] getBindValues(Object idValue) {
        return new Object[]{idValue};
    }

    @Override
    public String getIdInValueExprDelete(int size) {
        return this.getIdInValueExpr(false, size);
    }

    @Override
    public String getIdInValueExpr(boolean not, int size) {
        if (size <= 0) {
            throw new IndexOutOfBoundsException("The size must be at least 1");
        }
        return this.multiValueBind.getInExpression(not, this.scalarType, size);
    }

    @Override
    public void addIdInBindValues(DefaultSqlUpdate sqlUpdate, Collection<?> ids) {
        sqlUpdate.setParameter(new MultiValueWrapper(ids));
    }

    @Override
    public void addIdInBindValues(SpiExpressionRequest request, Collection<?> values) {
        ArrayList copy = new ArrayList(values);
        for (int i = 0; i < copy.size(); ++i) {
            copy.set(i, this.convertSetId(copy.get(i), null));
        }
        request.addBindValue(new MultiValueWrapper(copy));
    }

    @Override
    public Object getIdForJson(EntityBean bean) {
        return this.idProperty.getValue(bean);
    }

    @Override
    public Object convertIdFromJson(Object value) {
        return this.convertId(value);
    }

    @Override
    public void bindId(DefaultSqlUpdate sqlUpdate, Object value) {
        sqlUpdate.setParameter(value);
    }

    @Override
    public void bindId(DataBind dataBind, Object value) throws SQLException {
        if (!value.getClass().equals(this.expectedType)) {
            value = this.scalarType.toBeanType(value);
        }
        this.idProperty.bind(dataBind, value);
    }

    @Override
    public void writeData(DataOutput os, Object value) throws IOException {
        this.idProperty.writeData(os, value);
    }

    @Override
    public Object readData(DataInput is) throws IOException {
        return this.idProperty.readData(is);
    }

    @Override
    public void loadIgnore(DbReadContext ctx) {
        this.idProperty.loadIgnore(ctx);
    }

    @Override
    public Object readSet(DbReadContext ctx, EntityBean bean) throws SQLException {
        Object id = this.idProperty.read(ctx);
        if (id != null) {
            this.idProperty.setValue(bean, id);
        }
        return id;
    }

    @Override
    public Object read(DbReadContext ctx) throws SQLException {
        return this.idProperty.read(ctx);
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
        this.idProperty.appendSelect(ctx, subQuery);
    }

    @Override
    public String getAssocOneIdExpr(String prefix, String operator) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
            sb.append(".");
        }
        sb.append(this.idProperty.name());
        sb.append(operator);
        return sb.toString();
    }

    @Override
    public String getAssocIdInExpr(String prefix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
            sb.append(".");
        }
        sb.append(this.idProperty.name());
        return sb.toString();
    }

    @Override
    public Object convertId(Object idValue) {
        if (!idValue.getClass().equals(this.expectedType)) {
            return this.scalarType.toBeanType(idValue);
        }
        return idValue;
    }

    @Override
    public Object convertSetId(Object idValue, EntityBean bean) {
        if (!idValue.getClass().equals(this.expectedType)) {
            idValue = this.scalarType.toBeanType(idValue);
        }
        if (bean != null) {
            this.idProperty.setValueIntercept(bean, idValue);
        }
        return idValue;
    }

    @Override
    public String cacheKey(Object value) {
        return this.scalarType.format(value);
    }

    @Override
    public String cacheKeyFromBean(EntityBean bean) {
        Object value = this.idProperty.getValue(bean);
        return this.scalarType.format(value);
    }
}

