/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.event.BeanQueryRequest;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import io.ebeaninternal.server.el.ElPropertyValue;

abstract class AbstractExpression
implements SpiExpression {
    protected String propName;

    protected AbstractExpression(String propName) {
        this.propName = propName;
    }

    @Override
    public void prefixProperty(String path) {
        this.propName = path + "." + this.propName;
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        return false;
    }

    @Override
    public void simplify() {
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public SpiExpression copyForPlanKey() {
        return this;
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return this.propertyNestedPath(this.propName, desc);
    }

    protected String propertyNestedPath(String propertyName, BeanDescriptor<?> desc) {
        ElPropertyDeploy elProp;
        if (propertyName != null && (elProp = desc.elPropertyDeploy(propertyName)) != null && elProp.containsMany()) {
            return SplitName.begin((String)this.propName);
        }
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        this.propertyContainsMany(this.propName, desc, manyWhereJoin);
    }

    protected void propertyContainsMany(String propertyName, BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        ElPropertyDeploy elProp;
        if (propertyName != null && (elProp = desc.elPropertyDeploy(propertyName)) != null) {
            if (elProp.containsFormulaWithJoin()) {
                manyWhereJoin.addFormulaWithJoin(propertyName);
            }
            if (elProp.containsMany()) {
                manyWhereJoin.add(elProp);
                if (elProp.isAggregation()) {
                    manyWhereJoin.setAggregation();
                }
            }
        }
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        validation.validate(this.propName);
    }

    protected final ElPropertyValue getElProp(SpiExpressionRequest request) {
        return request.getBeanDescriptor().elGetValue(this.propName);
    }
}

