/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanCollectionUtil;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.IntersectionRow;
import io.ebeaninternal.server.persist.DefaultPersister;
import io.ebeaninternal.server.persist.DeleteMode;
import io.ebeaninternal.server.persist.DmlUtil;
import io.ebeaninternal.server.persist.SaveManyBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SaveManyBeans
extends SaveManyBase {
    private static final Logger log = LoggerFactory.getLogger(SaveManyBeans.class);
    private final boolean cascade;
    private final boolean publish;
    private final BeanDescriptor<?> targetDescriptor;
    private final boolean isMap;
    private final boolean saveRecurseSkippable;
    private final DeleteMode deleteMode;
    private final boolean untouchedBeanCollection;
    private final Collection<?> collection;
    private int sortOrder;

    SaveManyBeans(DefaultPersister persister, boolean insertedParent, BeanPropertyAssocMany<?> many, EntityBean parentBean, PersistRequestBean<?> request) {
        super(persister, insertedParent, many, parentBean, request);
        this.cascade = many.cascadeInfo().isSave();
        this.publish = request.isPublish();
        this.targetDescriptor = many.targetDescriptor();
        this.isMap = many.manyType().isMap();
        this.saveRecurseSkippable = many.isSaveRecurseSkippable();
        this.deleteMode = this.targetDescriptor.isSoftDelete() ? DeleteMode.SOFT : DeleteMode.HARD;
        this.untouchedBeanCollection = this.untouchedBeanCollection();
        this.collection = this.cascade ? BeanCollectionUtil.getActualEntries(this.value) : null;
    }

    private boolean untouchedBeanCollection() {
        return this.value instanceof BeanCollection && !((BeanCollection)this.value).wasTouched();
    }

    @Override
    void save() {
        if (this.many.hasJoinTable()) {
            boolean saveIntersectionFromThisDirection = this.isSaveIntersection();
            if (this.cascade) {
                this.saveAssocManyDetails();
            }
            if (saveIntersectionFromThisDirection) {
                this.saveAssocManyIntersection();
            } else {
                this.resetModifyState();
            }
        } else {
            if (this.isModifyListenMode() || this.many.hasOrderColumn()) {
                this.removeAssocManyOrphans();
            }
            if (this.cascade) {
                this.saveAssocManyDetails();
            }
        }
        if (!this.insertedParent && !this.untouchedBeanCollection) {
            this.request.addUpdatedManyForL2Cache(this.many);
        }
    }

    private boolean isSaveIntersection() {
        if (!this.many.isManyToMany()) {
            return true;
        }
        return this.transaction.isSaveAssocManyIntersection(this.many.intersectionTableJoin().getTable(), this.many.descriptor().rootName());
    }

    private boolean isModifyListenMode() {
        return BeanCollection.ModifyListenMode.REMOVALS == this.many.modifyListenMode();
    }

    private void saveAssocManyDetails() {
        if (this.collection != null) {
            this.processDetails();
        }
    }

    private void processDetails() {
        BeanProperty orderColumn = null;
        boolean hasOrderColumn = this.many.hasOrderColumn();
        if (hasOrderColumn) {
            if (!this.insertedParent && this.canSkipForOrderColumn() && this.saveRecurseSkippable) {
                return;
            }
            orderColumn = this.targetDescriptor.orderColumn();
        }
        if (this.insertedParent) {
            this.targetDescriptor.preAllocateIds(this.collection.size());
        }
        if (!this.insertedParent && this.many.isOrphanRemoval() && this.request.isForcedUpdate()) {
            List<Object> detailIds = this.collectIds(this.collection, this.targetDescriptor, this.isMap);
            this.persister.deleteManyDetails(this.transaction, this.many.descriptor(), this.parentBean, this.many, detailIds, this.deleteMode);
        }
        this.transaction.depth(1);
        this.saveAllBeans(orderColumn);
        if (hasOrderColumn) {
            this.resetModifyState();
        }
        this.transaction.depth(-1);
    }

    private void saveAllBeans(BeanProperty orderColumn) {
        Object mapKeyValue = null;
        for (Object detailBean : this.collection) {
            boolean skipSavingThisBean;
            ++this.sortOrder;
            if (this.isMap) {
                Map.Entry entry = (Map.Entry)detailBean;
                mapKeyValue = entry.getKey();
                detailBean = entry.getValue();
            }
            if (!(detailBean instanceof EntityBean)) continue;
            EntityBean detail = (EntityBean)detailBean;
            EntityBeanIntercept ebi = detail._ebean_getIntercept();
            if (this.many.hasJoinTable()) {
                skipSavingThisBean = this.targetDescriptor.isReference(ebi);
            } else {
                int originalOrder = 0;
                if (orderColumn != null && this.sortOrder != (originalOrder = detail._ebean_getIntercept().getSortOrder())) {
                    detail._ebean_intercept().setSortOrder(this.sortOrder);
                    ebi.setDirty(true);
                }
                if (this.targetDescriptor.isReference(ebi) && originalOrder == 0) {
                    skipSavingThisBean = true;
                } else if (ebi.isNewOrDirty()) {
                    skipSavingThisBean = false;
                    this.many.setJoinValuesToChild(this.parentBean, detail, mapKeyValue);
                } else {
                    skipSavingThisBean = this.saveRecurseSkippable;
                }
            }
            if (skipSavingThisBean) continue;
            this.persister.saveRecurse(detail, this.transaction, this.parentBean, this.request.flags());
            if (!this.many.hasOrderColumn()) continue;
            BeanDescriptor<?> beanDescriptor = this.many.descriptor();
            beanDescriptor.contextClear(this.transaction.getPersistenceContext(), beanDescriptor.getId(this.parentBean));
        }
    }

    private boolean canSkipForOrderColumn() {
        return this.untouchedBeanCollection && this.noDirtyBeans();
    }

    private boolean noDirtyBeans() {
        for (Object bean : this.collection) {
            if (!(bean instanceof EntityBean) || !((EntityBean)bean)._ebean_getIntercept().isDirty()) continue;
            return false;
        }
        return true;
    }

    private List<Object> collectIds(Collection<?> collection, BeanDescriptor<?> targetDescriptor, boolean isMap) {
        ArrayList<Object> detailIds = new ArrayList<Object>();
        for (Object detailBean : collection) {
            Object id;
            if (isMap) {
                detailBean = ((Map.Entry)detailBean).getValue();
            }
            if (!(detailBean instanceof EntityBean) || DmlUtil.isNullOrZero(id = targetDescriptor.id(detailBean))) continue;
            detailIds.add(id);
        }
        return detailIds;
    }

    private void saveAssocManyIntersection() {
        if (this.value == null) {
            return;
        }
        if (this.request.isQueueSaveMany()) {
            this.request.addSaveMany(this);
        } else {
            this.saveAssocManyIntersection(false);
        }
    }

    @Override
    public void saveBatch() {
        this.saveAssocManyIntersection(true);
    }

    private void saveAssocManyIntersection(boolean queue) {
        IntersectionRow intRow;
        BeanCollection manyValue;
        Collection additions;
        boolean vanillaCollection;
        boolean forcedUpdate = this.request.isForcedUpdate();
        boolean bl = vanillaCollection = !(this.value instanceof BeanCollection);
        if (vanillaCollection || forcedUpdate) {
            this.persister.deleteManyIntersection(this.parentBean, this.many, this.transaction, this.publish, queue);
        }
        Set deletions = null;
        if (this.insertedParent || vanillaCollection || forcedUpdate) {
            if (this.value instanceof Map) {
                additions = ((Map)this.value).values();
            } else if (this.value instanceof Collection) {
                additions = (Collection)this.value;
            } else {
                throw new PersistenceException("Unhandled ManyToMany type " + this.value.getClass().getName() + " for " + this.many.fullName());
            }
            if (!vanillaCollection) {
                manyValue = (BeanCollection)this.value;
                this.setListenMode(manyValue, this.many);
                manyValue.modifyReset();
            }
        } else {
            manyValue = (BeanCollection)this.value;
            if (this.setListenMode(manyValue, this.many)) {
                additions = manyValue.getActualDetails();
            } else {
                additions = manyValue.getModifyAdditions();
                deletions = manyValue.getModifyRemovals();
            }
            manyValue.modifyReset();
        }
        this.transaction.depth(1);
        if (deletions != null && !deletions.isEmpty()) {
            for (Object other : deletions) {
                EntityBean otherDelete = (EntityBean)other;
                intRow = this.many.buildManyToManyMapBean(this.parentBean, otherDelete, this.publish);
                SpiSqlUpdate sqlDelete = intRow.createDelete(this.server, DeleteMode.HARD);
                this.persister.executeOrQueue(sqlDelete, this.transaction, queue);
            }
        }
        if (additions != null && !additions.isEmpty()) {
            for (Object other : additions) {
                EntityBean otherBean = (EntityBean)other;
                if (deletions != null && deletions.remove(otherBean)) {
                    String m = "Inserting and Deleting same object? " + otherBean;
                    if (this.transaction.isLogSummary()) {
                        this.transaction.logSummary(m);
                    }
                    log.warn(m);
                    continue;
                }
                if (!this.many.hasImportedId(otherBean)) {
                    throw new PersistenceException("ManyToMany bean " + otherBean + " does not have an Id value.");
                }
                intRow = this.many.buildManyToManyMapBean(this.parentBean, otherBean, this.publish);
                SpiSqlUpdate sqlInsert = intRow.createInsert(this.server);
                this.persister.executeOrQueue(sqlInsert, this.transaction, queue);
            }
        }
        this.transaction.depth(-1);
    }

    private boolean isChangedProperty() {
        return this.parentBean._ebean_getIntercept().isChangedProperty(this.many.propertyIndex());
    }

    private void removeAssocManyOrphans() {
        if (this.value == null) {
            return;
        }
        if (!(this.value instanceof BeanCollection)) {
            if (!this.insertedParent && this.cascade && this.isChangedProperty()) {
                this.persister.addToFlushQueue(this.many.deleteByParentId(this.request.beanId(), null), this.transaction, 0);
            }
        } else {
            BeanCollection c = (BeanCollection)this.value;
            Set modifyRemovals = c.getModifyRemovals();
            if (this.insertedParent) {
                c.setModifyListening(this.many.modifyListenMode());
            }
            if (!this.many.hasOrderColumn()) {
                c.modifyReset();
            }
            if (modifyRemovals != null && !modifyRemovals.isEmpty()) {
                for (Object removedBean : modifyRemovals) {
                    EntityBean eb;
                    if (!(removedBean instanceof EntityBean) || !(eb = (EntityBean)removedBean)._ebean_intercept().isOrphanDelete()) continue;
                    this.persister.deleteRequest(this.persister.createDeleteRemoved(removedBean, this.transaction, this.request.flags()));
                }
            }
        }
    }

    private boolean setListenMode(BeanCollection<?> manyValue, BeanPropertyAssocMany<?> prop) {
        BeanCollection.ModifyListenMode mode = manyValue.getModifyListening();
        if (mode == null) {
            manyValue.setModifyListening(prop.modifyListenMode());
            return true;
        }
        return false;
    }
}

